package artifacts

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// DataFlowDebugSessionClient is the client for the DataFlowDebugSession methods of the Artifacts service.
type DataFlowDebugSessionClient struct {
	BaseClient
}

// NewDataFlowDebugSessionClient creates an instance of the DataFlowDebugSessionClient client.
func NewDataFlowDebugSessionClient(endpoint string) DataFlowDebugSessionClient {
	return DataFlowDebugSessionClient{New(endpoint)}
}

// AddDataFlow add a data flow into debug session.
// Parameters:
// request - data flow debug session definition with debug content.
func (client DataFlowDebugSessionClient) AddDataFlow(ctx context.Context, request DataFlowDebugPackage) (result AddDataFlowToDebugSessionResponse, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DataFlowDebugSessionClient.AddDataFlow")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: request,
			Constraints: []validation.Constraint{{Target: "request.DataFlow", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "request.DataFlow.Properties", Name: validation.Null, Rule: true, Chain: nil}}},
				{Target: "request.Staging", Name: validation.Null, Rule: false,
					Chain: []validation.Constraint{{Target: "request.Staging.LinkedService", Name: validation.Null, Rule: false,
						Chain: []validation.Constraint{{Target: "request.Staging.LinkedService.Type", Name: validation.Null, Rule: true, Chain: nil},
							{Target: "request.Staging.LinkedService.ReferenceName", Name: validation.Null, Rule: true, Chain: nil},
						}},
					}}}}}); err != nil {
		return result, validation.NewError("artifacts.DataFlowDebugSessionClient", "AddDataFlow", err.Error())
	}

	req, err := client.AddDataFlowPreparer(ctx, request)
	if err != nil {
		err = autorest.NewErrorWithError(err, "artifacts.DataFlowDebugSessionClient", "AddDataFlow", nil, "Failure preparing request")
		return
	}

	resp, err := client.AddDataFlowSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "artifacts.DataFlowDebugSessionClient", "AddDataFlow", resp, "Failure sending request")
		return
	}

	result, err = client.AddDataFlowResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "artifacts.DataFlowDebugSessionClient", "AddDataFlow", resp, "Failure responding to request")
	}

	return
}

// AddDataFlowPreparer prepares the AddDataFlow request.
func (client DataFlowDebugSessionClient) AddDataFlowPreparer(ctx context.Context, request DataFlowDebugPackage) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"endpoint": client.Endpoint,
	}

	const APIVersion = "2019-06-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("{endpoint}", urlParameters),
		autorest.WithPath("/addDataFlowToDebugSession"),
		autorest.WithJSON(request),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// AddDataFlowSender sends the AddDataFlow request. The method will close the
// http.Response Body if it receives an error.
func (client DataFlowDebugSessionClient) AddDataFlowSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// AddDataFlowResponder handles the response to the AddDataFlow request. The method always
// closes the http.Response Body.
func (client DataFlowDebugSessionClient) AddDataFlowResponder(resp *http.Response) (result AddDataFlowToDebugSessionResponse, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateDataFlowDebugSession creates a data flow debug session.
// Parameters:
// request - data flow debug session definition
func (client DataFlowDebugSessionClient) CreateDataFlowDebugSession(ctx context.Context, request CreateDataFlowDebugSessionRequest) (result DataFlowDebugSessionCreateDataFlowDebugSessionFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DataFlowDebugSessionClient.CreateDataFlowDebugSession")
		defer func() {
			sc := -1
			if result.Response() != nil {
				sc = result.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: request,
			Constraints: []validation.Constraint{{Target: "request.DataBricksLinkedService", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "request.DataBricksLinkedService.Properties", Name: validation.Null, Rule: true,
					Chain: []validation.Constraint{{Target: "request.DataBricksLinkedService.Properties.ConnectVia", Name: validation.Null, Rule: false,
						Chain: []validation.Constraint{{Target: "request.DataBricksLinkedService.Properties.ConnectVia.Type", Name: validation.Null, Rule: true, Chain: nil},
							{Target: "request.DataBricksLinkedService.Properties.ConnectVia.ReferenceName", Name: validation.Null, Rule: true, Chain: nil},
						}},
					}},
				}}}}}); err != nil {
		return result, validation.NewError("artifacts.DataFlowDebugSessionClient", "CreateDataFlowDebugSession", err.Error())
	}

	req, err := client.CreateDataFlowDebugSessionPreparer(ctx, request)
	if err != nil {
		err = autorest.NewErrorWithError(err, "artifacts.DataFlowDebugSessionClient", "CreateDataFlowDebugSession", nil, "Failure preparing request")
		return
	}

	result, err = client.CreateDataFlowDebugSessionSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "artifacts.DataFlowDebugSessionClient", "CreateDataFlowDebugSession", result.Response(), "Failure sending request")
		return
	}

	return
}

// CreateDataFlowDebugSessionPreparer prepares the CreateDataFlowDebugSession request.
func (client DataFlowDebugSessionClient) CreateDataFlowDebugSessionPreparer(ctx context.Context, request CreateDataFlowDebugSessionRequest) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"endpoint": client.Endpoint,
	}

	const APIVersion = "2019-06-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("{endpoint}", urlParameters),
		autorest.WithPath("/createDataFlowDebugSession"),
		autorest.WithJSON(request),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateDataFlowDebugSessionSender sends the CreateDataFlowDebugSession request. The method will close the
// http.Response Body if it receives an error.
func (client DataFlowDebugSessionClient) CreateDataFlowDebugSessionSender(req *http.Request) (future DataFlowDebugSessionCreateDataFlowDebugSessionFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		return
	}
	future.Future, err = azure.NewFutureFromResponse(resp)
	return
}

// CreateDataFlowDebugSessionResponder handles the response to the CreateDataFlowDebugSession request. The method always
// closes the http.Response Body.
func (client DataFlowDebugSessionClient) CreateDataFlowDebugSessionResponder(resp *http.Response) (result CreateDataFlowDebugSessionResponse, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteDataFlowDebugSession deletes a data flow debug session.
// Parameters:
// request - data flow debug session definition for deletion
func (client DataFlowDebugSessionClient) DeleteDataFlowDebugSession(ctx context.Context, request DeleteDataFlowDebugSessionRequest) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DataFlowDebugSessionClient.DeleteDataFlowDebugSession")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeleteDataFlowDebugSessionPreparer(ctx, request)
	if err != nil {
		err = autorest.NewErrorWithError(err, "artifacts.DataFlowDebugSessionClient", "DeleteDataFlowDebugSession", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteDataFlowDebugSessionSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "artifacts.DataFlowDebugSessionClient", "DeleteDataFlowDebugSession", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteDataFlowDebugSessionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "artifacts.DataFlowDebugSessionClient", "DeleteDataFlowDebugSession", resp, "Failure responding to request")
	}

	return
}

// DeleteDataFlowDebugSessionPreparer prepares the DeleteDataFlowDebugSession request.
func (client DataFlowDebugSessionClient) DeleteDataFlowDebugSessionPreparer(ctx context.Context, request DeleteDataFlowDebugSessionRequest) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"endpoint": client.Endpoint,
	}

	const APIVersion = "2019-06-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("{endpoint}", urlParameters),
		autorest.WithPath("/deleteDataFlowDebugSession"),
		autorest.WithJSON(request),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteDataFlowDebugSessionSender sends the DeleteDataFlowDebugSession request. The method will close the
// http.Response Body if it receives an error.
func (client DataFlowDebugSessionClient) DeleteDataFlowDebugSessionSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// DeleteDataFlowDebugSessionResponder handles the response to the DeleteDataFlowDebugSession request. The method always
// closes the http.Response Body.
func (client DataFlowDebugSessionClient) DeleteDataFlowDebugSessionResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByClosing())
	result.Response = resp
	return
}

// ExecuteCommand execute a data flow debug command.
// Parameters:
// request - data flow debug command definition.
func (client DataFlowDebugSessionClient) ExecuteCommand(ctx context.Context, request DataFlowDebugCommandRequest) (result DataFlowDebugSessionExecuteCommandFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DataFlowDebugSessionClient.ExecuteCommand")
		defer func() {
			sc := -1
			if result.Response() != nil {
				sc = result.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: request,
			Constraints: []validation.Constraint{{Target: "request.SessionID", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewError("artifacts.DataFlowDebugSessionClient", "ExecuteCommand", err.Error())
	}

	req, err := client.ExecuteCommandPreparer(ctx, request)
	if err != nil {
		err = autorest.NewErrorWithError(err, "artifacts.DataFlowDebugSessionClient", "ExecuteCommand", nil, "Failure preparing request")
		return
	}

	result, err = client.ExecuteCommandSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "artifacts.DataFlowDebugSessionClient", "ExecuteCommand", result.Response(), "Failure sending request")
		return
	}

	return
}

// ExecuteCommandPreparer prepares the ExecuteCommand request.
func (client DataFlowDebugSessionClient) ExecuteCommandPreparer(ctx context.Context, request DataFlowDebugCommandRequest) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"endpoint": client.Endpoint,
	}

	const APIVersion = "2019-06-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("{endpoint}", urlParameters),
		autorest.WithPath("/executeDataFlowDebugCommand"),
		autorest.WithJSON(request),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ExecuteCommandSender sends the ExecuteCommand request. The method will close the
// http.Response Body if it receives an error.
func (client DataFlowDebugSessionClient) ExecuteCommandSender(req *http.Request) (future DataFlowDebugSessionExecuteCommandFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		return
	}
	future.Future, err = azure.NewFutureFromResponse(resp)
	return
}

// ExecuteCommandResponder handles the response to the ExecuteCommand request. The method always
// closes the http.Response Body.
func (client DataFlowDebugSessionClient) ExecuteCommandResponder(resp *http.Response) (result DataFlowDebugCommandResponse, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// QueryDataFlowDebugSessionsByWorkspace query all active data flow debug sessions.
func (client DataFlowDebugSessionClient) QueryDataFlowDebugSessionsByWorkspace(ctx context.Context) (result QueryDataFlowDebugSessionsResponsePage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DataFlowDebugSessionClient.QueryDataFlowDebugSessionsByWorkspace")
		defer func() {
			sc := -1
			if result.qdfdsr.Response.Response != nil {
				sc = result.qdfdsr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.queryDataFlowDebugSessionsByWorkspaceNextResults
	req, err := client.QueryDataFlowDebugSessionsByWorkspacePreparer(ctx)
	if err != nil {
		err = autorest.NewErrorWithError(err, "artifacts.DataFlowDebugSessionClient", "QueryDataFlowDebugSessionsByWorkspace", nil, "Failure preparing request")
		return
	}

	resp, err := client.QueryDataFlowDebugSessionsByWorkspaceSender(req)
	if err != nil {
		result.qdfdsr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "artifacts.DataFlowDebugSessionClient", "QueryDataFlowDebugSessionsByWorkspace", resp, "Failure sending request")
		return
	}

	result.qdfdsr, err = client.QueryDataFlowDebugSessionsByWorkspaceResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "artifacts.DataFlowDebugSessionClient", "QueryDataFlowDebugSessionsByWorkspace", resp, "Failure responding to request")
	}

	return
}

// QueryDataFlowDebugSessionsByWorkspacePreparer prepares the QueryDataFlowDebugSessionsByWorkspace request.
func (client DataFlowDebugSessionClient) QueryDataFlowDebugSessionsByWorkspacePreparer(ctx context.Context) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"endpoint": client.Endpoint,
	}

	const APIVersion = "2019-06-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithCustomBaseURL("{endpoint}", urlParameters),
		autorest.WithPath("/queryDataFlowDebugSessions"),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// QueryDataFlowDebugSessionsByWorkspaceSender sends the QueryDataFlowDebugSessionsByWorkspace request. The method will close the
// http.Response Body if it receives an error.
func (client DataFlowDebugSessionClient) QueryDataFlowDebugSessionsByWorkspaceSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// QueryDataFlowDebugSessionsByWorkspaceResponder handles the response to the QueryDataFlowDebugSessionsByWorkspace request. The method always
// closes the http.Response Body.
func (client DataFlowDebugSessionClient) QueryDataFlowDebugSessionsByWorkspaceResponder(resp *http.Response) (result QueryDataFlowDebugSessionsResponse, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// queryDataFlowDebugSessionsByWorkspaceNextResults retrieves the next set of results, if any.
func (client DataFlowDebugSessionClient) queryDataFlowDebugSessionsByWorkspaceNextResults(ctx context.Context, lastResults QueryDataFlowDebugSessionsResponse) (result QueryDataFlowDebugSessionsResponse, err error) {
	req, err := lastResults.queryDataFlowDebugSessionsResponsePreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "artifacts.DataFlowDebugSessionClient", "queryDataFlowDebugSessionsByWorkspaceNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.QueryDataFlowDebugSessionsByWorkspaceSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "artifacts.DataFlowDebugSessionClient", "queryDataFlowDebugSessionsByWorkspaceNextResults", resp, "Failure sending next results request")
	}
	result, err = client.QueryDataFlowDebugSessionsByWorkspaceResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "artifacts.DataFlowDebugSessionClient", "queryDataFlowDebugSessionsByWorkspaceNextResults", resp, "Failure responding to next results request")
	}
	return
}

// QueryDataFlowDebugSessionsByWorkspaceComplete enumerates all values, automatically crossing page boundaries as required.
func (client DataFlowDebugSessionClient) QueryDataFlowDebugSessionsByWorkspaceComplete(ctx context.Context) (result QueryDataFlowDebugSessionsResponseIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DataFlowDebugSessionClient.QueryDataFlowDebugSessionsByWorkspace")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.QueryDataFlowDebugSessionsByWorkspace(ctx)
	return
}
