// Copyright limiting-factor <limiting-factor@posteo.com>
// SPDX-License-Identifier: MIT

package f3

import (
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
)

func TestF3Reference(t *testing.T) {
	ref := "reference"
	r := NewReference(ref)
	assert.Equal(t, ref, r.GetID())
	otherRef := "other"
	r.SetID(otherRef)
	assert.Equal(t, otherRef, r.GetID())
	r.Set(otherRef)
	assert.Equal(t, otherRef, r.Get())
	assert.True(t, r.Equal(*r))

	m, err := r.MarshalJSON()
	require.NoError(t, err)
	u := NewReference("???")
	require.NoError(t, u.UnmarshalJSON(m))
	assert.True(t, r.Equal(*u))

	assert.False(t, r.IsNil())
	r.SetID("")
	assert.True(t, r.IsNil())
	r.SetID("0")
	assert.True(t, r.IsNil())

	var nilRef *Reference
	assert.True(t, nilRef.IsNil())
}

func TestF3Common(t *testing.T) {
	id := "ID"
	c := NewCommon(id)
	assert.Equal(t, id, c.GetID())
	assert.Equal(t, id, c.GetName())
	otherID := "otherID"
	c.SetID(otherID)
	assert.Equal(t, otherID, c.GetID())

	assert.False(t, c.IsNil())
	c.SetID("")
	assert.True(t, c.IsNil())
	c.SetID("0")
	assert.True(t, c.IsNil())

	var nilCommon *Common
	assert.True(t, nilCommon.IsNil())
}
