/*
 * Copyright 2013 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * You may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.codehaus.gmavenplus.mojo;

import org.apache.maven.project.MavenProject;
import org.junit.Before;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

import java.io.File;

import static org.mockito.Mockito.doReturn;


/**
 * Unit tests for the AbstractGroovySourcesMojo class.
 *
 * @author Keegan Witt
 */
public class AbstractGroovySourcesMojoTest {
    private TestMojo testMojo;
    @Mock
    private MavenProject project;
    @Mock
    private File basedir;

    @Before
    public void setup() {
        MockitoAnnotations.initMocks(this);
        testMojo = new TestMojo();
        doReturn(basedir).when(project).getBasedir();
        testMojo.project = project;
    }

    public class TestMojo extends AbstractGroovySourcesMojo {
        @Override
        public void execute() { }
    }

}
