#include "vektor.h"
#include "printer.h"
#include "parser.h"
#include "gfanapplication.h"
#include "binomial.h"
#include "latticeideal.h"
#include "field_rationals.h"
#include "lll.h"
#include "linalg.h"
#include "subspace.h"

class LatticeApplication : public GFanApplication
{
public:
  bool includeInDefaultInstallation()
  {
    return false;
  }
  LatticeApplication()
  {
    registerOptions();
  }
  const char *name()
  {
    return "_lattice";
  }
  int main()
  {
    FileParser p(Stdin);

    IntegerVectorList ivl=p.parseIntegerVectorList();
    IntegerMatrix A=rowsToIntegerMatrix(ivl);//.transposed();

    AsciiPrinter P(stdout);

    fprintf(Stdout,"Input matrix:\n");
    P.printVectorList(A.getRows());


    fprintf(Stdout,"Hermite normal form matrix:\n");
    FieldMatrix Af=integerMatrixToFieldMatrix(A,Q);
    Af.reduce(false,true);
    Af.printMatrix(P);


    fprintf(Stdout,"LLL-Reduced matrix:\n");


    IntegerMatrix B2=A;
    IntegerMatrix M=mlll(B2);


    P.printVectorList(B2.getRows());


    fprintf(Stdout,"Performed transformation:\n");
    P.printVectorList(M.getRows());

    int kerdim=0;
    while((kerdim<A.getHeight())&&(B2[kerdim].toVector().isZero()))
      kerdim++;

    IntegerMatrix ret(kerdim,A.getHeight());

    for(int i=0;i<kerdim;i++)
      ret[i]=M[i];

    fprintf(Stdout,"Lattice Kernel:\n");
    P.printVectorList(ret.getRows());

    {
      IntegerMatrix B=A.transposed();
      PolynomialRing R(Q,B.getWidth());
      PolynomialSet I(R);
      for(int i=0;i!=B.getHeight();i++)
        I.push_back(vectorToPolynomial(R,B[i]));
      pout<<R<<I;
    }
    return 0;
  }
  const char *helpText()
  {
    return "This program computes various information about the lattice generated by the rows of the input matrix.\n";
  }
};

static LatticeApplication theApplication;
