# X11 options
complete -c firefox -l display -r -d "X display to use"
complete -c firefox -l sync -d "Make X calls synchronous"
complete -c firefox -l g-fatal-warnings -d "Make all warnings fatal"

# Firefox options
complete -c firefox -s h -l help -d "Print this message"
complete -c firefox -s v -l version -d "Print Firefox version"
complete -c firefox -l full-version -d "Print Firefox version, build and platform build ids"
complete -c firefox -s P -r -d "Start this profile" -fa '(string replace -rf "^Name=(.*)" \'$1\' < ~/.mozilla/firefox/profiles.ini)'
complete -c firefox -l profile -r -d "Start with profile at <path>"
complete -c firefox -l migration -d "Start with migration wizard"
complete -c firefox -l ProfileManager -d "Start with ProfileManager"
complete -c firefox -l no-remote -d "Do not accept or send remote commands implies --new-instance"
complete -c firefox -l new-instance -d "Open new instance, not a new window in running instance"
complete -c firefox -l safe-mode -d "Disables extensions and themes for this session"
complete -c firefox -l allow-downgrade -d "Allows downgrading a profile"
complete -c firefox -l MOZ_LOG -rf -d "Treated as MOZ_LOG=<modules> environment variable, overrides it"
complete -c firefox -l MOZ_LOG_FILE -r -d "Treated as MOZ_LOG_FILE=<file> environment variable, overrides it"
complete -c firefox -l headless -d "Run without a GUI"
complete -c firefox -l jsdebugger -d "Open the Browser Toolbox"
complete -c firefox -l wait-for-jsdebugger -d "Spin event loop until JS debugger connects"
complete -c firefox -l start-debugger-server -d "Start the devtools server on a TCP port or Unix domain socket path"
complete -c firefox -l browser -d "Open a browser window"
complete -c firefox -l new-window -r -d "Open <url> in a new window"
complete -c firefox -l new-tab -r -d "Open <url> in a new tab"
complete -c firefox -l private-window -r -d "Open <url> in a new private window"
complete -c firefox -l preferences -d "Open Preferences dialog"
complete -c firefox -l screenshot -d "Save screenshot to <path> or in working directory"
complete -c firefox -rf -l window-size -d "Width and optionally height of screenshot"
complete -c firefox -l search -r -d "Search <term> with your default search engine"
complete -c firefox -l setDefaultBrowser -d "Set this app as the default browser"
complete -c firefox -l first-startup -d "Run post-install actions before opening a new window"
complete -c firefox -l kiosk -d "Start the browser in kiosk mode"
complete -c firefox -l disable-pinch -d "Disable touch-screen and touch-pad pinch gestures"
complete -c firefox -l jsconsole -d "Open the Browser Console"
complete -c firefox -l devtools -d "Open DevTools on initial load"
complete -c firefox -l marionette -d "Enable remote control server"
complete -c firefox -f -l remote-debugging-port -d "Start the Firefox Remote Agent"
complete -c firefox -f -l remote-allow-hosts -r -d "Values of the Host header to allow for incoming requests"
complete -c firefox -f -l remote-allow-origins -r -d "Values of the Origin header to allow for incoming requests"
