#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# Fenrir TTY screen reader
# By Chrys, Storm Dragon, and contributors.


from fenrirscreenreader.core.i18n import _


class command:
    def __init__(self):
        pass

    def initialize(self, environment):
        self.env = environment

    def shutdown(self):
        pass

    def get_description(self):
        return "No Description found"

    def run(self):
        # try to detect the tab completion by cursor change
        x_move = (
            self.env["screen"]["new_cursor"]["x"]
            - self.env["screen"]["old_cursor"]["x"]
        )
        if x_move <= 0:
            return
        if self.env["runtime"]["InputManager"].get_shortcut_type() in ["KEY"]:
            if not (
                self.env["runtime"]["InputManager"].get_last_deepest_input()
                in [["KEY_TAB"]]
            ):
                if x_move < 5:
                    return
        elif self.env["runtime"]["InputManager"].get_shortcut_type() in [
            "BYTE"
        ]:
            found = False
            for currByte in self.env["runtime"][
                "ByteManager"
            ].get_last_byte_key():
                if currByte == 9:
                    found = True
            if not found:
                if x_move < 5:
                    return
        # is there any change?
        if not self.env["runtime"]["ScreenManager"].is_delta():
            return
        if not x_move == len(self.env["screen"]["new_delta"]):
            return
        # filter unneded space on word begin
        curr_delta = self.env["screen"]["new_delta"]
        if (
            len(curr_delta.strip()) != len(curr_delta)
            and curr_delta.strip() != ""
        ):
            curr_delta = curr_delta.strip()
        self.env["runtime"]["OutputManager"].present_text(
            curr_delta, interrupt=True, announce_capital=True, flush=False
        )

    def set_callback(self, callback):
        pass
