#define XERR "memoryaccess"
#include "memoryaccess.ih"

    // by extend.cc

MemoryAccess *MemoryAccess::refresh(size_t offset)
{
        // cf: bufLimits
    d_blockBegin = offset / d_blockSize * d_blockSize;  // cpt. the block
    d_blockEnd = d_blockBegin + d_blockSize;            // boundaries

    if (d_blockEnd > d_maxEnd)
        d_maxEnd = d_blockEnd;

    size_t nBlocks = divPlus(d_maxEnd, d_blockSize);    // new #blocks

    int id = getID(memoryAccessSize(nBlocks), d_accessMode);
    
                                                    // get its location
    MemoryAccess *ptr = static_cast<MemoryAccess *>(connect(id));

    if (ptr == 0)
        throw Exception{} << XERR ": can't connect memory for a "
                            "MemoryAccess object (id = " << id << ')';

    new (ptr) MemoryAccess(id, d_accessMode, nBlocks, d_blockSize);

    ptr->cpFrom(*this);

    return ptr;
}

//xerr("offset: " << offset << ", blockEnd: " << d_blockEnd);
//xerr("nBlocks: " << nBlocks);

