#include "generator.ih"

namespace
{
    DateTime dtime(DateTime::LOCALTIME);
}

void Generator::filter(istream &in, ostream &out, bool header) const
{
    Terminal::inserter(&Terminal::plainName);

    if (header)
        out << "// Generated by Bisonc++ V" << ::version << 
                " on " << dtime.rfc2822() << '\n' <<
                '\n';

    while (getline(in, d_line))
    {
        if (d_line.find("$insert") == 0)
        {
            insert(out);
            continue;
        }

        replaceBaseFlag(d_line);

        out << d_line << '\n';
    }
}


