# Contribute to the code

Follow the steps below to set up your development environment to get started working on new features for Incus.

## Install Incus from source

To build the dependencies, follow the instructions in {ref}`installing_from_source`.

## Add your fork as a remote

After setting up your build environment, add your GitHub fork as a remote:

    git remote add myfork git@github.com:<your_username>/incus.git
    git remote update

Then switch to it:

    git checkout myfork/main

## Build Incus

Finally, you should be able to run `make` inside the repository and build your fork of the project.

At this point, you most likely want to create a new branch for your changes on your fork:

```bash
git checkout -b [name_of_your_new_branch]
git push myfork [name_of_your_new_branch]
```

## Important notes for new Incus contributors

- Persistent data is stored in the `INCUS_DIR` directory, which is generated by `incus admin init`.
  The `INCUS_DIR` defaults to `/var/lib/incus`.
- As you develop, you may want to change the `INCUS_DIR` for your fork of Incus so as to avoid version conflicts.
- Binaries compiled from your source will be generated in the `$(go env GOPATH)/bin` directory by default.
   - You will need to explicitly invoke these binaries (not the global `incusd` you may have installed) when testing your changes.
   - You may choose to create an alias in your `~/.bashrc` to call these binaries with the appropriate flags more conveniently.
- If you have a `systemd` service configured to run the Incus daemon from a previous installation of Incus, you may want to disable it to avoid version conflicts.
