/*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*\

File: octtypevx.h

Copyright (c) 2001 Octasic Inc. All rights reserved.

Description: This file defines the base storage types for the VxWorks
			 environment.

This source code is Octasic Confidential. Use of and access to this code
is covered by the Octasic Device Enabling Software License Agreement. 
Acknowledgement of the Octasic Device Enabling Software License was 
required for access to this code. A copy was also provided with the release.


$Octasic_Release: OCT610xAPI-01.00-PR37 $

$Octasic_Revision: 5 $

\*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*/

#ifndef __OCTTYPEVX_H__
#define __OCTTYPEVX_H__

/*--------------------------------------------------------------------------
	C language
----------------------------------------------------------------------------*/

#ifdef __cplusplus
extern "C" {
#endif

#include "vxWorks.h" 

/* 16-bit pointer integer */
typedef unsigned short	*PUINT16;
typedef signed short	*PINT16;

/* 8-bit integer pointer */
typedef unsigned char	*PUINT8;
typedef signed char		*PINT8;

/* 32-bit integer pointer */
typedef INT32 *			PINT32;
typedef UINT32 *		PUINT32;

/* Long integer pointer */
#ifndef DATATYPE_H				/*Intel library for file system definition*/
typedef	long 			LONG;
#endif
typedef	long *			PLONG;
typedef	unsigned long *	PULONG;

/* Short integer pointer */
typedef	short 			SHORT;
typedef	short *			PSHORT;
typedef	unsigned short *PUSHORT;

/* 8-bit integer*/
#if	(CPU!=SIMNT) && !defined(DATATYPE_H)
typedef	char 			BYTE;
#endif


typedef	BYTE *			PBYTE;

/* Character and strings */
#ifndef DATATYPE_H				/*Intel library for file system definition*/
typedef char			CHAR;
#endif
typedef char *			PCHAR;
typedef	CHAR 			SZ;
typedef	CHAR *			PSZ;

/* Double integers */
typedef	double			DOUBLE;
typedef	double *		PDOUBLE;
typedef	float			FLOAT;
typedef	float *			PFLOAT;

typedef	void *			PVOID;

/* Booleans */
typedef	BOOL *			PBOOL;

/* Integers */
typedef int				INT;
typedef	int *			PINT;
typedef	unsigned int	PUINT;

/* Define pseudo-keywords IN and OUT if not defined yet */
#ifndef IN
#define IN		/* IN param */
#endif

#ifndef OUT
#define OUT		/* OUT param */
#endif

/* LONG LONG */
#define LLONG			signed long long
#define PLLONG			signed long long *
#define ULLONG			unsigned long long
#define PULLONG			unsigned long long *

#ifndef OPT
#define OPT		/* OPT param */
#endif

typedef	PSZ *	PPSZ;


/*--------------------------------------------------------------------------
	C language
----------------------------------------------------------------------------*/
#ifdef __cplusplus
}
#endif

#endif /* __OCTTYPEVX_H__ */
