.\" $XdotOrg: xc/doc/man/Xp/libXp.man,v 1.2 2005/10/18 02:12:17 alanc Exp $
.\"
.\" Copyright 1996 Hewlett-Packard Company
.\" Copyright 1996 International Business Machines Corp.
.\" Copyright 1996, 1999, 2004 Sun Microsystems, Inc.
.\" Copyright 1996 Novell, Inc.
.\" Copyright 1996 Digital Equipment Corp.
.\" Copyright 1996 Fujitsu Limited
.\" Copyright 1996 Hitachi, Ltd.
.\" Copyright 1996 X Consortium, Inc.
.\" 
.\" Permission is hereby granted, free of charge, to any person obtaining a 
.\" copy of this software and associated documentation files (the "Software"),
.\" to deal in the Software without restriction, including without limitation 
.\" the rights to use, copy, modify, merge, publish, distribute,
.\" sublicense, and/or sell copies of the Software, and to permit persons
.\" to whom the Software is furnished to do so, subject to the following
.\" conditions:
.\" 
.\" The above copyright notice and this permission notice shall be
.\" included in all copies or substantial portions of the Software.
.\" 
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
.\" EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
.\" DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
.\" OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR
.\" THE USE OR OTHER DEALINGS IN THE SOFTWARE.
.\" 
.\" Except as contained in this notice, the names of the copyright holders
.\" shall not be used in advertising or otherwise to promote the sale, use
.\" or other dealings in this Software without prior written authorization
.\" from said copyright holders.
.\"
.TH libXp 3Xp __xorgversion__ "XPRINT FUNCTIONS"
.SH NAME
libXp \- X Print Client Library
.SH SYNOPSIS
.B cc
[
.B flag... 
]
file...-lXp 
[
.B library...
]
.BR 
.nf
\&#include <X11/extensions/Print.h>
.fi      
.SH DESCRIPTION
.LP
libXp provides public APIs to allow client applications to render to non-display devices.

When an application wishes to print, it makes a display connection to the X print server and asks 
to see the list of 
printers available with an 
.I XpGetPrinterList() 
request. Once the application has selected a printer, it creates and sets a print context using 
.I XpCreateContext() 
and 
.I XpSetContext().
 
The Print Context represents the embodiment of the printer selected. It is initialized by the 
Xprint server at 
.I XpCreateContext() 
time to contain a printer's default capabilities, as well as, the description of its overall 
capabilties, and to maintain 
the state of settings on the printer, the state of rendering against the printer, and the rendered 
output. 

The Print Context affects how the DDX driver generates its page description language (PDL) and how 
the PDL is submitted to 
a spooler. The print context may also affect fonts and other elements in the dix layer of the X 
Print Server. The print 
contexts can be shared among processes. Applications can enlist the help of secondary processes to 
manipulate print options 
in the Print context rather than taking on the task directly.

Once an application has set options within the print context, it makes calls such as 
.I XpStartJob()  
to delineate jobs, documents, and pages within a sequence of normal X calls. 

A job is a collection of documents, where each document is in turn a collection of pages. When 
.I XpEndJob() 
is called, the resulting PDL is either sent to a print spooler or can be retrieved by the 
application itself.

The developer basically has to make changes to the X application to make use of the X Print 
Service.
.LP

A simple X application supplemented with some of the libXp routines might look like this:


.\" Note: C Comments and include statements in the sample code must use the 
.\" zero-width non-printing nroff entity \& to prevent the C pre-processor 
.\" from processing or stripping them out during the build

.nf

\&#include <X11/Xlib.h>
\&#include <X11/extensions/Print.h>

main()
{
    Display *pdpy;
    Screen *pscreen;
    Window pwin;
    XPPrinterList plist;
    XPContext pcontext;
    int plistCnt;
    char *attrPool;
\&#define NPOOLTYPES 5	
    XPAttributes poolType[NPOOLTYPES] = {XPJobAttr,XPDocAttr,XPPageAttr,
					 XPPrinterAttr,XPServerAttr};
    int i;
    unsigned short width, height;
    XRectangle rect;
    char *printServerName = ":1";
    char *mylaser = "varos";
	
    /\&*
     * connect to the X print server 
     *\&/
    pdpy = XOpenDisplay( printServerName );
	
    /\&*
     * see if the printer "mylaser" is available
     *\&/

    plist =  XpGetPrinterList (pdpy, mylaser, &plistCnt );

    /\&*
     * Initialize a print context representing "mylaser"
     *\&/

    pcontext = XpCreateContext( pdpy, plist[0].name );
    XpFreePrinterList( plist );

	/\&*
	 * Possibly modify attributes in the print context
	 *\&/
    for(i=0;i < NPOOLTYPES;i++) {
	if(attrPool = XpGetAttributes( pdpy, pcontext, poolType[i] )) {
	    /\&* twiddle attributes *\&/
	    /\&*
	      XpSetAttributes( pdpy, pcontext, poolType[i],
	                       attrPool, XPAttrMerge );
	    *\&/
	    XFree(attrPool);
	}
    }

    
    /\&*
     * Set a print server, then start a print job against it
     *\&/

    XpSetContext( pdpy, pcontext );
    XpStartJob( pdpy, XPSpool );

    /\&*
     * Generate the first page
     *\&/

    pscreen = XpGetScreenOfContext( pdpy, pcontext );
    XpGetPageDimensions( pdpy, pcontext, &width, &height,
			 &rect);
    pwin = XCreateSimpleWindow( pdpy, RootWindowOfScreen( pscreen ),
				rect.x, rect.y, rect.width, rect.height, 2,
				BlackPixelOfScreen( pscreen),
				WhitePixelOfScreen( pscreen));

    XpStartPage( pdpy, pwin );
    /\&* usual rendering stuff..... *\&/
    XpEndPage( pdpy ); 

    XpStartPage( pdpy, pwin );
    /\&* some more rendering.....   *\&/
    XpEndPage( pdpy );

    /\&*
     * End the print job - the final results are sent by the X print
     * server to the spooler sub system.
     *\&/

    XpEndJob( pdpy );
    XpDestroyContext( pdpy, pcontext );
    XCloseDisplay( pdpy );
}

.fi
.SH "SEE ALSO"
.BR Xprt (1),
.BR XpCreateContext (3Xp),
.BR XpDestroyContext (3Xp),
.BR XpEndJob (3Xp),
.BR XpEndPage (3Xp),
.BR XpFreePrinterList (3Xp),
.BR XpGetAttributes (3Xp),
.BR XpGetPageDimensions (3Xp),
.BR XpGetPrinterList (3Xp),
.BR XpSetAttributes (3Xp),
.BR XpSetContext (3Xp),
.BR XpStartJob (3Xp),
.BR XpStartPage (3Xp)

.I X Print Service Extension Library
