#ifndef XARCHIVE_SRC_WIDGETS_GTK
#define XARCHIVE_SRC_WIDGETS_GTK 1

#include"common.h"
#include<gtk/gtk.h>
#include<gdk/gdk.h>
#include<glib/gstdio.h>
#include<string.h>
#include<sys/wait.h>
#include<signal.h>
#include<unistd.h>
#include"icons/xarchive.xpm"

#define TEMP_NAME "xarchiveXXXXXX"

/* LOCAL DATA TYPES AND STRUCTURES */
typedef struct sel_data
{
  GtkTreeSelection *sel;
  gchar *dname;
  gboolean dirs;
} SelectionData;

typedef struct wrapper_data
{
  gchar *dir;
  gint index;
  gchar **argv;
} WrapperData;

/* GLOBAL VARIABLES */
GtkUIManager *UIMANAGER;
GtkNotebook *NOTEBOOK;
GtkWidget *EMPTY;
GtkWidget *MAIN_WINDOW;

/* EXTERNAL FUNCTIONS */
/* from my_strescape */
extern char * 
my_strescape(char *string);

/* from main.c */
int 
wrapper_cmd(gint ar_func, gchar **argv, gchar *dest); 

gchar *
get_wrapper(gchar *filename);

gchar *
wrapper_info(void);

/* from myfc.c */
void 
myfc_add_foreach_func(gchar *fpath, GtkListStore *myfc_ls);

GtkListStore *
make_myfc_ls(void);

GtkDialog *
make_myfc(gchar *archive, GtkListStore *fclist);

/* LOCAL FUNCTIONS */
/********************************/
/* treeview and model functions */
/********************************/
void 
render_cols(GtkTreeView *view, gchar *title, gint mcol);

GtkListStore *
make_liststore(void);

GtkWidget *
make_tree(GtkListStore *liststore);

GtkTreeView *
get_current_tree(void);

gchar *
get_current_archive(void);

void 
add_row(GtkListStore *liststore, gchar **ent);

void 
reload_current_tree(GtkTreeView *treeview);

gboolean
treeview_button_press(GtkWidget  *container,
             GdkEventButton *event,
             GtkUIManager *uimanager);

/**********************/
/* notebook functions */
/**********************/
void 
make_notebook_widgets(GtkWidget *container);

void 
add_page(gchar *archive);

/************************************/
/* empty page and message functions */
/************************************/
void
setup_opening_progress_bar(GtkWidget *pbwin, GtkWidget *pbar, gboolean *stopit);
void
wait_with_progress_bar(GPid pid, gint *wrapper_status, gint ar_func);

GtkWidget *
make_info_widget(gchar *msg);

void 
make_empty_page(GtkWidget *container);

gboolean 
message(GtkWidget *parentwin, gint type, gchar *text);

/*********************/
/* foreach functions */
/*********************/
void 
selected_foreach_func(GtkTreeModel *model,
                       GtkTreePath *path,
                       GtkTreeIter *iter,
                       WrapperData *wrapper);

gboolean 
sel_subdir_foreach_func(GtkTreeModel *model,
                                 GtkTreePath *path,
                                 GtkTreeIter *iter,
                                 SelectionData *seld);

gboolean 
unsel_subdir_foreach_func(GtkTreeModel *model,
                                 GtkTreePath *path,
                                 GtkTreeIter *iter,
                                 SelectionData *seld);

gboolean
test_selection_func(GtkTreeSelection *selection,
                    GtkTreeModel *model,
                    GtkTreePath *path,
                    gboolean path_currently_selected,
                    gpointer data);

gboolean 
add_foreach_func(GtkTreeModel *model, GtkTreePath *path, 
                  GtkTreeIter *iter, WrapperData *wrapper);

gboolean 
file_filter_func(const GtkFileFilterInfo *filter_info, gpointer data);

/*******************/
/* chooser widgets */
/*******************/
gchar *
askfor_existing_archive(void);

gchar *
askfor_new_archive(gchar *name);

gboolean
multi_file_chooser(gchar *archive, GtkListStore *filelist);

gchar *
askfor_extract_dir(void);

/******************************************/
/* openwith and default handler functions */
/******************************************/
GtkListStore *
get_openwith_cmdlist(gchar *cmdlist_path);

void
add_to_cmdlist(GtkListStore *cmdlist, gchar *command, gchar *cmdlist_path);

void
get_lastdir(void);

void
get_default_handler(void);

void
set_default_handler(gchar *command);

void
open_one_file(WrapperData *wrapper, gchar *command);

void 
default_handler_foreach_func(GtkTreeModel *model,
                             GtkTreePath  *path,
                             GtkTreeIter  *iter,
                             WrapperData  *wrapper);
gchar *
askfor_openwith_command(gchar *fname);

void 
openwith_foreach_func(GtkTreeModel *model, GtkTreePath  *path,
                      GtkTreeIter  *iter, WrapperData  *wrapper);

/**********************/
/* callback functions */
/**********************/
void
dummy_cb(GtkWidget *widget, gpointer data);

void 
open_cb(GtkWidget *widget, gpointer data);

void 
new_cb(GtkWidget *widget, gpointer data);

void 
close_cb(GtkWidget *widget, gpointer data);

void 
close_button_cb(GtkWidget *widget, gpointer data);

void 
extract_cb(GtkWidget *widget, gpointer data);

void
openwith_cb(GtkWidget *widget, gpointer data);

void
double_click_cb(void);

void
open_selected_files(gboolean use_default_handler);

void 
add_cb(GtkWidget *widget, gpointer data);

void 
remove_cb(GtkWidget *widget, gpointer data);

void 
select_all_cb(GtkWidget *widget, gpointer data);

void 
unselect_all_cb(GtkWidget *widget, gpointer data);

void 
wrapper_info_cb(GtkWidget *widget, gpointer data);

void
read_help_cb(GtkWidget *widget, gpointer data);

static gboolean
open_cancel_cb(GtkWidget *widget, gpointer data);

static gboolean
process_cancel_cb(GtkWidget *widget, gpointer data);

/************************/
/* ui manager functions */
/************************/
GtkUIManager * 
make_ui_widgets(GtkWidget *window, GtkWidget *container);

void 
add_ui_widget(GtkUIManager *uimanager, 
                   GtkWidget *widget, 
                   GtkContainer *container);

/******************************/
/* passed aurgument functions */
/******************************/
gint
ask_create_or_add(gchar *msg);

void
process_passed_arguments(ParsedArgs *pargs);

/*****************/
/* main function */
/*****************/
int 
make_widgets(ParsedArgs *pargs);

#endif
