<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:template match="/">
		<xsl:apply-templates select="ids"/>
	</xsl:template>

	<xsl:template match="ids">
		<document>
			<template pageSize="21cm,29.7cm" leftMargin="1.5cm" rightMargin="1.5cm" topMargin="1.5cm" bottomMargin="1.5cm" author="Generated by Tiny ERP">
				<pageTemplate id="main">
					<pageGraphics/>

					<frame id="col1" x1="2cm" y1="2.4cm" width="8cm" height="26cm"/>
					<frame id="col2" x1="11cm" y1="2.4cm" width="8cm" height="26cm"/>
				</pageTemplate>
			</template>

			<stylesheet>
				<blockTableStyle id="ids">
					<blockValign value="TOP"/>
					<blockAlignment value="RIGHT" start="-1,0" stop="-1,-1"/>
					<blockAlignment value="CENTER" start="0,0" stop="0,-1"/>
					<blockFont name="Helvetica-BoldOblique" size="12" start="0,0" stop="-1,0"/>
					<blockBackground colorName="grey" start="0,0" stop="-1,0"/>
					<blockTextColor colorName="white" start="0,0" stop="-1,0"/>
					<lineStyle kind="LINEBELOW" colorName="red" start="0,0" stop="-1,0"/>
					<lineStyle kind="LINEBELOW" colorName="black" start="0,-1" stop="-1,-1"/>
					<lineStyle kind="LINEBEFORE" colorName="grey" start="-1,0" stop="-1,-1"/>
					<lineStyle kind="LINEBEFORE" colorName="black" start="0,1" stop="0,-1"/>
					<lineStyle kind="LINEAFTER" colorName="black" start="-1,1" stop="-1,-1"/>
				</blockTableStyle>
			</stylesheet>
			
			<story>
				<blockTable colWidths="2cm, 6cm" repeatRows="1" style="ids">
					<tr>
						<td t="1">Ref.</td>
						<td t="1">Name</td>
					</tr>
					<xsl:apply-templates select="id">
						<xsl:sort data-type="number" select="ref"/>
						<xsl:sort select="name"/>
					</xsl:apply-templates>
				</blockTable>
			</story>
		</document>
	</xsl:template>

	<xsl:template match="id">
		<tr>
			<td><xsl:value-of select="ref"/></td>
			<td><para><xsl:value-of select="name"/></para></td>
		</tr>
	</xsl:template>
</xsl:stylesheet>
