/*******************************************************************************
 * Score Reading Trainer                                                       *
 * Copyright (C) 2004 by Jos Pablo Ezequiel Fernndez <pupeno@pupeno.com>     *
 *                                                                             *
 * This program is free software; you can redistribute it and/or               *
 * modify it under the terms of the GNU General Public License                 *
 * version 2 as published by the Free Software Foundation.                     *
 *                                                                             *
 * This program is distributed in the hope that it will be useful,             *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 * GNU General Public License for more details.                                *
 *                                                                             *
 * You should have received a copy of the GNU General Public License           *
 * along with this program; if not, write to the Free Software                 *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *******************************************************************************/

#ifndef _SCOREREADINGTRAINER_H_
#define _SCOREREADINGTRAINER_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kmainwindow.h>
#include <kdeversion.h>


class KToggleToolBarAction;
class ScoreReadingTrainerView;
template <class T> class QValueList;
/**
 * This is the main window of Score Reading Trainer and where everything begins.
 * This class manages the menues, the toolbars, the status bar.
 *
 * @short Main window class of Score Reading Trainer.
 * @author Jos Pablo Ezequiel "Pupeno" Fernndez <pupeno@pupeno.com>
 */
class ScoreReadingTrainer : public KMainWindow{
	Q_OBJECT
	public:
		/**
		 * Default Constructor
		 */
		ScoreReadingTrainer();

		/**
		 * Default Destructor
		 */
		virtual ~ScoreReadingTrainer();

	protected:
		/**
		 * This function is called when it is time for the app to save its
		 * properties for session management purposes. This properties are read 
		 * by @ref readProperties.
		 * @param config KConfig object used to save the properties.
		 */
		void saveProperties(KConfig *config);

		/**
		 * This function is called when this app is restored.  The KConfig
		 * object points to the session management config file that was saved
		 * with @ref saveProperties.
		 * @param config KConfig object used to read the properties.
		 */
		void readProperties(KConfig *config);


	private slots:
		/**
		 * Functio to start generating random notes and accepting input from the user.
		 */
		void start();

		/**
		 * Function to stop generating random notes, clean up the score, and stop accepting input from the user.
		 */
		void stop();

		/**
		 * Function to show the dialog to configure the shortcuts.
		 */
		void optionsConfigureKeys();
		
		/**
		 * Function to show the dialog to configure the toolbars.
		 */
		void optionsConfigureToolbars();
		
		/**
		 * Function to show the whole program configuration dialog.
		 */
		void optionsPreferences();
		
		/**
		 * Apply the configuration of the toolbars to the running session.
		 */
		void newToolbarConfig();

		/**
		 * Load the preferences for the application config file and apply them to the view.
		 */
		void loadPreferences();
		
	private:
		/**
		 * Setup the KActions (menus and toolbars).
		 */
		void setupActions();
		
		/**
		 * Set icons to contain sharps.
		 */
		void setSharpIcons();
		
		/**
		 * Set icons to contain flats.
		 */
		void setFlatIcons();

		/**
		 * Object ScoreReadingTrainerView
		 */
		ScoreReadingTrainerView *scoreReadingTrainerView;
		
		/**
		 * List of actions for the notes.
		 */
		QValueList<KAction *> noteActions;

#if !KDE_IS_VERSION(3,2,0)
		/**
		 * Togle action for hiding the main toolbar.
		 * Thise disappear in 3.2
		 */
		KToggleToolBarAction *mMainToolBarAction;

		/**
		 * Togle action for hiding the main toolbar
		 * Thise disappear in 3.2
		 */
		KToggleToolBarAction *mNotesToolBarAction;
#endif

		/**
		 * Action for starting the training.
		 */
		KAction *startAction;

		/**
		 * Action for stoping the training.
		 */
		KAction *stopAction;

		/**
		 * Record if we're started or not
		 */
		bool started;
};

#endif // _SCOREREADINGTRAINER_H_
