require 'yaml'

module Schleuder
  # Abstract class to provide loading of files and overloading of values.
  # Note: don't use Schleuder.log in here, is might be not yet available, and
  # you will produce loops.
  class Storage

    # If +input+ is String or Hash it will be used to fill instance variables
    # fromfile = wether to load the information from file
    def initialize(input=nil, fromfile=true)
      if input.kind_of?(Hash) then
        overload_from_hash!(input)
      elsif input.kind_of?(String) then
        overload_from_file!(input) if fromfile
      else
        raise "Unknown input: #{input.class}"
      end
    end

    # Load content from +filename+ and overwrite existing instance variables of
    # self
    def overload_from_file!(filename)
      h = YAML.load_file(filename) || Hash.new # yaml returns nil if the Hash is empty
      overload_from_hash!(h)
    end

    # Load content from +h+ into self (if allowed so according to
    # attr_reader/writer/accessor)
    def overload_from_hash!(h)
      h.each_pair do |k,v|
        begin
          eval("self.#{k} = v") 
        rescue NoMethodError
          Schleuder.log.error "Attempt to set illegal variable: #{self.class}.#{k} => #{v}"
        end
      end
    end

    def to_hash
      h = {}
      instance_variables.each { |iv|
        h[iv[1..-1]] = instance_variable_get(iv)
      }
      h
    end
  end
end
