/*
 * SARG Squid Analysis Report Generator      http://sarg.sourceforge.net
 *                                                            1998, 2010
 *
 * SARG donations:
 *      please look at http://sarg.sourceforge.net/donations.php
 * Support:
 *     http://sourceforge.net/projects/sarg/forums/forum/363374
 * ---------------------------------------------------------------------
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 */

#include "include/conf.h"
#include "include/defs.h"

void squidguard_report(void)
{

   FILE *fp_in = NULL, *fp_ou = NULL;

   char url[MAXLEN];
   char squidguard_in[MAXLEN];
   char per[MAXLEN];
   char report[MAXLEN];
   char period[100];
   char ip[MAXLEN];
   char rule[255];
   char oip[MAXLEN];
   char user[MAXLEN];
   char ouser[MAXLEN];
   char data[15];
   char data2[15];
   char hora[15];
   char *str;
   int  z=0;
   int  count=0;
   struct getwordstruct gwarea;

   ouser[0]='\0';

   sprintf(squidguard_in,"%s/squidguard.log",tmp);
   if(!squidguard_count) {
      unlink(squidguard_in);
      return;
   }

   sprintf(per,"%s/sarg-period",dirname);
   sprintf(report,"%s/squidguard.html",dirname);

   if ((fp_in = fopen(per, "r")) == 0) {
      fprintf(stderr, "SARG: (squidguard) %s: %s\n",text[45],per);
      exit(1);
   }

   if (!fgets(period,sizeof(period),fp_in)) {
      fprintf(stderr,"SARG: (squidguard) read error in %s\n",per);
      exit(1);
   }
   fclose(fp_in);

   if((fp_in=fopen(squidguard_in,"r"))==NULL) {
     fprintf(stderr, "SARG: (squidguard) %s: %s\n",text[8],squidguard_in);
     exit(1);
   }

   if((fp_ou=fopen(report,"w"))==NULL) {
     fprintf(stderr, "SARG: (squidguard) %s: %s\n",text[8],report);
     exit(1);
   }

   fprintf(fp_ou, "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\n<html>\n<head>\n  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=%s\">\n",CharSet);
   css(fp_ou);
   fputs("</head>\n",fp_ou);
   if(strlen(FontFace) > 0) fprintf(fp_ou,"<font face=%s>\n",FontFace);
   fprintf(fp_ou,"<body bgcolor=%s text=%s background='%s'>\n",BgColor,TxColor,BgImage);
   write_logo_image(fp_ou);

   if(strcmp(IndexTree,"date") == 0)
      show_sarg(fp_ou, "../../..");
   else
      show_sarg(fp_ou,"..");
   fputs("<div align=\"center\"><table cellpadding=\"0\" cellspacing=\"0\">\n",fp_ou);
   fprintf(fp_ou,"<tr><th class=\"title\">%s</th></tr>\n",Title);

   fprintf(fp_ou,"<tr><td class=\"header\">%s: %s</td></tr>\n",text[89],period);
   fprintf(fp_ou,"<tr><th class=\"header3\">%s</th></tr>\n",text[120]);
   fputs("</table></div>\n",fp_ou);

   fputs("<div align=\"center\"><table cellpadding=1 cellspacing=2>\n",fp_ou);
   fputs("<tr><td></td></tr>\n",fp_ou);
   fprintf(fp_ou,"<tr><th class=\"header\">%s</th><th class=\"header\">%s</th><th class=\"header\">%s</th><th class=\"header\">%s</th><th class=\"header\">%s</th></tr>\n",text[98],text[111],text[110],text[91],text[121]);

   while(fgets(buf,sizeof(buf),fp_in)!=NULL) {
      getword_start(&gwarea,buf);
      if (getword(user,sizeof(user),&gwarea,'\t')<0 || getword(data2,sizeof(data2),&gwarea,'\t')<0 ||
          getword(hora,sizeof(hora),&gwarea,'\t')<0 || getword(ip,sizeof(ip),&gwarea,'\t')<0 ||
          getword(url,sizeof(url),&gwarea,'\t')<0 || getword(rule,sizeof(rule),&gwarea,'\n')<0) {
         printf("SARG: Maybe you have a broken record or garbage in your %s file.\n",squidguard_in);
         exit(1);
      }

      if(UserIp)
           strcpy(user,ip);

      bzero(data, 15);
      if(strncmp(df,"u",1) != 0) {
         strncpy(data,data2+6,2);
         strcat(data,"/");
         strncat(data,data2+4,2);
         strcat(data,"/");
         strncat(data,data2,4);
      } else {
         strncpy(data,data2+4,2);
         strcat(data,"/");
         strncat(data,data2+6,2);
         strcat(data,"/");
         strncat(data,data2,4);
      }

      if((str=(char *) strstr(user, "_")) != (char *) NULL ) {
         if((str=(char *) strstr(str+1, "_")) != (char *) NULL )
            fixip(user);
      }

      if(Ip2Name)
         ip2name(ip,sizeof(ip));

      if(!z) {
         strcpy(ouser,user);
         strcpy(oip,ip);
         z++;
      } else {
         if(strcmp(ouser,user) == 0)
            user[0]='\0';
         if(user[0] != '\0')
            strcpy(ouser,user);
         if(strcmp(oip,ip) == 0)
            ip[0]='\0';
         if(ip[0] != '\0')
            strcpy(oip,ip);
      }

      get_usertab_name(user,name,sizeof(name));

      if(dotinuser && strchr(name,'_')) {
         subs(name,sizeof(name),"_",".");
      }

     if(SquidGuardReportLimit) {
         if(strcmp(ouser2,name) == 0) {
            count++;
         } else {
            count=1;
            strcpy(ouser2,name);
         }
         if(count >= SquidGuardReportLimit)
            continue;
      }

      fprintf(fp_ou,"<tr><td class=\"data2\">%s</td><td class=\"data2\">%s</td><td class=\"data2\">%s-%s</td><td class=\"data2\"><a href=\"http://%s\">%s</a></td><td class=\"data2\">%s</td></th>\n",name,ip,data,hora,url,url,rule);
   }

   fputs("</table>\n",fp_ou);

   show_info(fp_ou);

   fputs("</body>\n</html>\n",fp_ou);

   fclose(fp_in);
   fclose(fp_ou);

   unlink(squidguard_in);

   return;
}
