/***************************************************************************
 $RCSfile$
                             -------------------
    cvs         : $Id$
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif


#include "editgraphreport.h"
#include "graphreport.h"
#include "kbanking.h"
#include "transfinder.h"

#include <gwenhywfar/db.h>

#include <qcombobox.h>
#include <qlineedit.h>
#include <qcheckbox.h>
#include <qmessagebox.h>
#include <qspinbox.h>
#include <qpushbutton.h>




EditGraphReport::EditGraphReport(KBanking *kb,
                                 GWEN_DB_NODE *dbProfile,
                                 QWidget* parent,
                                 const char* name,
                                 bool modal,
                                 Qt::WFlags fl)
:EditGraphReportUi(parent, name, modal, fl)
,_banking(kb)
,_dbProfile(dbProfile) {
  _profileToGui(_dbProfile);
  connect(helpButton, SIGNAL(clicked()), this, SLOT(slotHelp()));
  connect(ruleButton, SIGNAL(clicked()), this, SLOT(slotEditRule()));
  connect(askForDataCheck, SIGNAL(toggled(bool)),
          this, SLOT(slotAskForDataToggled(bool)));
}



EditGraphReport::~EditGraphReport() {
}






void EditGraphReport::_profileToGui(GWEN_DB_NODE *dbProfile) {
  const char *s;
  uint32_t flags;
  int i;

  s=GWEN_DB_GetCharValue(dbProfile, "name", 0, 0);
  if (s)
    nameEdit->setText(QString::fromUtf8(s));
  s=GWEN_DB_GetCharValue(dbProfile, "shortDescr", 0, 0);
  if (s)
    descrEdit->setText(QString::fromUtf8(s));
  s=GWEN_DB_GetCharValue(dbProfile, "units", 0, 0);
  if (s) {
    GraphReport::Units u=GraphReport::unitsFromString(s);
    switch(u) {
    case GraphReport::UnitsMonths:
      unitsCombo->setCurrentItem(1);
      break;
    case GraphReport::UnitsYears:
      unitsCombo->setCurrentItem(2);
      break;
    case GraphReport::UnitsDays:
    default:
      unitsCombo->setCurrentItem(0);
      break;
    }
  }

  s=GWEN_DB_GetCharValue(dbProfile, "valueMode", 0, 0);
  if (s) {
    GraphReport::ValueMode u=GraphReport::valueModeFromString(s);
    switch(u) {
    case GraphReport::ValueModeAbsolute:
      valueModeCombo->setCurrentItem(1);
      break;
    default:
    case GraphReport::ValueModeNormal:
      valueModeCombo->setCurrentItem(0);
      break;
    }
  }

  s=GWEN_DB_GetCharValue(dbProfile, "graphType", 0, 0);
  if (s) {
    GraphReport::GraphType u=GraphReport::graphTypeFromString(s);
    switch(u) {
    case GraphReport::GraphTypeLines:
      graphTypeCombo->setCurrentItem(1);
      break;
    case GraphReport::GraphTypeBars:
      graphTypeCombo->setCurrentItem(2);
      break;
    case GraphReport::GraphTypePoints:
    default:
      graphTypeCombo->setCurrentItem(0);
      break;
    }
  }

  flags=GraphReport::flagsFromDb(dbProfile, "flags");
  cumulateCheck->setChecked(flags & GRAPHREPORT_FLAGS_CUMULATE);
  xScaleCheck->setChecked(flags & GRAPHREPORT_FLAGS_MARK_X);
  yScaleCheck->setChecked(flags & GRAPHREPORT_FLAGS_MARK_Y);
  yRasterCheck->setChecked(flags & GRAPHREPORT_FLAGS_RASTER_Y);
  askForDataCheck->setChecked(flags & GRAPHREPORT_FLAGS_ASK_DATA);
  slotAskForDataToggled(flags & GRAPHREPORT_FLAGS_ASK_DATA);

  i=GWEN_DB_GetIntValue(dbProfile, "width", 0, 800);
  if (i<100)
    i=100;
  widthSpin->setValue(i);

  i=GWEN_DB_GetIntValue(dbProfile, "height", 0, 600);
  if (i<100)
    i=100;
  heightSpin->setValue(i);
}



void EditGraphReport::_guiToProfile(GWEN_DB_NODE *dbProfile) {
  std::string s;
  int i;
  GraphReport::Units units;
  GraphReport::ValueMode vmode;
  GraphReport::GraphType gtype;
  uint32_t flags;

  s=QBanking::QStringToUtf8String(nameEdit->text());
  GWEN_DB_SetCharValue(dbProfile, GWEN_DB_FLAGS_OVERWRITE_VARS,
                       "name", s.c_str());

  s=QBanking::QStringToUtf8String(descrEdit->text());
  if (s.empty())
    GWEN_DB_DeleteVar(dbProfile, "shortDescr");
  GWEN_DB_SetCharValue(dbProfile, GWEN_DB_FLAGS_OVERWRITE_VARS,
                       "shortDescr", s.c_str());

  i=unitsCombo->currentItem();
  switch(i) {
  case 0:  units=GraphReport::UnitsDays;   break;
  case 1:  units=GraphReport::UnitsMonths; break;
  case 2:  units=GraphReport::UnitsYears;  break;
  default:
    DBG_ERROR(0, "Unhandled unit type %d", i);
    abort();
  }
  GWEN_DB_SetCharValue(dbProfile, GWEN_DB_FLAGS_OVERWRITE_VARS,
                       "units", GraphReport::unitsToString(units));

  i=valueModeCombo->currentItem();
  switch(i) {
  case 0:  vmode=GraphReport::ValueModeNormal;   break;
  case 1:  vmode=GraphReport::ValueModeAbsolute; break;
  default:
    DBG_ERROR(0, "Unhandled value mode %d", i);
    abort();
  }
  GWEN_DB_SetCharValue(dbProfile, GWEN_DB_FLAGS_OVERWRITE_VARS,
                       "valueMode", GraphReport::valueModeToString(vmode));

  i=graphTypeCombo->currentItem();
  switch(i) {
  case 0:  gtype=GraphReport::GraphTypePoints; break;
  case 1:  gtype=GraphReport::GraphTypeLines;  break;
  case 2:  gtype=GraphReport::GraphTypeBars;   break;
  default:
    DBG_ERROR(0, "Unhandled graph type %d", i);
    abort();
  }
  GWEN_DB_SetCharValue(dbProfile, GWEN_DB_FLAGS_OVERWRITE_VARS,
                       "graphType",
                       GraphReport::graphTypeToString(gtype));
  flags=0;
  if (cumulateCheck->isChecked())
    flags|=GRAPHREPORT_FLAGS_CUMULATE;
  if (xScaleCheck->isChecked())
    flags|=GRAPHREPORT_FLAGS_MARK_X;
  if (yScaleCheck->isChecked())
    flags|=GRAPHREPORT_FLAGS_MARK_Y;
  if (yRasterCheck->isChecked())
    flags|=GRAPHREPORT_FLAGS_RASTER_Y;
  if (askForDataCheck->isChecked())
    flags|=GRAPHREPORT_FLAGS_ASK_DATA;

  GraphReport::flagsToDb(dbProfile, "flags", flags);

  GWEN_DB_SetIntValue(dbProfile, GWEN_DB_FLAGS_OVERWRITE_VARS,
                      "width", widthSpin->value());
  GWEN_DB_SetIntValue(dbProfile, GWEN_DB_FLAGS_OVERWRITE_VARS,
                      "height", heightSpin->value());
}



void EditGraphReport::accept() {
  DBG_ERROR(0, "Accept");
  if (nameEdit->text().isEmpty()) {
    QMessageBox::critical(this,
                          tr("Bad Input"),
                          tr("Please enter a name for this profile."),
                          tr("Dismiss"));
    return;
  }

  DBG_ERROR(0, "Writing profile");
  _guiToProfile(_dbProfile);
  DBG_ERROR(0, "Accepting");
  QDialog::accept();
}



void EditGraphReport::slotHelp() {
  _banking->invokeHelp("EditGraphReport", "none");
}



void EditGraphReport::slotEditRule() {
  GWEN_DB_NODE *dbRule;

  dbRule=GWEN_DB_GetGroup(_dbProfile, GWEN_DB_FLAGS_DEFAULT, "rule");
  TransactionFinder::editRule(_banking,
                              dbRule,
                              tr("Enter Matcher Rules"),
                              TRANSFINDER_FLAGS_USE_CATEGORY |
                              TRANSFINDER_FLAGS_EXT_PAYEES,
                              this);

}



void EditGraphReport::slotAskForDataToggled(bool b) {
  ruleButton->setEnabled(!b);
}








