/***************************************************************************
 $RCSfile$
                             -------------------
    cvs         : $Id$
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif


#include "selecttransfers.h"
#include "transferlist.h"
#include "kbanking.h"
#include <qbanking/qbplugindescrlist.h>

#include <qwidget.h>
#include <qstring.h>
#include <qlistview.h>

#include <gwenhywfar/debug.h>

#ifdef WIN32
# define strcasecmp stricmp
#endif


SelectTransfers::SelectTransfers(KBanking *kb,
                                 const QString &title,
                                 std::list<RefPointer<Transfer> > tl,
                                 QWidget* parent,
                                 const char *name,
                                 bool modal,
                                 WFlags fl)
:SelectTransfersUi(parent, name, modal, fl)
,_app(kb)
,_transfers(tl) {

  if (!title.isEmpty())
    setCaption(title);
  transferListView->setSelectionMode(QListView::Multi);
  transferListView->setAllColumnsShowFocus(true);
}



SelectTransfers::~SelectTransfers(){
}



bool SelectTransfers::init() {
  std::string s;
  int i, j;
  GWEN_DB_NODE *dbConfig=NULL;
  int rv;

  rv=_app->loadAppSubConfig("gui/dialogs/selecttransfers", &dbConfig);
  if (rv<0) {
    DBG_INFO(0, "here (%d)", rv);
  }
  else {
    int w;
    int h;
    const char *p;

    /* found settings */
    w=GWEN_DB_GetIntValue(dbConfig, "width", 0, 640);
    h=GWEN_DB_GetIntValue(dbConfig, "height", 0, 480);
    resize(w, h);

    p=GWEN_DB_GetCharValue(dbConfig, "sortOrder", 0, "ascending");
    if (p) {
      if (strcasecmp(p, "ascending")==0)
	transferListView->setSortOrder(Qt::Ascending);
      else
	if (strcasecmp(p, "descending")==0)
	  transferListView->setSortOrder(Qt::Descending);
    }
    i=GWEN_DB_GetIntValue(dbConfig, "sortColumn", 0, -1);
    if (i!=-1)
      transferListView->setSortColumn(i);
    for (i=0; i<transferListView->columns(); i++) {
      transferListView->setColumnWidthMode(i, QListView::Manual);
      j=GWEN_DB_GetIntValue(dbConfig, "columns", i, -1);
      if (j!=-1)
	transferListView->setColumnWidth(i, j);
    } /* for */
    GWEN_DB_Group_free(dbConfig);
  } // if application settings

  transferListView->addTransfers(_transfers);
  transferListView->selectAll(true);


  return true;
}



bool SelectTransfers::fini(){
  GWEN_DB_NODE *dbConfig;
  int i, j;
  std::string s;
  int rv;

  dbConfig=GWEN_DB_Group_new("config");
  assert(dbConfig);

  GWEN_DB_SetIntValue(dbConfig, GWEN_DB_FLAGS_DEFAULT,
                      "width", width());
  GWEN_DB_SetIntValue(dbConfig, GWEN_DB_FLAGS_DEFAULT,
                      "height", height());

  GWEN_DB_SetIntValue(dbConfig, GWEN_DB_FLAGS_DEFAULT,
                      "sortColumn", transferListView->sortColumn());
  switch(transferListView->sortOrder()) {
  case Qt::Ascending:
    GWEN_DB_SetCharValue(dbConfig, GWEN_DB_FLAGS_DEFAULT,
                         "sortOrder", "ascending");
    break;
  case Qt::Descending:
    GWEN_DB_SetCharValue(dbConfig, GWEN_DB_FLAGS_DEFAULT,
                         "sortOrder", "descending");
    break;
  default:
    break;
  }

  for (i=0; i<transferListView->columns(); i++) {
    j=transferListView->columnWidth(i);
    GWEN_DB_SetIntValue(dbConfig, GWEN_DB_FLAGS_DEFAULT,
                        "columns", j);
  } /* for */

  rv=_app->saveAppSubConfig("gui/dialogs/selecttransfers", dbConfig);
  GWEN_DB_Group_free(dbConfig);
  if (rv<0) {
    DBG_INFO(0, "here (%d)", rv);
    return false;
  }

  return true;
}



std::list<RefPointer<Transfer> > SelectTransfers::getSelectedTransfers() {
  return transferListView->getSelectedTransfers();
}




bool
SelectTransfers::selectTransfers(KBanking *kb,
                                 std::list<RefPointer<Transfer> > tl,
                                 std::list<RefPointer<Transfer> > &selected,
                                 QWidget* parent) {
  SelectTransfers w(kb, QWidget::tr("Select Transfers"), tl, parent);
  bool res;

  if (!w.init()) {
    DBG_INFO(0, "here");
    return false;
  }

  res=(w.exec()==QDialog::Accepted);
  if (res) {
    w.transferListView->getSelectedTransfersToList(selected);
  }
  w.fini();

  return res;
}






