# arch-tag: c1237fa7-e976-4668-b8d8-59cde0007fc8
# Copyright (C) 2003 David Allouche <david@allouche.net>
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

"""Deprecated helper functions."""

import re
from deprecation import deprecated_usage, deprecated_callable

__all__ = [
    'filter_archive_logs',
    'filter_revisions',
    'grep_summary',
    'grep_summary_interactive',
    'suspected_move',
    'revisions_merging',
    'temphack',
    'revision_which_created',
    'last_revision',
    'map_name_id',
    ]


def filter_archive_logs(limit, pred):
    deprecated_callable(filter_archive_logs,
                        because='It does not belong here.')
    for r in limit.iter_revisions():
        if pred(r.patchlog): yield r


def filter_revisions(limit, pred):
    deprecated_callable(filter_archive_logs,
                        because='It does not belong here.')
    for r in limit.iter_revisions():
        if pred(r): yield r

def grep_summary(limit, rx):
    deprecated_callable(grep_summary,
                        because='It does not belong here.')
    crx = re.compile(rx)
    def pred(p):
        return crx.search(p['Summary'])
    return filter_archive_logs(limit, pred)


def grep_summary_interactive(limit):
    deprecated_callable(grep_summary_interactive,
                        because='It does not belong here.')
    while True:
        try:
            rx = raw_input('search> ')
        except KeyboardInterrupt:
            break
        if not rx: break
        for r in grep_summary(limit, rx):
            p = r.patchlog
            print 'Revision:', p['Revision']
            print 'Summary: ', p['Summary']


def suspected_move(limit):
    deprecated_callable(suspected_move,
                        because='It does not belong here.')
    def pred(p): return bool(p['New-files'] and p['Removed-files'])
    return filter_archive_logs(limit, pred)


def revisions_merging(limit, rev):
    deprecated_callable(revisions_merging,
                        because='It does not belong here.')
    def pred(p):
        return rev in p.merged_patches
    return filter_archive_logs(limit, pred)


def temphack(revision):
    deprecated_callable(temphack,
                        because='It does not belong here.')
    import sets
    retval = sets.Set()
    for ancstr in revision.iter_ancestors(metoo=True):
        for k in ancstr.patchlog.keys():
            retval.add(k)
    return retval


def revision_which_created(file, revision):
    deprecated_callable(revision_which_created,
                        because='It does not belong here.')
    for ancstr in revision.iter_ancestors(metoo=True):
        if file in ancstr.patchlog.new_files:
            return ancstr
    return None

def last_revision(tree):
    import _builtin
    deprecated_callable(last_revision,
                        (_builtin.ArchSourceTree, 'tree_revision'))
    tree = _builtin.SourceTree(tree)
    return tree.iter_logs(reverse=True).next().revision


def map_name_id(tree):
    import _builtin
    deprecated_callable(map_name_id,
                        because='It does not belong here.')
    if not isinstance(tree, _builtin.SourceTree):
        tree = _builtin.SourceTree(tree)
    retval = {}
    for id_, name in tree.iter_inventory_ids(source=True, files=True):
        retval[name] = id_
    return retval
