/* $Cambridge: hermes/src/prayer/cmd/cmd_rm.c,v 1.2 2008/05/19 15:55:54 dpc22 Exp $ */
/************************************************
 *    Prayer - a Webmail Interface              *
 ************************************************/

/* Copyright (c) University of Cambridge 2000 - 2008 */
/* See the file NOTICE for conditions of use and distribution. */

#include "prayer_session.h"
#include "cmd.h"

void cmd_rm(struct session *session)
{
    struct template_vals *tvals = session->template_vals;
    struct request *request = session->request;
    struct options *options = session->options;
    struct prefs *prefs = options->prefs;
    struct buffer *b = request->write_buffer;
    char *cmd, *s;

    if (request->argc < 3) {
        session_redirect(session, request, "folders");
        return;
    }

    if (!prefs->confirm_rm) {
        cmd_rm1(session);
        return;
    }

    s = string_canon_decode(pool_strdup(request->pool, request->argv[2]));
    cmd = pool_printf(request->pool, "rm1/%s/%s",
                      request->argv[1], request->argv[2]);

    template_vals_string(tvals, "cmd", cmd);
    template_vals_string(tvals, "name", s);

    if (!strcmp(request->argv[1], "directory")) {
        template_vals_string(tvals, "type", "directory");
    } else {
        template_vals_string(tvals, "type", "mailbox");
    }

    session_seed_template(session, tvals);
    template_expand("rm", tvals, b);
    response_html(request, 200);
}
