/*
 *  Copyright 2001-2005 Internet2
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

 /* SAMLCondition.cpp - SAML condition implementation

   Scott Cantor
   5/27/02

   $History:$
*/

#include "internal.h"

using namespace saml;
using namespace std;

SAMLCondition::SAMLConditionFactoryMap SAMLCondition::m_map;

SAMLCondition* SAMLCondition::getInstance(DOMElement* e)
{
    saml::QName* type=saml::QName::getQNameAttribute(e,XML::XSI_NS,L(type));
    if (!type)
        type=new saml::QName(e->getNamespaceURI(),e->getLocalName());
    SAMLConditionFactoryMap::const_iterator i=m_map.find(*type);
    delete type;
    if (i!=m_map.end())
        return (i->second)(e);
    return NULL;
}

SAMLCondition* SAMLCondition::getInstance(istream& in)
{
    XML::Parser p;
    XML::StreamInputSource src(in);
    Wrapper4InputSource dsrc(&src,false);
    DOMDocument* doc=p.parse(dsrc);
    try
    {
        SAMLCondition* c=getInstance(doc->getDocumentElement());
        if (c)
            c->setDocument(doc);
        return c;
    }
    catch(...)
    {
        doc->release();
        throw;
    }
}
