/**
 * Navit, a modular navigation system.
 * Copyright (C) 2005-2008 Navit Team
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License
 * version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */

#ifndef __ZIPFILE_H__
#define __ZIPFILE_H__

#ifdef HAVE_PRAGMA_PACK
#pragma pack(push)
#pragma pack(1)
#endif

#ifdef  __GNUC__
#define ATTRIBUTE_PACKED __attribute__ ((packed))
#else
#define ATTRIBUTE_PACKED
#endif

#define zip_split_sig 0x08074b50
#define zip_split_sig_rev 0x504b0708

struct zip_split {
	int zipsplitsig;
};

#define zip_lfh_sig 0x04034b50
#define zip_lfh_sig_rev 0x504b0304

struct zip_lfh {
	int ziplocsig;
	short zipver; 		// 4
	short zipgenfld;	// 6
	short zipmthd;		// 8
	short ziptime;		// 10
	short zipdate;		// 12
	int zipcrc;		// 14
	unsigned int zipsize;  // 18
	unsigned int zipuncmp; // 22
	unsigned short zipfnln; // 26
	unsigned short zipxtraln; // 30
	char zipname[0]; // 34
} ATTRIBUTE_PACKED;

#define zip_cd_sig 0x02014b50
#define zip_cd_sig_rev 0x504b0102

struct zip_cd {
	int zipcensig;
	char zipcver;
	char zipcos;
	char zipcvxt;
	char zipcexos;
	short zipcflg;
	short zipcmthd;
	short ziptim;
	short zipdat;
	int zipccrc;
	unsigned int zipcsiz;
	unsigned int zipcunc;
	unsigned short zipcfnl;
	unsigned short zipcxtl;
	unsigned short zipccml;
	unsigned short zipdsk;
	unsigned short zipint;
	unsigned int zipext;
	unsigned int zipofst;
	char zipcfn[0];	
} ATTRIBUTE_PACKED;

struct zip_cd_ext {
	short tag;
	short size;
	unsigned long long zipofst;
} ATTRIBUTE_PACKED;

struct zip_enc {
	short efield_header;
	short efield_size;
	short version;
	char vendor_id1,vendor_id2;
	char encryption_strength;
	short compress_method; 
} ATTRIBUTE_PACKED;

#define zip_eoc_sig 0x6054b50
#define zip_eoc_sig_rev 0x504b0506

struct zip_eoc {
	int zipesig; 		/* end of central dir signature */
	unsigned short zipedsk; /* number of this disk */
	unsigned short zipecen; /* number of the disk with the start of the central directory */
	unsigned short zipenum; /* total number of entries in the central directory on this disk */
	unsigned short zipecenn; /* total number of entries in the central directory */
	unsigned int zipecsz; 	/* size of the central directory */
	unsigned int zipeofst; 	/* offset of start of central directory with respect to the starting disk number */
	short zipecoml; 	/* .ZIP file comment length */
	char zipecom[0];	/* .ZIP file comment */
} ATTRIBUTE_PACKED;

#define zip64_eoc_sig 0x6064b50
#define zip64_eoc_sig_rev 0x504b0606

struct zip64_eoc {
	int zip64esig;			/* zip64 end of central dir signature */
	unsigned long long zip64esize;	/* size of zip64 end of central directory record */
	unsigned short zip64ever;	/* version made by */
	unsigned short zip64eneed;	/* version needed to extract */
	unsigned int zip64edsk;		/* number of this disk */
	unsigned int zip64ecen;		/* number of the disk with the start of the central directory */
	unsigned long long zip64enum; 	/* total number of entries in the central directory on this disk */
	unsigned long long zip64ecenn;	/* total number of entries in the central directory */
	unsigned long long zip64ecsz;	/* size of the central directory */
	unsigned long long zip64eofst;	/* offset of start of central directory with respect to the starting disk number */
	char zip64ecom[0];		/* zip64 extensible data sector */
} ATTRIBUTE_PACKED;

#define zip64_eocl_sig 0x07064b50

struct zip64_eocl {
	int zip64lsig;
	int zip64ldsk;
	long long zip64lofst;
	int zip74lnum;
} ATTRIBUTE_PACKED;

struct zip_alignment_check {
	int x[sizeof(struct zip_cd) == 46 ? 1:-1];
};

#ifdef HAVE_PRAGMA_PACK
#pragma pack(pop)
#endif
#endif
