/* 
# fifo_write.c
# Copyright (C) 2005, NETWAYS GmbH, Gerd Mueller
#  $Id: fifo_write.c 1076 2007-11-28 12:52:03Z cdoebler $
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

# Build it with: 
gcc -o fifo_write fifo_write.c

*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <fcntl.h>
#include <unistd.h>

#include <sys/stat.h>

int main(int argc, char **argv)
{
    int hfpath;
    int rw = 0;
    char *output = NULL;
    char *fpath = NULL;

    // right amount of parameters?
    if (argc == 3 || argc == 4) {
        struct stat st;
        int timeout = 3;

        fpath = argv[1];
        output = argv[2];

        // got timeout-parameter?
        if (argc == 4)
            timeout = atoi(argv[3]);

        // file should be a pipe
        stat(fpath, &st);
        if (S_ISFIFO(st.st_mode)) {

            // open file
            hfpath = open(fpath, O_WRONLY | O_NONBLOCK);
            if (hfpath) {

                //inplace edit
                char *formatted = output;
                char *raw = output;

                //replace some control chars
                while (*raw) {
                    if (*raw == '\\') {
                		switch (*(raw+1)) {
                		    case 't': *(formatted++) = '\t'; raw += 2; continue;
                		    case 'n': *(formatted++) = '\n'; raw += 2; continue;
                		}
                    }

                    *(formatted++) = *(raw++);
                }
                *formatted = '\0';

                // write to pipe
                alarm(timeout);
                write(hfpath, output, formatted - output);
                alarm(0);

                /* Errorhandling below */


                close(hfpath);
            } else {
                printf("Could not open %s for writing!\n", fpath);
                rw = 1;
            }
        } else {
            printf("%s is not a pipe or does not exist!\n", fpath);
            rw = 1;
        }
    } else {
        printf
            ("Usage: write_fifo <path of the pipe> <output> [timeout]\n");
        rw = 1;
    }
    return rw;
}
