package NagiosGrapher::Hooks::NG2MySQL;

# Database Structure: see under srcdir/tools/ng2mysql_create_db.sql
#

use NagiosGrapher::Hooks::Generic;

use vars qw (
	@ISA
);

@ISA = ('NagiosGrapher::Hooks::Generic');

sub init {
	$self = shift;

	$self->SetTypes (
		'before_rrdupdate',
	);

	return $self->SUPER::init(@_);
}

sub prepare {
	my $self = shift;
	use Data::Dumper;
	use DBI;
	
	my $rc = 1;

	$self->print_log("Log2Mysql: ". $self->Host." - ".$self->Service);

	
    $self->{'dbh'}=DBI->connect("DBI:mysql:nagiosgrapher:localhost","nguser","ngpasswd");
    
    if(!$self->{'dbh'}) {
		$self->print_log("Log2Mysql: cannot connect to database!");
		$rc=0;
    } else {
	  	$self->{'sth'}=$self->{'dbh'}->prepare("INSERT INTO servicevalues SET host=?,service=?,label=?,value=?");
    }
  	
	return $rc;
}

sub commit {
	my $self = shift;
	my $values = $self->Values;

	foreach (keys %{ $self->{Values} }) {
		$self->{'sth'}->execute($self->Host,$self->Service,$_,$self->{Values}->{$_});		
	}

	return 1;
}

sub cleanup {
	my $self = shift;

	$self->{'dbh'}->disconnect;

	return 1;
}

1;