/* Copyright (C) 2004 MySQL AB

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

#ifndef _MQTABLECLAUSEMENU_H_
#define _MQTABLECLAUSEMENU_H_

#include "MGFloatingWidget.h"
#include "myx_public_interface.h"

class MQTableClauseMenu : public MGFloatingWidget {
    struct Item {
      int x, y;
      int w, h;
      bool decoration;
      MYX_Q_TABLE_ADD_TYPE code;
      Glib::ustring text;
    };
    std::vector<Item> _items;

    int _mouse_x, _mouse_y;
    MYX_Q_TABLE_ADD_TYPE _selection;
    

    typedef MGFloatingWidget superclass;
    
    Glib::RefPtr<Gdk::Pixbuf> _image;
    bool _recompose;
    
    Glib::RefPtr<Gdk::Pixmap> _pixmap;

    virtual void paint_contents();
    void paint_buttons(bool all= true);

    virtual void update_mouse(int x, int y);
    
  public:
    MQTableClauseMenu(unsigned int prefered_width);
    
    virtual bool show_at(int x, int y);
    
    MYX_Q_TABLE_ADD_TYPE get_selection() { return _selection; };
};


#endif /* _MQTABLECLAUSEMENU_H_ */
