unit MyxRoutineGroupEditor;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UCEHighlighter, UCESQLHighlighter, TntForms, StdCtrls,
  TntStdCtrls, ExtCtrls, TntExtCtrls, UniCodeEditor, MyxEditor,
  MyxRoutineEditorFrame, Contnrs, ComCtrls, TntComCtrls,
  Grt, ActnList, TntActnList;

type
  TMyxRoutineGroupEditorForm = class(TMyxEditorForm)
    HeaderPnl: TTntPanel;
    NameLbl: TTntLabel;
    NameEd: TTntEdit;
    BottomPnl: TTntPanel;
    ApplyChangesBtn: TTntButton;
    CancelBtn: TTntButton;
    LeftPnl: TTntPanel;
    RightPnl: TTntPanel;
    PageControl: TTntPageControl;
    RoutineSheet: TTntTabSheet;
    CommentSheet: TTntTabSheet;
    RoutinesScrollBox: TTntScrollBox;
    CommentMemo: TTntMemo;
    TntShape1: TTntShape;
    TntShape2: TTntShape;
    TntShape3: TTntShape;
    TntShape4: TTntShape;
    TntActionList1: TTntActionList;
    ApplyChangesAndCloseAction: TTntAction;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure ApplyChangesBtnClick(Sender: TObject);
    procedure CancelBtnClick(Sender: TObject);
    procedure NameEdKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure ApplyChangesAndCloseActionExecute(Sender: TObject);
  private
    { Private declarations }
    FRoutineFrames: TObjectList;
    FSettingContent: Boolean;
    FRoutineDragStartHeight: Integer;
  protected
    procedure SetModified(Modified: Boolean); override;
    procedure OnRoutineChange(Sender: TObject);
    procedure OnRoutineDelete(Sender: TObject);
    procedure AddRoutineBox(Routine: Pointer = nil);

    procedure DoRoutineHeaderDragStart(Sender: TObject);
    procedure DoRoutineHeaderDragStop(Sender: TObject);
    procedure DoRoutineHeaderDrag(Sender: TObject; YOffset: Integer);

    procedure DoCommentUceChange(Sender: TObject; Line: TUCELine);
  public
    { Public declarations }
    procedure StartEditObject(Obj: Pointer); override;
    procedure ApplyChanges; override;
  end;

var
  MyxRoutineGroupEditorForm: TMyxRoutineGroupEditorForm;

implementation

{$R *.dfm}

// -----------------------------------------------------------------------------

procedure TMyxRoutineGroupEditorForm.FormCreate(Sender: TObject);

begin
  FRoutineFrames := TObjectList.Create;
  FSettingContent := False;

  PageControl.ActivePageIndex := 0;
end;

// -----------------------------------------------------------------------------

procedure TMyxRoutineGroupEditorForm.FormDestroy(Sender: TObject);

begin
  FRoutineFrames.Free;
end;

// -----------------------------------------------------------------------------

procedure TMyxRoutineGroupEditorForm.FormClose(Sender: TObject;
  var Action: TCloseAction);

begin
  Action := caFree;
end;

// -----------------------------------------------------------------------------

procedure TMyxRoutineGroupEditorForm.StartEditObject(Obj: Pointer);

var
  RoutineList: Pointer;
  I, Count: Integer;

begin
  inherited;

  FSettingContent := True;
  try
    NameEd.Text := Grt.DictString[Obj, 'name'];

    RoutineList := Grt.DictItem[Obj, 'routines'];
    Count := Grt.ListCount(RoutineList);

    for I := 0 to Count do
    begin
      if (I < Count) then
        AddRoutineBox(Grt.ListRefItem[RoutineList, I])
      else
        AddRoutineBox;
    end;

    CommentMemo.Text := Grt.DictString[Obj, 'comment'];
  finally
    FSettingContent := False;
  end;
end;

// -----------------------------------------------------------------------------

procedure TMyxRoutineGroupEditorForm.SetModified(Modified: Boolean);

begin
  inherited;

  ApplyChangesBtn.Enabled := Modified;
end;

// -----------------------------------------------------------------------------

procedure TMyxRoutineGroupEditorForm.ApplyChanges;

var
  I: Integer;
  ExpandedHeights: Pointer;
  ExpandedStates: Pointer;

begin
  if (NameEd.Text <> '') then
    Grt.DictString[Obj, 'name'] := NameEd.Text;

  ExpandedStates := Grt.ListNew(GrtIntValue);
  ExpandedHeights := Grt.ListNew(GrtIntValue);

  for I := 0 to FRoutineFrames.Count - 1 do
  begin
    TRoutineFrame(FRoutineFrames[i]).ApplyChanges;

    Grt.ListAdd(ExpandedStates, Grt.ValueFromInt(
      Ord(TRoutineFrame(FRoutineFrames[i]).Expanded)), False);

    Grt.ListAdd(ExpandedHeights, Grt.ValueFromInt(
      TRoutineFrame(FRoutineFrames[i]).ExpandedHeight), False);
  end;

  Grt.DictItem[Obj, 'routineExpandedStates'] := ExpandedStates;
  Grt.DictItem[Obj, 'routineExpandedHeights'] := ExpandedHeights;

  Grt.DictString[Obj, 'comment'] := CommentMemo.Text;

  inherited;
end;

// -----------------------------------------------------------------------------

procedure TMyxRoutineGroupEditorForm.ApplyChangesBtnClick(Sender: TObject);

begin
  ApplyChanges;
end;

// -----------------------------------------------------------------------------

procedure TMyxRoutineGroupEditorForm.OnRoutineChange(Sender: TObject);

var
  RoutineList: Pointer;

begin
  if (FSettingContent) then
    Exit;

  // if this is the last RoutineFrame, add a new one
  if (FRoutineFrames[FRoutineFrames.Count - 1] = Sender) and
    (Length(TRoutineFrame(Sender).RoutineUce.Content.Text) > 0) then
  begin
    AddRoutineBox;

    if (Sender is TRoutineFrame) then
    begin
      RoutineList := Grt.DictItem[Obj, 'routines'];

      Grt.ListAdd(RoutineList,
        Grt.DictItem[TRoutineFrame(Sender).Routine, '_id']);
    end;
  end;

  Modified := True;
end;

// -----------------------------------------------------------------------------

procedure TMyxRoutineGroupEditorForm.AddRoutineBox(Routine: Pointer);

var
  RoutineFrame: TRoutineFrame;
  RoutineFrameHeight, RoutineFrameExpanded: Integer;
  List, Val: Pointer;

begin
  RoutineFrame := TRoutineFrame.Create(nil);
  RoutineFrame.Parent := RoutinesScrollBox;
  RoutineFrame.Top := 10000;
  RoutineFrame.Align := alTop;
  RoutineFrame.OnChange := OnRoutineChange;
  RoutineFrame.OnDelete := OnRoutineDelete;
  RoutineFrame.OnHeaderDrag := DoRoutineHeaderDrag;
  RoutineFrame.OnHeaderDragStart := DoRoutineHeaderDragStart;
  RoutineFrame.OnHeaderDragStop := DoRoutineHeaderDragStop;

  RoutineFrame.Schema := Grt.DictRef[Obj, 'owner'];
  RoutineFrame.Routine := Routine;

  RoutineFrameHeight := 130;
  List := Grt.DictItem[Obj, 'routineExpandedHeights'];
  if (List <> nil) then
  begin
    Val := Grt.ListItem[List, FRoutineFrames.Count];
    if (Val <> nil) then
      RoutineFrameHeight := Grt.ValueInt[Val];
  end;


  RoutineFrame.AutoCalcSize := (RoutineFrameHeight = 0);
  RoutineFrame.Height := RoutineFrameHeight;
  RoutineFrame.ExpandedHeight := RoutineFrame.Height;

  RoutineFrameExpanded := 1;
  List := Grt.DictItem[Obj, 'routineExpandedStates'];
  if (List <> nil) then
  begin
    Val := Grt.ListItem[List, FRoutineFrames.Count];
    if (Val <> nil) then
      RoutineFrameExpanded := Grt.ValueInt[Val];
  end;

  RoutineFrame.Expanded := (RoutineFrameExpanded = 1);

  FRoutineFrames.Add(RoutineFrame);
end;

// -----------------------------------------------------------------------------

procedure TMyxRoutineGroupEditorForm.CancelBtnClick(Sender: TObject);

begin
  Close;
end;

// -----------------------------------------------------------------------------

procedure TMyxRoutineGroupEditorForm.NameEdKeyDown(Sender: TObject;
  var Key: Word; Shift: TShiftState);

begin
  if (Key = VK_Return) and (FRoutineFrames.Count > 0) then
  begin
    TRoutineFrame(FRoutineFrames[0]).RoutineUce.SetFocus;
    Key := 0;
  end;
end;

// -----------------------------------------------------------------------------

procedure TMyxRoutineGroupEditorForm.OnRoutineDelete(Sender: TObject);

var
  RoutineList: Pointer;
  I, Count: Integer;

begin
  RoutineList := Grt.DictItem[Obj, 'routines'];
  Count := Grt.ListCount(RoutineList);

  for I := 0 to Count - 1 do
  begin
    if (Grt.ListRefItem[RoutineList, I] =
      TRoutineFrame(Sender).Routine) then
    begin
      Grt.ListDel(RoutineList, I);
      break;
    end;
  end;

  FRoutineFrames.Remove(Sender);

  Modified := True;
end;

// -----------------------------------------------------------------------------

procedure TMyxRoutineGroupEditorForm.DoRoutineHeaderDrag(Sender: TObject; YOffset: Integer);

var
  Index: Integer;
  RoutineFrame: TRoutineFrame;
begin
  Index := FRoutineFrames.IndexOf(Sender);

  if (Index > 0) then
  begin
    RoutineFrame := TRoutineFrame(FRoutineFrames[Index - 1]);
    if (RoutineFrame.Expanded) then
      RoutineFrame.Height :=
        FRoutineDragStartHeight + YOffset;

    RoutineFrame.ExpandedHeight :=
      FRoutineDragStartHeight + YOffset;
  end;
end;

// -----------------------------------------------------------------------------

procedure TMyxRoutineGroupEditorForm.DoRoutineHeaderDragStart(Sender: TObject);

var
  Index: Integer;

begin
  Index := FRoutineFrames.IndexOf(Sender);

  if (Index > 0) then
    FRoutineDragStartHeight :=
      TRoutineFrame(FRoutineFrames[Index - 1]).Height;
end;

// -----------------------------------------------------------------------------

procedure TMyxRoutineGroupEditorForm.DoRoutineHeaderDragStop(Sender: TObject);

begin
  //
end;

// -----------------------------------------------------------------------------

procedure TMyxRoutineGroupEditorForm.DoCommentUceChange(Sender: TObject; Line: TUCELine);

begin
  Modified := True;
end;

// -----------------------------------------------------------------------------

procedure TMyxRoutineGroupEditorForm.ApplyChangesAndCloseActionExecute(
  Sender: TObject);

begin
  ApplyChanges;
  Close;
end;

// -----------------------------------------------------------------------------

end.
