//
//  MWCanvasViewTab.mm
//  MySQL Workbench
//
//  Created by Alfredo Kojima on 05/6/17.
//  Copyright 2005 MySQL AB. All rights reserved.
//

#import "MWCanvasViewTab.h"

#import <WBCanvas/MCanvasScrollView.h>
#import <WBCanvas/MGenericCanvasView.h>

@implementation MWCanvasViewTab

- (id)initWithContent:(MCanvasScrollView*)scrollView
               canvas:(MGenericCanvasView*)canvas
                 view:(CGCView*)cview
                 name:(NSString*)name
{
  self= [super initWithIdentifier:name];
  if (self)
  {
    [self setLabel:name];
    [self setIcon:[NSImage imageNamed:@"tabsheet_icon_layer.png"]];
    
    _scrollView= [scrollView retain];
    _canvas= [canvas retain];
    _gcView= cview;
    [self setView:scrollView];
  }
  return self;
}


- (void)dealloc 
{
  [_scrollView release];
  [_canvas release];
  [super dealloc];
}


- (void)makeVisible
{
  [_canvas switchToCanvasView:_gcView];
}


- (CGCView*)gcView
{
  return _gcView;
}

@end
