// test_make_backup.cpp : Defines the entry point for the console application.
//

#include "stdio.h"
#include "stdlib.h"
#include "myx_admin_public_interface.h"

const char * connection_path;
const char * path_to_profile;
const char * path;
int interval;
const char * path_to_log;
const char * cuser_data;

void print_usage()
{
  printf(
    "usage : test_make_backup.exe <path_to_connection_file>\n"
    "     <path_to_profile_file> <path> <callback_interval>\n"
    "     <path_to_callback_log> <user data>\n");
}

FILE * progress_log_file= 0;

int progress_report_profile(const char *current_table_name, 
                            int num_tables, int num_tables_processed,
                            int num_rows, int num_rows_processed, 
                            void *user_data)
{
  fprintf(progress_log_file,
          "table \"%s\" (%d of %d), row %d of %d, user_data=\"%s\"\n",
          current_table_name,
          num_tables_processed, num_tables, num_rows_processed, num_rows,
          user_data);
  return 0;
}

int test_with_mysql_profile(MYSQL * mysql, MYX_BACKUP_PROFILE * profile)
{
  progress_log_file= fopen(path_to_log,"w");
  if (!progress_log_file)
  {
    return -1;
  }
  else
  {
    MYX_BACKUP_ERROR err= myx_make_backup_with_profile(mysql,profile,
                                                       path,interval,
                                                       progress_report_profile,
                                                       (void*)cuser_data);
    fclose(progress_log_file);
    if (err==MYX_BACKUP_NO_ERROR)
    {
      return 0;
    }
    else
    {
      fprintf(stderr,"myx_make_backup_with_profile returned error=%d\n",
              (int)err);
      if (err==MYX_BACKUP_SERVER_ERROR)
      {
        fprintf(stderr,"mysql_errno(mysql)=%u, mysql_error(mysql)=\"%s\"\n",
                mysql_errno(mysql),mysql_error(mysql));
      }
      return err;
    }
  }
}

int test_with_mysql(MYSQL * mysql)
{
  MYX_ADMIN_LIB_ERROR err;
  MYX_BACKUP_PROFILE * profile= myx_load_profile(path_to_profile,"",&err);
  
  int res;
  if (profile)
  {
    res= test_with_mysql_profile(mysql,profile);
  }
  else
  {
    fprintf(stderr,"can't read backup_profile from file \"%s\", error=%d\n",
            path_to_profile,(int)err);
    res= -1;
  }

  myx_free_profile(profile);
  return res;
}

int test_with_connecton(MYX_USER_CONNECTION * user_conn)
{
  char * var;
  if ((var= getenv("my_cnf_path")))
    myx_set_my_cnf_path(var);

  MYSQL * mysql= myx_mysql_init();
  if (!mysql)
  {
    fprintf(stderr,"can't init mysql!\n");
    return -1;
  }
  else
  {
    int res;
    if (!myx_connect_to_instance(user_conn,mysql))
    {
      res= test_with_mysql(mysql);
    }
    else
    {
      fprintf(stderr,"can't connect to mysql!\n");
      res= -1;
    }
    myx_mysql_close(mysql);
    return res;
  }
}

int main(int argc, char* argv[])
{
  if (argc<7)
  {
    print_usage();
    return 0;
  }
  else
  {
    connection_path= argv[1];
    path_to_profile= argv[2];
    path= argv[3];
    interval= atoi(argv[4]);
    path_to_log= argv[5];
    cuser_data= argv[6];

    MYX_LIB_ERROR err;
    MYX_USER_CONNECTIONS * connections=
                               myx_load_user_connections(connection_path,&err);
    if (!connections)
    {
      fprintf(stderr,"Can't read connection file \"%s\", error=%d\n",
              connection_path,(int)err);
      return -1;
    }
    else

    {
      int res;
      if (connections->user_connections_num)
      {
        res= test_with_connecton(connections->user_connections);
      }
      else
      {
        fprintf(stderr,"there aren't connections in the connection file\n");
        res= -1;
      }
      myx_free_user_connections(connections);
      return res;
    }
  }
}

