#include <Windows.h>
#include <stdio.h>
#include <winbase.h>
#include <initguid.h>
#include <ole2.h>
#include <mstask.h>
#include <msterr.h>
#include <wchar.h>

#define SCHED_CLASS             TEXT("SAGEWINDOWCLASS")
#define SCHED_TITLE             TEXT("SYSTEM AGENT COM WINDOW")
#define SCHED_SERVICE_APP_NAME  TEXT("mstask.exe")
#define SCHED_SERVICE_NAME      TEXT("Schedule")

//Returns 0 on success (if the task scheduler is running or was started successfully)
int myx_task_check_scheduler_running()
{
  
  OSVERSIONINFO osver;
  osver.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);
  
  /////////////////////////////////////////////////////
  // Determine which version of OS you are running.
  ////////////////////////////////////////////////////
  GetVersionEx(&osver);
  
  if (osver.dwPlatformId == VER_PLATFORM_WIN32_WINDOWS)
  {
    
    //////////////////////////////////////////////////
    // If Windows 95, check to see if Windows 95 
    // version of Task Scheduler is running.
    //////////////////////////////////////////////////
    HWND hwnd = FindWindow(SCHED_CLASS, SCHED_TITLE);
    
    if (hwnd != NULL)
    {
      // It is already running.
      return 0;
    }
    
    //  Execute the task scheduler process.
    STARTUPINFO         sui;
    PROCESS_INFORMATION pi;
    ZeroMemory(&sui, sizeof(sui));
    sui.cb = sizeof (STARTUPINFO);
    TCHAR szApp[MAX_PATH];
    LPTSTR pszPath;
    
    DWORD dwRet = SearchPath(NULL,
                             SCHED_SERVICE_APP_NAME,
                             NULL,
                             MAX_PATH,
                             szApp,
                             &pszPath);
    
    if (dwRet == 0)
    {
      return GetLastError();
    }
    
    BOOL fRet = CreateProcess(szApp,
                              NULL,
                              NULL,
                              NULL,
                              FALSE,
                              CREATE_NEW_CONSOLE | CREATE_NEW_PROCESS_GROUP,
                              NULL,
                              NULL,
                              &sui,
                              &pi);
    
    if (fRet == 0)
    {
      return GetLastError();
    }
    
    CloseHandle(pi.hProcess);
    CloseHandle(pi.hThread);
    return S_OK;
  }
  else
  {
    
    //////////////////////////////////////////////////
    // If not Windows 95, check to see if Windows NT 
    // version of Task Scheduler is running.
    //////////////////////////////////////////////////
    
    SC_HANDLE   hSC = NULL;
    SC_HANDLE   hSchSvc = NULL;
    
    hSC = OpenSCManager(NULL, NULL, SC_MANAGER_CONNECT);
    if (hSC == NULL)
    {
      return GetLastError();
    }
    
    hSchSvc = OpenService(hSC,
                          SCHED_SERVICE_NAME,
                          SERVICE_START | SERVICE_QUERY_STATUS);
    
    CloseServiceHandle(hSC);
    if (hSchSvc == NULL)
    {
      return GetLastError();
    }
    
    SERVICE_STATUS SvcStatus;
    
    if (QueryServiceStatus(hSchSvc, &SvcStatus) == FALSE)
    {
      CloseServiceHandle(hSchSvc);
      return GetLastError();
    }
    
    if (SvcStatus.dwCurrentState == SERVICE_RUNNING)
    {
      // The service is already running.
      CloseServiceHandle(hSchSvc);
      return 0;
    }
    
    if (StartService(hSchSvc, 0, NULL) == FALSE)
    {
      CloseServiceHandle(hSchSvc);
      return GetLastError();
    }
      
    CloseServiceHandle(hSchSvc);
    return 0;
  }
}


int myx_task_add_new(char *task_name, char *application, char *params, char *comment)
{
  HRESULT hr = S_OK;
  ITaskScheduler *pITS;
  
  
  /////////////////////////////////////////////////////////////////
  // Call CoInitialize to initialize the COM library and then 
  // CoCreateInstance to get the Task Scheduler object. 
  /////////////////////////////////////////////////////////////////
  hr = CoInitialize(NULL);
  if (SUCCEEDED(hr))
  {
     hr = CoCreateInstance(CLSID_CTaskScheduler,
                           NULL,
                           CLSCTX_INPROC_SERVER,
                           IID_ITaskScheduler,
                           (void **) &pITS);
     if (FAILED(hr))
     {
        CoUninitialize();
        return 1;
     }
  }
  else
  {
     return 1;
  }
  
  
  /////////////////////////////////////////////////////////////////
  // Call ITaskScheduler::NewWorkItem to create new task.
  /////////////////////////////////////////////////////////////////
  LPCWSTR pwszTaskName;
  ITask *pITask;
  IPersistFile *pIPersistFile;
  
  hr = pITS->NewWorkItem(task_name,           // Name of task
                         CLSID_CTask,            // Class identifier 
                         IID_ITask,              // Interface identifier
                         (IUnknown**)&pITask); // Address of task interface
  
  
  pITS->Release();                               // Release object
  if (FAILED(hr))
  {
     CoUninitialize();
     fprintf(stderr, "Failed calling NewWorkItem, error = 0x%x\n",hr);
     return 1;
  }

  ///////////////////////////////////////////////////////////////////
  // Call ITask::SetComment to specify the account name
  // and the account password for Test Task.
  ///////////////////////////////////////////////////////////////////
 
  hr = pITask->SetApplicationName(application);

  if (FAILED(hr))
  {
    wprintf(L"Failed calling ITask::SetApplicationName: ");
    wprintf(L"error = 0x%x\n",hr);
    CoUninitialize();
    return 1;
  }

  hr = pITask->SetParameters(params);

  if (FAILED(hr))
  {
    wprintf(L"Failed calling ITask::SetParametersName: ");
    wprintf(L"error = 0x%x\n",hr);
    CoUninitialize();
    return 1;
  }

  hr = pITask->SetComment(comment);

  if (FAILED(hr))
  {
    wprintf(L"Failed calling ITask::SetComment: ");
    wprintf(L"error = 0x%x\n",hr);
    CoUninitialize();
    return 1;
  }
  
  
  /////////////////////////////////////////////////////////////////
  // Call IUnknown::QueryInterface to get a pointer to 
  // IPersistFile and IPersistFile::Save to save 
  // the new task to disk.
  /////////////////////////////////////////////////////////////////
  
  hr = pITask->QueryInterface(IID_IPersistFile,
                              (void **)&pIPersistFile);
  
  pITask->Release();
  if (FAILED(hr))
  {
     CoUninitialize();
     fprintf(stderr, "Failed calling QueryInterface, error = 0x%x\n",hr);
     return 1;
  }
  
  
  hr = pIPersistFile->Save(NULL,
                           TRUE);
  pIPersistFile->Release();
  if (FAILED(hr))
  {
     CoUninitialize();
     fprintf(stderr, "Failed calling Save, error = 0x%x\n",hr);
     return 1;
  }
  
  
  printf("Created task.\n");
  return 0;
}

//trigger_type
// 0 .. Once
// 1 .. Daily
// 2 .. Weekly
// 3 .. monthly_date
// 4 .. monthly_dow
// 5 .. on_idle
// 6 .. at_systemstart
// 7 .. at_logon

int myx_task_add_trigger(int trigger_type, int start_hour, int start_minute)
{
  HRESULT hr = S_OK;
  ITaskScheduler *pITS;
  
  
  ///////////////////////////////////////////////////////////////////
  // Call CoInitialize to initialize the COM library and then
  // CoCreateInstance to get the Task Scheduler object.
  ///////////////////////////////////////////////////////////////////
  hr = CoInitialize(NULL);
  if (SUCCEEDED(hr))
  {
    hr = CoCreateInstance(CLSID_CTaskScheduler,
                          NULL,
                          CLSCTX_INPROC_SERVER,
                          IID_ITaskScheduler,
                          (void **) &pITS);
    if (FAILED(hr))
    {
      CoUninitialize();
      return 1;
    }
  }
  else
  {
     return 1;
  }
  
  
  ///////////////////////////////////////////////////////////////////
  // Call ITaskScheduler::Activate to get the Task object.
  ///////////////////////////////////////////////////////////////////
  
  ITask *pITask;
  LPCWSTR lpcwszTaskName;
  lpcwszTaskName = L"Test Task";
  hr = pITS->Activate(lpcwszTaskName,
                      IID_ITask,
                      (IUnknown**) &pITask);
  if (FAILED(hr))
  {
     wprintf(L"Failed calling ITaskScheduler::Activate: ");
     wprintf(L"error = 0x%x\n",hr);
     CoUninitialize();
     return 1;
  }
    pITS->Release();
  
  
  ///////////////////////////////////////////////////////////////////
  // Call ITask::CreateTrigger to create new trigger.
  ///////////////////////////////////////////////////////////////////
  
  ITaskTrigger *pITaskTrigger;
  WORD piNewTrigger;
  hr = pITask->CreateTrigger(&piNewTrigger,
                             &pITaskTrigger);
  if (FAILED(hr))
  {
    wprintf(L"Failed calling ITask::CreatTrigger: ");
    wprintf(L"error = 0x%x\n",hr);
    CoUninitialize();
    return 1;
  }
  
  
  //////////////////////////////////////////////////////
  // Define TASK_TRIGGER structure. Note that wBeginDay,
  // wBeginMonth, and wBeginYear must be set to a valid 
  // day, month, and year respectively.
  //////////////////////////////////////////////////////
  
  TASK_TRIGGER pTrigger;
  ZeroMemory(&pTrigger, sizeof (TASK_TRIGGER));
  
  // Add code to set trigger structure?
  pTrigger.wBeginDay =1;                  // Required
  pTrigger.wBeginMonth =1;                // Required
  pTrigger.wBeginYear =1999;              // Required
  pTrigger.cbTriggerSize = sizeof (TASK_TRIGGER); 
  pTrigger.wStartHour = start_hour;
  pTrigger.wStartMinute = start_minute;
  pTrigger.TriggerType = (TASK_TRIGGER_TYPE)trigger_type;
  pTrigger.Type.Daily.DaysInterval = 1;
  
  
  ///////////////////////////////////////////////////////////////////
  // Call ITaskTrigger::SetTrigger to set trigger criteria.
  ///////////////////////////////////////////////////////////////////
  
  hr = pITaskTrigger->SetTrigger (&pTrigger);
  if (FAILED(hr))
  {
    wprintf(L"Failed calling ITaskTrigger::SetTrigger: ");
    wprintf(L"error = 0x%x\n",hr);
    CoUninitialize();
    return 1;
  }
  
  
  ///////////////////////////////////////////////////////////////////
  // Call IPersistFile::Save to save trigger to disk.
  ///////////////////////////////////////////////////////////////////
  
  IPersistFile *pIPersistFile;
  hr = pITask->QueryInterface(IID_IPersistFile,
                              (void **)&pIPersistFile);
  hr = pIPersistFile->Save(NULL,
                           TRUE);
  
  wprintf(L"The trigger was created and IPersistFile::Save was \n");
  wprintf(L"called to save the new trigger to disk.\n"); 
  
  
  ///////////////////////////////////////////////////////////////////
  // Release resources.
  ///////////////////////////////////////////////////////////////////
  
  pITask->Release();
  pITaskTrigger->Release();
  pIPersistFile->Release();
  CoUninitialize();
  return 0;
}