#ifndef MAILSTORE_WATCHER_H
#define MAILSTORE_WATCHER_H

#include <limits.h>
#include <sys/types.h>
#include <time.h>
#include <stdio.h> // FILENAME_MAX

#include <map>
#include <set>
#include <string>

#include "compat.h"

class mailstore_config
{
  public:
	mailstore_config();
	~mailstore_config();

	char* name;
	char** watch_bin;
	unsigned watch_bin_len;
};

#define MAILBOXNAME_MAX FILENAME_MAX

class mailstore_watcher
{
  public:
	mailstore_watcher(bool quiet, const mailstore_config* config, time_t default_inter_delay, const std::map<std::string, time_t>* inter_delays);
	~mailstore_watcher();

	bool start();
	void stop();
	bool is_running();

	// Try to read in more change descriptions
	// Return >1 if a complete change was read in (returns min inter_delay)
	// Return -1 if no complete changes were read in
	time_t read_changes();

	const char* name;
	int from_fd;
	std::set<std::string> mailboxes;

  private:
	bool quiet;
	const mailstore_config* config;
	const time_t default_inter_delay;
	const std::map<std::string, time_t>* inter_delays;

	pid_t watcher_pid;
	int to_fd;
	char mailboxes_buf[MAILBOXNAME_MAX];
	int mailboxes_buf_len;
};

#endif // MAILSTORE_WATCHER_H
