//
// PadCodon.cs
//
// Author:
//   Lluis Sanchez Gual
//

//
// Copyright (C) 2005 Novell, Inc (http://www.novell.com)
//
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
// 
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
// LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
// OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//


using System;
using System.Collections;
using MonoDevelop.Core.AddIns;
using MonoDevelop.Core.Gui;
using MonoDevelop.Ide.Gui;

namespace MonoDevelop.Ide.Codons
{
	[CodonNameAttribute ("Pad")]
	internal class PadCodon : AbstractCodon
	{
		IPadContent content;
		
		[XmlMemberAttribute("context")]
		string context = null;
		
		[XmlMemberAttribute("_label")]
		string label = null;
		
		[XmlMemberAttribute("icon")]
		string icon = null;

		string[] contexts;
		
		public IPadContent Pad {
			get { return content; }
		}
		
		public string Label {
			get { return label; }
		}
		
		public string Icon {
			get { return icon; }
		}
		
		public string[] Contexts {
			get { return contexts; }
		}
		
		public override object BuildItem (object owner, ArrayList subItems, ConditionCollection conditions)
		{
			content = CreatePad ();
			return this;
		}
		
		protected virtual IPadContent CreatePad ()
		{
			if (context != null)
				contexts = context.Split (',');

			IPadContent pad = (IPadContent) AddIn.CreateObject (Class);
			if (pad == null) throw new ApplicationException ("Could not create pad of type: " + Class);
			return pad;
		}
	}
}
