<?php
/** Brazilian Portuguese (Português do Brasil)
 *
 * @addtogroup Language
 *
 * @author Yves Marques Junqueira
 * @author Rodrigo Calanca Nishino
 * @author Siebrand
 * @author לערי ריינהארט
 * @author 555
 * @author Nike
 * @author SPQRobin
 */

$fallback = 'pt';

$skinNames = array(
	'standard'    => 'Clássico',
	'nostalgia'   => 'Nostalgia',
	'cologneblue' => 'Azul colonial',
	'monobook'    => 'MonoBook',
	'myskin'      => 'MySkin',
	'chick'       => 'Chique',
	'simple'      => 'Simples',
	'modern'      => 'Moderno',
);

/**
 * The date format to use for generated dates in the user interface.
 * This may be one of the above date preferences, or the special value
 * "dmy or mdy", which uses mdy if $wgAmericanDates is true, and dmy
 * if $wgAmericanDates is false.
 */
$defaultDateFormat = 'dmy';

/**
 * These are formats for dates generated by MediaWiki (as opposed to the wikitext
 * DateFormatter). Documentation for the format string can be found in
 * Language.php, search for sprintfDate.
 *
 * This array is automatically inherited by all subclasses. Individual keys can be
 * overridden.
 */
$dateFormats = array(

	'dmy time' => 'H\hi\m\i\n',
	'dmy date' => 'j \d\e F \d\e Y',
	'dmy both' => 'H\hi\m\i\n \d\e j \d\e F \d\e Y',

);

$namespaceNames = array(
	NS_MEDIA          => 'Media',
	NS_SPECIAL        => 'Especial',
	NS_MAIN           => '',
	NS_TALK           => 'Discussão',
	NS_USER           => 'Usuário',
	NS_USER_TALK      => 'Usuário_Discussão',
	# NS_PROJECT set by $wgMetaNamespace
	NS_PROJECT_TALK   => '$1_Discussão',
	NS_IMAGE          => 'Imagem',
	NS_IMAGE_TALK     => 'Imagem_Discussão',
	NS_MEDIAWIKI      => 'MediaWiki',
	NS_MEDIAWIKI_TALK => 'MediaWiki_Discussão',
	NS_TEMPLATE       => 'Predefinição',
	NS_TEMPLATE_TALK  => 'Predefinição_Discussão',
	NS_HELP           => 'Ajuda',
	NS_HELP_TALK      => 'Ajuda_Discussão',
	NS_CATEGORY       => 'Categoria',
	NS_CATEGORY_TALK  => 'Categoria_Discussão'
);

$linkTrail = "/^([a-z]+)(.*)\$/sD";

$specialPageAliases = array(
	'DoubleRedirects'           => array( 'Redirecionamentos_duplos', 'Redireccionamentos_duplos' ),
	'BrokenRedirects'           => array( 'Redirecionamentos_quebrados', 'Redireccionamentos_quebrados' ),
	'Disambiguations'           => array( 'Páginas_de_desambiguação', 'Desambiguar', 'Desambiguações' ),
	'Userlogin'                 => array( 'Entrar', 'Login' ),
	'Userlogout'                => array( 'Sair', 'Logout' ),
	'CreateAccount'             => array( 'Criar_conta' ),
	'Preferences'               => array( 'Preferências' ),
	'Watchlist'                 => array( 'Páginas_vigiadas', 'Artigos_vigiados', 'Vigiados' ),
	'Recentchanges'             => array( 'Mudanças_recentes' ),
	'Upload'                    => array( 'Carregar_imagem', 'Carregar_ficheiro', 'Carregar_arquivo', 'Enviar' ),
	'Imagelist'                 => array( 'Lista_de_imagens', 'Lista_de_ficheiros', 'Lista_de_arquivos' ),
	'Newimages'                 => array( 'Imagens_novas', 'Ficheiros_novos', 'Arquivos_novos' ),
	'Listusers'                 => array( 'Lista_de_usuários', 'Lista_de_utilizadores' ),
	'Statistics'                => array( 'Estatísticas' ),
	'Randompage'                => array( 'Aleatória', 'Aleatório', 'Página_aleatória', 'Artigo_aleatório' ),
	'Lonelypages'               => array( 'Páginas_órfãs', 'Artigos_órfãos', 'Páginas_sem_afluentes', 'Artigos_sem_afluentes' ),
	'Uncategorizedpages'        => array( 'Páginas_sem_categorias', 'Artigos_sem_categorias' ),
	'Uncategorizedcategories'   => array( 'Categorias_sem_categorias' ),
	'Uncategorizedimages'       => array( 'Imagens_sem_categorias', 'Ficheiros_sem_categorias', 'Arquivos_sem_categorias' ),
	'Uncategorizedtemplates'    => array( 'Predefinições_não_categorizadas', 'Predefinições_sem_categorias' ),
	'Unusedcategories'          => array( 'Categorias_não_utilizadas', 'Categorias_sem_uso' ),
	'Unusedimages'              => array( 'Imagens_sem_uso', 'Imagens_não_utilizadas', 'Ficheiros_sem_uso', 'Ficheiros_não_utilizados', 'Arquivos_sem_uso', 'Arquivos_não_utilizados' ),
	'Wantedpages'               => array( 'Páginas_em_falta', 'Artigos_em_falta', 'Páginas_pedidas', 'Artigos_pedidos' ),
	'Wantedcategories'          => array( 'Categorias_em_falta', 'Categorias_inexistentes' ),
	'Mostlinked'                => array( 'Páginas_com_mais_afluentes', 'Artigos_com_mais_afluentes' ),
	'Mostlinkedcategories'      => array( 'Categorias_com_mais_afluentes' ),
	'Mostlinkedtemplates'       => array( 'Predefinições_com_mais_afluentes' ),
	'Mostcategories'            => array( 'Páginas_com_mais_categorias', 'Artigos_com_mais_categorias' ),
	'Mostimages'                => array( 'Imagens_com_mais_afluentes', 'Ficheiros_com_mais_afluentes', 'Arquivos_com_mais_afluentes' ),
	'Mostrevisions'             => array( 'Páginas_com_mais_edições', 'Artigos_com_mais_edições' ),
	'Fewestrevisions'           => array( 'Páginas_com_menos_edições', 'Artigos_com_menos_edições', 'Artigos_menos_editados' ),
	'Shortpages'                => array( 'Páginas_curtas', 'Artigos_curtos' ),
	'Longpages'                 => array( 'Páginas_longas', 'Artigos_extensos' ),
	'Newpages'                  => array( 'Páginas_novas', 'Artigos_novos' ),
	'Ancientpages'              => array( 'Páginas_inativas', 'Artigos_inativos' ),
	'Deadendpages'              => array( 'Páginas_sem_saída', 'Artigos_sem_saída' ),
	'Protectedpages'            => array( 'Páginas_protegidas', 'Artigos_protegidos' ),
	'Protectedtitles'           => array( 'Títulos_protegidos' ),
	'Allpages'                  => array( 'Todas_as_páginas', 'Todos_os_artigos', 'Todas_páginas', 'Todos_artigos' ),
	'Prefixindex'               => array( 'Índice_de_prefixo', 'Índice_por_prefixo' ),
	'Ipblocklist'               => array( 'Registro_de_bloqueios', 'IPs_bloqueados', 'Utilizadores_bloqueados', 'Usuários_bloqueados', 'Registo_de_bloqueios' ),
	'Specialpages'              => array( 'Páginas_especiais' ),
	'Contributions'             => array( 'Contribuições' ),
	'Emailuser'                 => array( 'Contactar_usuário', 'Contactar_utilizador', 'Contatar_usuário' ),
	'Confirmemail'              => array( 'Confirmar_e-mail', 'Confirmar_email' ),
	'Whatlinkshere'             => array( 'Páginas_afluentes', 'Artigos_afluentes' ),
	'Recentchangeslinked'       => array( 'Novidades_relacionadas', 'Mudanças_relacionadas' ),
	'Movepage'                  => array( 'Mover', 'Mover_página', 'Mover_artigo' ),
	'Blockme'                   => array( 'Bloquear-me', 'Auto-bloqueio' ),
	'Booksources'               => array( 'Fontes_de_livros' ),
	'Categories'                => array( 'Categorias' ),
	'Export'                    => array( 'Exportar' ),
	'Version'                   => array( 'Versão', 'Sobre' ),
	'Allmessages'               => array( 'Todas_as_mensagens', 'Todas_mensagens' ),
	'Log'                       => array( 'Registro', 'Registos', 'Registros', 'Registo' ),
	'Blockip'                   => array( 'Bloquear', 'Bloquear_IP', 'Bloquear_utilizador', 'Bloquear_usuário' ),
	'Undelete'                  => array( 'Restaurar', 'Restaurar_páginas_eliminadas', 'Restaurar_artigos_eliminados' ),
	'Import'                    => array( 'Importar' ),
	'Lockdb'                    => array( 'Bloquear_banco_de_dados', 'Bloquear_a_base_de_dados' ),
	'Unlockdb'                  => array( 'Desbloquear_banco_de_dados', 'Desbloquear_a_base_de_dados' ),
	'Userrights'                => array( 'Privilégios', 'Direitos', 'Estatutos' ),
	'MIMEsearch'                => array( 'Busca_MIME' ),
	'Unwatchedpages'            => array( 'Páginas_não-vigiadas', 'Páginas_não_vigiadas', 'Artigos_não-vigiados', 'Artigos_não_vigiados' ),
	'Listredirects'             => array( 'Redirecionamentos', 'Lista_de_redireccionamentos', 'Lista_de_redirecionamentos', 'Redireccionamentos' ),
	'Revisiondelete'            => array( 'Eliminar_edição', 'Eliminar_revisão', 'Apagar_edição', 'Apagar_revisão' ),
	'Unusedtemplates'           => array( 'Predefinições_sem_uso', 'Predefinições_não_utilizadas' ),
	'Randomredirect'            => array( 'Redirecionamento_aleatório', 'Redireccionamento_aleatório' ),
	'Mypage'                    => array( 'Minha_página' ),
	'Mytalk'                    => array( 'Minha_discussão' ),
	'Mycontributions'           => array( 'Minhas_contribuições', 'Minhas_edições' ),
	'Listadmins'                => array( 'Administradores', 'Admins', 'Lista_de_administradores', 'Lista_de_admins' ),
	'Listbots'                  => array( 'Bots', 'Lista_de_bots' ),
	'Popularpages'              => array( 'Páginas_populares', 'Artigos_populares' ),
	'Search'                    => array( 'Busca', 'Buscar', 'Procurar', 'Pesquisar', 'Pesquisa' ),
	'Resetpass'                 => array( 'Zerar_senha', 'Repor_senha' ),
	'Withoutinterwiki'          => array( 'Páginas_sem_interwikis', 'Artigos_sem_interwikis' ),
	'MergeHistory'              => array( 'Fundir_históricos', 'Fundir_edições' ),
);

$messages = array(
# User preference toggles
'tog-underline'               => 'Sublinhar links',
'tog-highlightbroken'         => 'Formatar links quebrados <a href="" class="new">assim</a> (alternativa: assim<a href="" class="internal">?</a>).',
'tog-justify'                 => 'Justificar parágrafos',
'tog-hideminor'               => 'Esconder as edições menores nas mudanças recentes',
'tog-extendwatchlist'         => 'Expandir a lista de páginas vigiadas para mostrar todas as alterações aplicáveis',
'tog-usenewrc'                => 'Mudanças recentes melhoradas (JavaScript)',
'tog-numberheadings'          => 'Auto-numerar cabeçalhos',
'tog-showtoolbar'             => 'Mostrar barra de edição (JavaScript)',
'tog-editondblclick'          => 'Editar páginas quando houver clique duplo (JavaScript)',
'tog-editsection'             => 'Habilitar edição de seção via links [editar]',
'tog-editsectiononrightclick' => 'Habilitar edição de seção por clique com o botão direito no título da seção (JavaScript)',
'tog-showtoc'                 => 'Mostrar Índice de conteúdo (para páginas com mais de três cabeçalhos)',
'tog-rememberpassword'        => 'Lembra senha entre sessões',
'tog-editwidth'               => 'Caixa de edição com largura completa',
'tog-watchcreations'          => 'Adicionar páginas criadas por mim à minha lista de páginas vigiadas',
'tog-watchdefault'            => 'Adicionar páginas editadas por mim à minha lista de páginas vigiadas',
'tog-watchmoves'              => 'Adicionar páginas movidas por mim à minha lista de páginas vigiadas',
'tog-watchdeletion'           => 'Adicionar páginas eliminadas por mim à minha lista de páginas vigiadas',
'tog-minordefault'            => 'Marcar todas as edições como menores, por padrão',
'tog-previewontop'            => 'Mostrar previsão antes da caixa de edição ao invés de ser após',
'tog-previewonfirst'          => 'Mostrar previsão na primeira edição',
'tog-nocache'                 => 'Desabilitar caching de página',
'tog-enotifwatchlistpages'    => 'Enviar-me um e-mail quando houver mudanças nas páginas vigiadas por mim',
'tog-enotifusertalkpages'     => 'Enviar-me um email quando a minha página de discussão for editada',
'tog-enotifminoredits'        => 'Enviar-me um email também quando forem edições menores',
'tog-enotifrevealaddr'        => 'Revelar o meu endereço de email nas notificações',
'tog-shownumberswatching'     => 'Mostrar o número de usuários que estão vigiando',
'tog-fancysig'                => 'Assinaturas sem atalhos automáticos',
'tog-externaleditor'          => 'Usar editor externo por padrão',
'tog-externaldiff'            => 'Usar diferenças externas por padrão',
'tog-showjumplinks'           => 'Ativar links de acessibilidade "ir para"',
'tog-uselivepreview'          => 'Usar pré-visualização em tempo real (JavaScript) (Experimental)',
'tog-forceeditsummary'        => 'Me avisar ao inserir um sumário de edição em branco',
'tog-watchlisthideown'        => 'Ocultar as minhas edições da lista de páginas vigiadas',
'tog-watchlisthidebots'       => 'Ocultar as edições efetuadas por bots da lista de páginas vigiadas',
'tog-watchlisthideminor'      => 'Ocultar as edições menores da lista de páginas vigiadas',
'tog-ccmeonemails'            => 'Enviar para mim cópias de e-mails que eu enviar a outros usuários',
'tog-diffonly'                => 'Não mostrar o conteúdo da página ao comparar duas edições',

'underline-always'  => 'Sempre',
'underline-never'   => 'Nunca',
'underline-default' => 'Padrão do navegador',

'skinpreview' => '(Pré-visualizar)',

# Dates
'sunday'        => 'Domingo',
'monday'        => 'Segunda',
'tuesday'       => 'Terça-Feira',
'wednesday'     => 'Quarta-Feira',
'thursday'      => 'Quinta-Feira',
'friday'        => 'Sexta-Feira',
'saturday'      => 'Sábado',
'sun'           => 'Dom',
'mon'           => 'Seg',
'tue'           => 'Ter',
'wed'           => 'Qua',
'thu'           => 'Qui',
'fri'           => 'Sex',
'sat'           => 'Sáb',
'january'       => 'Janeiro',
'february'      => 'Fevereiro',
'march'         => 'Março',
'april'         => 'Abril',
'may_long'      => 'Maio',
'june'          => 'Junho',
'july'          => 'Julho',
'august'        => 'Agosto',
'september'     => 'Setembro',
'october'       => 'Outubro',
'november'      => 'Novembro',
'december'      => 'Dezembro',
'january-gen'   => 'Janeiro',
'february-gen'  => 'Fevereiro',
'march-gen'     => 'Março',
'april-gen'     => 'Abril',
'may-gen'       => 'Maio',
'june-gen'      => 'Junho',
'july-gen'      => 'Julho',
'august-gen'    => 'Agosto',
'september-gen' => 'Setembro',
'october-gen'   => 'Outubro',
'november-gen'  => 'Novembro',
'december-gen'  => 'Dezembro',
'jan'           => 'Jan',
'feb'           => 'Fev',
'mar'           => 'Mar',
'apr'           => 'Abr',
'may'           => 'Mai',
'jun'           => 'Jun',
'jul'           => 'Jul',
'aug'           => 'Ago',
'sep'           => 'Set',
'oct'           => 'Out',
'nov'           => 'Nov',
'dec'           => 'Dez',

# Bits of text used by many pages
'categories'            => 'Categorias',
'pagecategories'        => '{{PLURAL:$1|Categoria|Categorias}}',
'category_header'       => 'Páginas na categoria "$1"',
'subcategories'         => 'Subcategorias',
'category-media-header' => 'Multimídia na categoria "$1"',
'category-empty'        => "''Esta categoria no momento não possui nenhuma página de conteúdo ou arquivo multimídia.''",

'mainpagetext'      => "<big>'''O MediaWiki foi instalado com sucesso.'''</big>",
'mainpagedocfooter' => 'Consulte o [http://meta.wikimedia.org/wiki/Help:Contents Manual de Usuário] para informações de como usar o software wiki.

== Começando ==

* [http://www.mediawiki.org/wiki/Manual:Configuration_settings Lista de opções de configuração]
* [http://www.mediawiki.org/wiki/Manual:FAQ FAQ do MediaWiki]
* [http://lists.wikimedia.org/mailman/listinfo/mediawiki-announce Lista de discussão com avisos de novas versões do MediaWiki]',

'about'          => 'Sobre',
'article'        => 'Página de conteúdo',
'newwindow'      => '(abrir em uma nova janela)',
'cancel'         => 'Cancelar',
'qbfind'         => 'Procurar',
'qbbrowse'       => 'Navegar',
'qbedit'         => 'Editar',
'qbpageoptions'  => 'Esta página',
'qbpageinfo'     => 'Contexto',
'qbmyoptions'    => 'Minhas páginas',
'qbspecialpages' => 'Páginas especiais',
'moredotdotdot'  => 'Mais...',
'mypage'         => 'Minha página',
'mytalk'         => 'Minha discussão',
'anontalk'       => 'Discussão para este IP',
'navigation'     => 'Navegação',
'and'            => 'e',

# Metadata in edit box
'metadata_help' => 'Metadados:',

'errorpagetitle'    => 'Erro',
'returnto'          => 'Retornar para $1.',
'tagline'           => 'De {{SITENAME}}',
'help'              => 'Ajuda',
'search'            => 'Pesquisar',
'searchbutton'      => 'Pesquisar',
'go'                => 'Ir',
'searcharticle'     => 'Ir',
'history'           => 'Histórico',
'history_short'     => 'Histórico',
'updatedmarker'     => 'atualizado desde o meu último acesso',
'info_short'        => 'Informação',
'printableversion'  => 'Versão para impressão',
'permalink'         => 'Link permanente',
'print'             => 'Imprimir',
'edit'              => 'Editar',
'editthispage'      => 'Editar esta página',
'delete'            => 'Eliminar',
'deletethispage'    => 'Eliminar esta página',
'undelete_short'    => 'Restaurar {{PLURAL:$1|uma edição|$1 edições}}',
'protect'           => 'Proteger',
'protect_change'    => 'alterar proteção',
'protectthispage'   => 'Proteger esta página',
'unprotect'         => 'Desproteger',
'unprotectthispage' => 'Desproteger esta página',
'newpage'           => 'Página nova',
'talkpage'          => 'Discutir sobre esta página',
'talkpagelinktext'  => 'Discussão',
'specialpage'       => 'Página especial',
'personaltools'     => 'Ferramentas pessoais',
'postcomment'       => 'Enviar um comentário',
'articlepage'       => 'Ver página de conteúdo',
'talk'              => 'Discussão',
'views'             => 'Acessos',
'toolbox'           => 'Ferramentas',
'userpage'          => 'Ver página de usuário',
'projectpage'       => 'Ver página de projeto',
'imagepage'         => 'Ver página de imagens',
'mediawikipage'     => 'Ver página de mensagens',
'templatepage'      => 'Ver página de predefinições',
'viewhelppage'      => 'Ver página de ajuda',
'categorypage'      => 'Ver página de categorias',
'viewtalkpage'      => 'Ver discussão',
'otherlanguages'    => 'Outras línguas',
'redirectedfrom'    => '(Redirecionado de $1)',
'redirectpagesub'   => 'Página de redirecionamento',
'lastmodifiedat'    => 'Está página foi modificada pela última vez às $2 de $1.', # $1 date, $2 time
'viewcount'         => 'Esta página foi acessada {{plural:$1|uma vez|$1 vezes}}.',
'protectedpage'     => 'Página protegida',
'jumpto'            => 'Ir para:',
'jumptonavigation'  => 'navegação',
'jumptosearch'      => 'pesquisa',

# All link text and link target definitions of links into project namespace that get used by other message strings, with the exception of user group pages (see grouppage) and the disambiguation template definition (see disambiguations).
'aboutsite'         => 'Sobre',
'aboutpage'         => 'Project:Sobre',
'bugreports'        => 'Relatar bugs',
'bugreportspage'    => 'Project:Relatos_de_bugs',
'copyright'         => 'Conteúdo disponível sob $1.',
'copyrightpagename' => 'Direitos autorais da {{SITENAME}}',
'copyrightpage'     => '{{ns:project}}:Direitos_autorais',
'currentevents'     => 'Eventos atuais',
'currentevents-url' => 'Project:Eventos atuais',
'disclaimers'       => 'Alerta de Conteúdo',
'disclaimerpage'    => 'Project:Aviso_geral',
'edithelp'          => 'Ajuda de edição',
'edithelppage'      => 'Help:Editar',
'faq'               => 'FAQ',
'faqpage'           => 'Project:FAQ',
'helppage'          => 'Help:Conteúdos',
'mainpage'          => 'Página principal',
'policy-url'        => 'Project:Políticas',
'portal'            => 'Portal comunitário',
'portal-url'        => 'Project:Portal comunitário',
'privacy'           => 'Política de privacidade',
'privacypage'       => 'Project:Política_de_privacidade',
'sitesupport'       => 'Doações',
'sitesupport-url'   => 'Project:Apoio',

'badaccess'        => 'Erro de permissão',
'badaccess-group0' => 'Você não está autorizado a executar a ação requisitada.',
'badaccess-group1' => 'A ação que você requisitou está limitada a usuários do grupo $1.',
'badaccess-group2' => 'A ação que você requisitou está limitada a usuários de um dos seguintes grupos: $1.',
'badaccess-groups' => 'A ação que você requisitou está limitada a usuários de um dos seguintes grupos: $1.',

'versionrequired'     => 'É necessária a versão $1 do MediaWiki',
'versionrequiredtext' => 'Esta página requer a versão $1 do MediaWiki para poder ser utilizada. Consulte [[{{ns:special}}:Version|a página sobre a versão do sistema]].',

'ok'                      => 'OK',
'retrievedfrom'           => 'Obtido em "$1"',
'youhavenewmessages'      => 'Você tem $1 ($2).',
'newmessageslink'         => 'novas mensagens',
'newmessagesdifflink'     => 'comparar com a penúltima edição',
'youhavenewmessagesmulti' => 'Você tem novas mensagens em $1',
'editsection'             => 'editar',
'editold'                 => 'editar',
'editsectionhint'         => 'Editar seção: $1',
'toc'                     => 'Índice de conteúdo',
'showtoc'                 => 'mostrar',
'hidetoc'                 => 'ocultar',
'thisisdeleted'           => 'Ver ou restaurar $1?',
'viewdeleted'             => 'Ver $1?',
'restorelink'             => '{{PLURAL:$1|uma edição eliminada|$1 edições eliminadas}}',
'feedlinks'               => 'Feed:',
'page-rss-feed'           => 'Feed RSS de "$1"',

# Short words for each namespace, by default used in the namespace tab in monobook
'nstab-main'      => 'Página',
'nstab-user'      => 'Página de usuário',
'nstab-media'     => 'Página de mídia',
'nstab-special'   => 'Especial',
'nstab-project'   => 'Página de projeto',
'nstab-image'     => 'Arquivo',
'nstab-mediawiki' => 'Mensagem',
'nstab-template'  => 'Predefinição',
'nstab-help'      => 'Página de ajuda',
'nstab-category'  => 'Categoria',

# Main script and global functions
'nosuchaction'      => 'Ação inexistente',
'nosuchactiontext'  => 'A ação especificada pela URL não é reconhecida pelo MediaWiki.',
'nosuchspecialpage' => 'Esta página especial não existe',
'nospecialpagetext' => "<big>'''Você requisitou uma página especial inválida.'''</big>

Uma lista de páginas especiais válidas poderá ser encontrada em [[{{ns:special}}:Specialpages]].",

# General errors
'error'                => 'Erro',
'databaseerror'        => 'Erro no banco de dados',
'dberrortext'          => 'Ocorreu um erro de sintaxe de busca no banco de dados.
A última tentativa de busca no banco de dados foi:
<blockquote><tt>$1</tt></blockquote>
na função "<tt>$2</tt>".
O MySQL retornou o erro "<tt>$3: $4</tt>".',
'dberrortextcl'        => 'Ocorreu um erro de sintaxe de pesquisa no banco de dados.
A última tentativa de pesquisa no banco de dados foi:
"$1"
com a função"$2".
MySQL retornou o erro "$3: $4".',
'noconnect'            => 'Desculpe-nos! {{SITENAME}} está passando por algumas dificuldades técnicas e não pôde contactar o servidor de bando de dados. <br />
$1',
'nodb'                 => 'Não foi possível selecionar o banco de dados $1',
'cachederror'          => 'O que se segue é uma cópia em cache da página solicitada podendo, por isso mesmo, estar com os dados defasados.',
'laggedslavemode'      => 'Aviso: a página poderá não conter atualizações recentes.',
'readonly'             => 'Banco de dados disponível no modo "somente leitura"',
'enterlockreason'      => 'Entre com um motivo para trancá-lo, incluindo uma estimativa de quando poderá novamente ser destrancado',
'readonlytext'         => 'O banco-de-dados da {{SITENAME}} está atualmente bloqueado para novas entradas e outras modificações, provavelmente por uma manutenção rotineira; mais tarde voltará ao normal.

Quem fez o bloqueio oferece a seguinte explicação: $1',
'missingarticle'       => 'O Banco-de-Dados não encontrou o texto de uma página que deveria ter encontrado: "$1".

Isto é geralmente causado por se ter acessado um diff antigo ou um link de histórico que leva a uma página que foi eliminada.

Se este não for o caso, você pode ter encontrado um "bug" no software.
Por favor, tome nota do URL e comunique o erro a um administrador do sistema.',
'readonly_lag'         => 'O banco de dados foi automaticamente bloqueado enquanto os servidores secundários se sincronizam com o principal',
'internalerror'        => 'Erro interno',
'internalerror_info'   => 'Erro interno: $1',
'filecopyerror'        => 'Não foi possível copiar o arquivo "$1" para "$2".',
'filerenameerror'      => 'Não foi possível renomear o arquivo "$1" para "$2"',
'filedeleteerror'      => 'Não foi possível eliminar o arquivo "$1".',
'directorycreateerror' => 'Não foi possível criar o diretório "$1".',
'filenotfound'         => 'Não foi possível encontrar o arquivo "$1".',
'fileexistserror'      => 'Não foi possível gravar no arquivo "$1": ele já existe',
'unexpected'           => 'Valor não esperado: "$1"="$2".',
'formerror'            => 'Erro: Não foi possível enviar o formulário',
'badarticleerror'      => 'Esta ação não pode ser executada nesta página.',
'cannotdelete'         => 'Não foi possível eliminar a página ou arquivo especificado. (provavelmente por já ter sido eliminada por outra pessoa.)',
'badtitle'             => 'Título inválido',
'badtitletext'         => 'O título de página requisitado é inválido, vazio, ou um link incorreto de inter-linguagem ou título inter-wiki. Pode ser que ele contenha um ou mais caracteres que não podem ser utilizados em títulos.',
'perfdisabled'         => 'Desculpe-nos! Esta opção foi temporariamente desabilitada porque tornava o banco de dados lento demais, a ponto de impossibilitar o correto funcionamento da {{SITENAME}}.',
'perfcached'           => 'Os dados a seguir se encontram em cache e, por isso mesmo, podem não estar atualizados.',
'perfcachedts'         => 'Os dados a seguir se encontram armazenados em cache e foram atualizados pela última vez a $1.',
'querypage-no-updates' => 'No momento as atualizações para esta página estão desativadas. Por enquanto, os dados aqui presentes não poderão ser atualizados.',
'wrong_wfQuery_params' => 'Parâmetros incorretos para wfQuery()<br />
Function: $1<br />
Query: $2',
'viewsource'           => 'Ver código-fonte',
'viewsourcefor'        => 'para $1',
'protectedpagetext'    => 'Esta página foi protegida contra novas edições.',
'viewsourcetext'       => 'Você pode ver e copiar o código desta página:',
'protectedinterface'   => 'Esta página fornece texto de interface ao software e encontra-se protegida, a fim de se prevenir eventuais abusos.',
'editinginterface'     => "'''Aviso:''' Você se encontra prestes a editar uma página que é utilizada para fornecer texto de interface ao software. Alterações nesta página irão afetar a aparência da interface de usuário para outros usuários. Para traduções, considere utilizar a [http://translatewiki.net/wiki/Main_Page?setlang=pt-br Betawiki], um projeto destinado para a tradução do MediaWiki.",
'sqlhidden'            => '(Consulta SQL em segundo-plano)',
'cascadeprotected'     => 'Esta página foi protegida contra edições por estar incluída {{PLURAL:$1|na página listada|nas páginas listadas}} a seguir, ({{PLURAL:$1|página essa que está protegida|páginas essas que estão protegidas}} com a opção de "proteção progressiva" ativada):
$2',
'namespaceprotected'   => "Você não possui permissão para editar páginas no espaço nominal '''$1'''.",
'customcssjsprotected' => 'Você não possui permissão para editar esta página, já que ela contém configurações pessoais de outro usuário.',
'ns-specialprotected'  => 'Não é possível editar páginas no espaço nominal {{ns:special}}.',
'titleprotected'       => 'Este título foi protegido, para que não seja criado. Quem o protegeu foi [[User:$1|$1]], com a justificativa: <i>$2</i>.',

# Login and logout pages
'logouttitle'           => 'Desautenticar do sistema',
'logouttext'            => '<strong>Você agora está desautenticado.</strong><br />
Você pode continuar a usar a {{SITENAME}} anonimamente, ou pode autenticar-se novamente com o mesmo nome de usuário ou com um nome de usuário diferente. Tenha em mente que algumas páginas poderão
continuar a ser apresentadas como se você ainda estivesse autenticado até que a cache de seu navegador seja limpa.',
'welcomecreation'       => '== Bem-vindo, $1! ==

A sua conta foi criada. Não se esqueça de personalizar as suas [[{{ns:special}}:Preferences|preferências]] na {{SITENAME}}.',
'loginpagetitle'        => 'Autenticação de usuário',
'yourname'              => 'Nome de usuário:',
'yourpassword'          => 'Senha:',
'yourpasswordagain'     => 'Redigite sua senha',
'remembermypassword'    => 'Lembrar de minha senha em outras sessões.',
'yourdomainname'        => 'Seu domínio:',
'externaldberror'       => 'Ocorreu um erro externo ao banco de dados durante a autenticação ou não lhe é permitido atualizar a sua conta externa.',
'loginproblem'          => '<b>Houve um problema com a sua autenticação.</b><br />Tente novamente!',
'login'                 => 'Entrar',
'loginprompt'           => 'É necessário estar com os <i>cookies</i> ativados para poder autenticar-se na {{SITENAME}}.',
'userlogin'             => 'Criar uma conta ou entrar',
'logout'                => 'Sair',
'userlogout'            => 'Sair',
'notloggedin'           => 'Não autenticado',
'nologin'               => 'Não possui uma conta? $1.',
'nologinlink'           => 'Criar uma conta',
'createaccount'         => 'Criar nova conta',
'gotaccount'            => 'Já possui uma conta? $1.',
'gotaccountlink'        => 'Entrar',
'createaccountmail'     => 'por e-mail',
'badretype'             => 'As senhas que você digitou não são iguais.',
'userexists'            => 'O nome de usuário que você digitou já existe. Por favor, escolha um nome diferente.',
'youremail'             => 'Seu e-mail:',
'username'              => 'Nome de usuário:',
'uid'                   => 'Número de identificação:',
'yourrealname'          => 'Nome real:',
'yourlanguage'          => 'Idioma:',
'yournick'              => 'Apelido:',
'email'                 => 'E-mail',
'prefs-help-realname'   => 'O fornecimento de seu Nome verdadeiro é opcional, mas, caso decida o revelar, este será utilizado para lhe dar crédito pelo seu trabalho.',
'loginerror'            => 'Erro de autenticação',
'noname'                => 'Você não colocou um nome de usuário válido.',
'loginsuccesstitle'     => 'Login bem sucedido',
'loginsuccess'          => "'''Agora você está logado na {{SITENAME}} como \"\$1\".'''",
'nosuchuser'            => 'Não há nenhum usuário com o nome "$1".
Verifique a grafia fornecida ou crie uma nova conta de usuário.',
'nosuchusershort'       => 'Não há um usuário com o nome "<nowiki>$1</nowiki>". Verifique o nome fornecido.',
'nouserspecified'       => 'É necessário especificar um nome de usuário.',
'wrongpassword'         => 'A senha que você forneceu é inválida. Por favor, tente novamente.',
'wrongpasswordempty'    => 'O campo de senha foi deixado em branco. Por favor, tente novamente.',
'passwordtooshort'      => 'A sua senha é inválida ou curta demais. É necessário ter no mínimo $1 caracteres e de ser diferente de seu nome de usuário.',
'mailmypassword'        => 'Envie uma nova senha por e-mail',
'passwordremindertitle' => 'Lembrador de senhas da {{SITENAME}}',
'passwordremindertext'  => 'Alguém (provavelmente você, a partir do endereço de IP $1) solicitou que fosse lhe enviada uma nova senha para {{SITENAME}} ($4).
A senha do usuário "$2" é, a partir de agora, "$3". Você pode entrar na sua conta e alterar a senha, caso prefira.

Se foi outra pessoa quem fez este pedido, ou caso você já se tenha lembrado da sua senha e não deseja a alterar, pode ignorar esta mensagem e continuar a utilizar a senha antiga.',
'noemail'               => 'Não há um endereço de e-mail associado ao usuário "$1".',
'passwordsent'          => 'Uma nova senha está sendo enviada para o endereço de e-mail registrado para "$1".
Por favor, reconecte-se ao recebê-lo.',
'eauthentsent'          => 'Uma mensagem de confirmação foi enviada para o endereço de e-mail fornecido.
Antes de qualquer outro e-mail ser enviado para a sua conta, você precisará seguir as instruções da mensagem, de modo a confirmar que a conta é mesmo sua.',
'mailerror'             => 'Erro ao enviar o e-mail: $1',
'emailconfirmlink'      => 'Confirme o seu endereço de e-mail',
'accountcreated'        => 'Conta criada',
'accountcreatedtext'    => 'A conta de usuário para $1 foi criada.',
'createaccount-title'   => 'Criação de conta em {{SITENAME}}',
'createaccount-text'    => 'Alguém criou uma conta de nome $2 para o seu endereço de e-mail no wiki {{SITENAME}} ($4), tendo como senha #$3". Você deve se autenticar e alterar sua senha.

Você pode ignorar esta mensagem caso a conta tenha sido criada por engano.',
'loginlanguagelabel'    => 'Idioma: $1',

# Password reset dialog
'resetpass'               => 'Zerar a senha da conta',
'resetpass_announce'      => 'Você foi autenticado através de uma senha temporária. Para prosseguir, será necessário definir uma nova senha.',
'resetpass_header'        => 'Zerar senha',
'resetpass_submit'        => 'Definir senha e entrar',
'resetpass_success'       => 'Sua senha foi alterada com sucesso! Autenticando-se...',
'resetpass_bad_temporary' => 'Senha temporária incorreta. Pode ser que você já tenha conseguido alterar a sua senha ou pedido que uma nova temporária fosse gerada.',
'resetpass_forbidden'     => 'Não é possível alterar senhas neste wiki',

# Edit page toolbar
'bold_sample'     => 'Texto em negrito',
'bold_tip'        => 'Texto em negrito',
'italic_sample'   => 'Texto em itálico',
'italic_tip'      => 'Texto em itálico',
'link_sample'     => 'Título do link',
'link_tip'        => 'Link interno',
'extlink_sample'  => 'http://www.wikimedia.org link externo',
'extlink_tip'     => 'Link externo (lembre-se do prefixo http://)',
'headline_sample' => 'Texto de cabeçalho',
'headline_tip'    => 'Seção de nível 2',
'math_sample'     => 'Inserir fórmula aqui',
'math_tip'        => 'Fórmula matemática (LaTeX)',
'nowiki_sample'   => 'Inserir texto não-formatado aqui',
'nowiki_tip'      => 'Ignorar formatação wiki',
'image_tip'       => 'Imagem embutida',
'media_tip'       => 'Link a arquivo interno de multimídia',
'sig_tip'         => 'Sua assinatura, com data e hora',
'hr_tip'          => 'Linha horizontal (use de forma moderada)',

# Edit pages
'summary'                   => 'Sumário',
'subject'                   => 'Assunto/cabeçalho',
'minoredit'                 => 'Marcar como edição menor',
'watchthis'                 => 'Vigiar esta página',
'savearticle'               => 'Salvar página',
'preview'                   => 'Prever',
'showpreview'               => 'Mostrar previsão',
'showlivepreview'           => 'Pré-visualização em tempo real',
'showdiff'                  => 'Mostrar alterações',
'anoneditwarning'           => "'''Atenção''': Você não se encontra autenticado. O seu endereço de IP será registrado no histórico de edições desta página.",
'missingsummary'            => "'''Lembrete:''' Você não introduziu um sumário de edição. Se clicar novamente em Salvar, a sua edição será salva sem um sumário.",
'missingcommenttext'        => 'Por favor, introduzida um comentário abaixo.',
'summary-preview'           => 'Previsão de sumário',
'blockedtitle'              => 'O usuário está bloqueado',
'blockedtext'               => '<big>O seu nome de usuário ou endereço de IP foi bloqueado</big>

O bloqueio foi realizado por $1. O motivo apresentado foi \'\'$2\'\'.

* Início do bloqueio: $8
* Expiração do bloqueio: $6
* Destino do bloqueio: $7

Você pode contactar $1 ou outro [[{{MediaWiki:Grouppage-sysop}}|administrador]] para discutir sobre o bloqueio.

Note que não poderá utilizar a funcionalidade "Contactar usuário" se não possuir uma conta neste wiki ({{SITENAME}}) com um endereço de email válido indicado nas suas [[{{ns:special}}:Preferences|preferências de usuário]] e se tiver sido bloqueado de utilizar tal recurso.

O seu endereço de IP atual é $3 e a ID de bloqueio é $5. Por favor, inclua um desses (ou ambos) dados em quaisquer tentativas de esclarecimentos.',
'autoblockedtext'           => 'O seu endereço de IP foi bloqueado de forma automática, uma vez que foi utilizado recentemente por outro usuário, o qual foi bloqueado por $1.
O motivo apresentado foi:

:\'\'$2\'\'

* Início do bloqueio: $8
* Expiração do bloqueio: $6

Você pode contactar $1 ou outro [[{{MediaWiki:Grouppage-sysop}}|administrador]] para discutir sobre o bloqueio.

Note que não poderá utilizar a funcionalidade "Contactar usuário" se não possuir uma conta neste wiki ({{SITENAME}}) com um endereço de email válido indicado nas suas [[{{ns:special}}:Preferences|preferências de usuário]] e se tiver sido bloqueado de utilizar tal recurso.

Sua ID de bloqueio é $5. Por favor, inclua esse dado em qualquer tentativa de esclarecimentos que for realizar.',
'blockednoreason'           => 'sem motivo especificado',
'blockedoriginalsource'     => "O código de '''$1''' é mostrado abaixo:",
'blockededitsource'         => "O texto das '''suas edições''' em '''$1''' é mostrado abaixo:",
'whitelistedittitle'        => 'É necessário autenticar-se para editar páginas',
'whitelistedittext'         => 'Você precisa $1 para poder editar páginas.',
'whitelistreadtitle'        => 'É necessária a autentificação para poder visualizar',
'whitelistreadtext'         => 'Você precisa se [[Special:Userlogin|logar]] para ler artigos.',
'whitelistacctitle'         => 'Não lhe é permitido criar uma conta',
'whitelistacctext'          => 'Para poder criar contas de usuário neste Wiki, você precisará estar [[Special:Userlogin|autenticado]] e possuir as devidas permissões.',
'confirmedittext'           => 'Você precisa confirmar o seu endereço de e-mail antes de começar a editar páginas. Por favor, introduza um e valide-o através das suas [[{{ns:special}}:Preferences|preferências de usuário]].',
'nosuchsectiontitle'        => 'Seção inexistente',
'nosuchsectiontext'         => 'Você tentou editar uma seção que não existe. Uma vez que não há a seção $1, não há um local para salvar a sua edição.',
'loginreqtitle'             => 'Autenticação Requerida',
'loginreqlink'              => 'autenticar-se',
'loginreqpagetext'          => 'Você precisa $1 para poder visualizar outras páginas.',
'accmailtitle'              => 'Senha enviada.',
'accmailtext'               => "A senha de '$1' foi enviada para $2.",
'newarticle'                => '(Nova)',
'newarticletext'            => "Você seguiu um link para uma página que não existe.
Para criá-la, começe escrevendo na caixa abaixo
(veja [[{{MediaWiki:Helppage}}|a página de ajuda]] para mais informações).
Se você chegou aqui por engano, apenas clique no botão '''voltar''' do seu navegador.",
'anontalkpagetext'          => "---- ''Esta é a página de discussão para um usuário anônimo que ainda não criou uma conta ou que não a usa, de forma que temos de utilizar o endereço de IP para identificá-lo(a). Um endereço de IP pode ser compartilhado por vários usuários. Se você é um usuário anônimo e acha irrelevantes os comentários direcionados a você, por gentileza, [[Special:Userlogin|crie uma conta ou autentique-se]], a fim de evitar futuras confusões com outros usuários anônimos.''",
'noarticletext'             => 'Não existe atualmente texto nesta página; você pode [[{{ns:special}}:Search/{{PAGENAME}}|pesquisar pelo título desta página em outras páginas]] ou [{{fullurl:{{FULLPAGENAME}}|action=edit}} editar esta página].',
'userpage-userdoesnotexist' => 'A conta "$1" não se encontra registrada. Por gentileza, verifique se deseja mesmo criar/editar esta página.',
'updated'                   => '(Atualizado)',
'note'                      => '<strong>Nota:</strong>',
'previewnote'               => '<strong>Isto é apenas uma previsão. As modificações ainda não foram salvas!</strong>',
'previewconflict'           => 'Esta previsão reflete o texto que está na área de edição acima e como ele aparecerá se você escolher salvar.',
'editing'                   => 'Editando $1',
'editinguser'               => "Modificando privilégios do usuário '''[[User:$1|$1]]''' ([[User talk:$1|{{int:talkpagelinktext}}]] | [[Special:Contributions/$1|{{int:contribslink}}]])",
'editingsection'            => 'Editando $1 (seção)',
'editingcomment'            => 'Editando $1 (comentário)',
'editconflict'              => 'Conflito de edição: $1',
'explainconflict'           => 'Alguém mudou a página enquanto você a estava editando.
A área de texto acima mostra o texto original.
Suas mudanças são mostradas na área abaixo.
Você terá que mesclar suas modificações no texto existente.
<b>SOMENTE</b> o texto na área acima será salvo quando você pressionar "Salvar página".<br />',
'yourtext'                  => 'Seu texto',
'storedversion'             => 'Versão guardada',
'editingold'                => '<strong>CUIDADO: Você está editando uma revisão desatualizada deste artigo.
Se você salvá-lo, todas as mudanças feitas a partir desta revisão serão perdidas.</strong>',
'yourdiff'                  => 'Diferenças',
'copyrightwarning'          => 'Por favor, note que todas as suas contribuições em {{SITENAME}} são consideradas como lançadas nos termos da licença $2 (veja $1 para detalhes). Se não deseja que o seu texto seja inexoravelmente editado e redistribuído de tal forma, não o envie.<br />
Você está, ao mesmo tempo, a garantir-nos que isto é algo escrito por você mesmo ou algo copiado de uma fonte de textos em domínio público ou similarmente de teor livre.
<strong>NÃO ENVIE TRABALHO PROTEGIDO POR DIREITOS AUTORAIS SEM A DEVIDA PERMISSÃO!</strong>',
'longpagewarning'           => '<strong>CUIDADO: Esta página tem $1 kilobytes; alguns browsers podem ter problemas ao editar páginas maiores que 32kb.
Por gentileza, considere quebrar a página em sessões menores.</strong>',
'readonlywarning'           => '<strong>CUIDADO: O banco de dados está sendo bloqueado para manutenção.
No momento não é possível salvar suas edições. Você pode copiar e colar o texto em um arquivo de texto e salvá-lo em seu computador para adicioná-lo ao wiki mais tarde.</strong>',
'protectedpagewarning'      => '<strong>CUIDADO: Apenas os usuários com privilégios de sysop podem editar esta página pois ela foi bloqueada.</strong>',
'semiprotectedpagewarning'  => "'''Nota:''' Esta página foi protegida, sendo que apenas usuários registrados poderão editá-la.",
'cascadeprotectedwarning'   => "'''Atenção:''' Esta página se encontra protegida; apenas {{int:group-sysop}} podem editá-la, uma vez que se encontra incluída {{PLURAL:\$1|na seguinte página protegida|nas seguintes páginas protegidas}} com a \"proteção progressiva\":",
'titleprotectedwarning'     => '<strong>ATENÇÃO: Esta página foi protegida, apenas alguns usuários poderão criá-la.</strong>',
'templatesused'             => 'Predefinições utilizadas nesta página:',
'templatesusedpreview'      => 'Predefinições utilizadas nesta previsão:',
'templatesusedsection'      => 'Predefinições utilizadas nesta seção:',
'template-protected'        => '(protegida)',
'template-semiprotected'    => '(semi-protegida)',
'nocreatetitle'             => 'A criação de páginas se encontra limitada',
'nocreatetext'              => '{{SITENAME}} tem restringida a habilidade de criar novas páginas.
Volte à tela anterior e edite uma página já existente, ou [[{{ns:special}}:Userlogin|autentique-se ou crie uma conta]].',
'nocreate-loggedin'         => 'Você não possui permissões de criar novas páginas neste wiki.',
'permissionserrors'         => 'Erros de permissões',
'permissionserrorstext'     => 'Você não possui permissão de fazer isso, {{PLURAL:$1|pelo seguinte motivo|pelos seguintes motivos}}:',
'recreate-deleted-warn'     => "'''Atenção: Você está re-criando uma página já eliminada em outra ocasião.'''

Certifique-se de que seja adequado prosseguir editando esta página.
O registro de eliminação desta página é exibido a seguir, para sua comodidade:",

# "Undo" feature
'undo-success' => 'A edição pôde ser desfeita. Por gentileza, verifique o comparativo a seguir para se certificar de que é isto que deseja fazer, salvando as alterações após ter terminado de revisá-las.',
'undo-failure' => 'A edição não pôde ser desfeita devido a alterações intermediárias conflitantes.',
'undo-summary' => 'Desfeita a edição $1 de [[{{ns:special}}:Contributions/$2|$2]] ([[User talk:$2|Discussão]])',

# Account creation failure
'cantcreateaccounttitle' => 'Não é possível criar uma conta',
'cantcreateaccount-text' => "Este IP (<b>$1</b>) foi bloqueado de criar novas contas por [[User:$3|$3]].

A justificativa apresentada por $3 foi ''$2''",

# History pages
'viewpagelogs'        => 'Ver registros para esta página',
'nohistory'           => 'Não há histórico de revisões para esta página.',
'revnotfound'         => 'Revisão não encontrada',
'revnotfoundtext'     => 'A antiga revisão da página que você está procurando não pode ser encontrada.
Por favor verifique a URL que você usou para acessar esta página.',
'loadhist'            => 'Carregando histórico',
'currentrev'          => 'Revisão atual',
'revisionasof'        => 'Edição de $1',
'revision-info'       => 'Edição feita às $1 por $2',
'previousrevision'    => '← Versão anterior',
'nextrevision'        => 'Versão posterior →',
'currentrevisionlink' => 'ver versão atual',
'cur'                 => 'atu',
'next'                => 'prox',
'last'                => 'ult',
'orig'                => 'orig',
'page_first'          => 'primeira',
'page_last'           => 'última',
'histlegend'          => 'Seleção para diferença: marque as caixas em uma das versões que deseja comparar e clique no botão.<br />
Legenda: (atu) = diferenças da versão atual,
(ult) = diferença da versão anterior, m = edição menor',
'deletedrev'          => '[eliminada]',
'histfirst'           => 'Mais antigas',
'histlast'            => 'Mais recentes',
'historysize'         => '({{PLURAL:$1|1 byte|$1 bytes}})',
'historyempty'        => '(vazio)',

# Revision feed
'history-feed-title'       => 'Histórico de edições',
'history-feed-description' => 'Histórico de edições para esta página neste wiki',

# Revision deletion
'rev-deleted-comment'     => '(comentário removido)',
'rev-deleted-user'        => '(nome de usuário removido)',
'rev-delundel'            => 'mostrar/ocultar',
'revisiondelete'          => 'Eliminar/restaurar edições',
'revdelete-nooldid-title' => 'Nenhuma edição foi selecionada',
'revdelete-selected'      => "{{PLURAL:$2|Edição selecionada|Edições selecionadas}} de '''[[:$1]]''':",
'logdelete-selected'      => "{{PLURAL:$2|Evento de registro selecionado|Eventos de registro selecionados}} para '''$1:'''",
'revdelete-legend'        => 'Atribuir restrições de edições:',
'revdelete-hide-user'     => 'Ocultar nome de usuário/IP do editor',
'revdelete-hide-image'    => 'Ocultar os conteúdos do arquivo',
'revdelete-unsuppress'    => 'Remover restrições das edições restauradas',
'revdelete-log'           => 'Comentário do registro:',
'revdelete-submit'        => 'Aplicar à edição selecionada',
'revdelete-logentry'      => 'foi modificada a visibilidade de edição para [[$1]]',
'logdelete-logentry'      => 'foi alterada a visibilidade de eventos para [[$1]]',
'revdelete-logaction'     => '$1 {{PLURAL:$1|edição definida|edições definidas}} como $2',
'logdelete-logaction'     => '$1 {{PLURAL:$1|evento|eventos}} de [[$3]] {{PLURAL:$1|definido|definidos}} como $2',
'revdelete-success'       => 'Visibilidade de edição definida com sucesso.',
'logdelete-success'       => 'Visibilidade de evento definida com sucesso.',

# Oversight log
'oversightlog' => 'Registro de edições ocultadas',

# Merge log
'mergelog' => 'Registro de fusão de históricos',

# Diffs
'history-title'           => 'Histórico de edições de "$1"',
'difference'              => '(Diferenças entre revisões)',
'lineno'                  => 'Linha $1:',
'compareselectedversions' => 'Compare as versões selecionadas',
'editundo'                => 'desfazer',
'diff-multi'              => '({{PLURAL:$1|uma edição intermediária não está sendo exibida|$1 edições intermediárias não estão sendo exibidas}}.)',

# Search results
'searchresults'         => 'Buscar resultados',
'searchresulttext'      => 'Para mais informações sobre busca na {{SITENAME}}, veja [[{{MediaWiki:Helppage}}|{{int:help}}]].',
'searchsubtitle'        => 'Para pedido de busca "[[:$1]]"',
'searchsubtitleinvalid' => 'Para pedido de busca "$1"',
'noexactmatch'          => "'''Não existe uma página com o título \"\$1\".''' Você pode [[:\$1|criar tal página]].",
'titlematches'          => 'Resultados nos títulos dos artigos',
'notitlematches'        => 'Sem resultados nos títulos dos artigos',
'textmatches'           => 'Resultados nos textos dos artigos',
'notextmatches'         => 'Sem resultados nos textos dos artigos',
'prevn'                 => 'anterior $1',
'nextn'                 => 'próximo $1',
'viewprevnext'          => 'Ver ($1) ($2) ($3).',
'showingresults'        => "A seguir {{PLURAL:$1|é mostrado '''um''' resultado|são mostrados até '''$1''' resultados}}, iniciando no '''$2'''º.",
'showingresultsnum'     => "A seguir {{PLURAL:$3|é mostrado '''um''' resultado|são mostrados '''$3''' resultados}}, iniciando com o '''$2'''º.",
'nonefound'             => '<strong>Nota</strong>: pesquisas mal sucedidas são geralmente causadas devido o uso de palavras muito comuns como "tem" e "de",
que não são indexadas, ou pela especificação de mais de um termo (somente as páginas contendo todos os termos aparecerão nos resultados).',
'powersearch'           => 'Pesquisar',
'powersearchtext'       => '
Procurar nos namespaces :<br />
$1<br />
$2 Lista redireciona &nbsp; Procura por $3 $9',

# Preferences page
'preferences'           => 'Preferências',
'mypreferences'         => 'Minhas preferências',
'prefsnologin'          => 'Não autenticado',
'prefsnologintext'      => 'Você precisa estar [[Special:Userlogin|autenticado]]
para definir suas preferências.',
'prefsreset'            => 'Preferências foram reconfiguradas.',
'qbsettings'            => 'Configurações da Barra Rápida',
'changepassword'        => 'Mudar senha',
'skin'                  => 'Aparência(Skin)',
'math'                  => 'Renderização matemática',
'dateformat'            => 'Formato da Data',
'math_failure'          => 'Falhou ao checar gramática(parse)',
'math_unknown_error'    => 'erro desconhecido',
'math_unknown_function' => 'função desconhecida',
'math_lexing_error'     => 'erro léxico',
'math_syntax_error'     => 'erro de síntaxe',
'saveprefs'             => 'Salvar preferências',
'resetprefs'            => 'Redefinir preferências',
'oldpassword'           => 'Senha antiga',
'newpassword'           => 'Nova senha',
'retypenew'             => 'Redigite a nova senha',
'textboxsize'           => 'Tamanho da caixa de texto',
'rows'                  => 'Linhas',
'columns'               => 'Colunas',
'searchresultshead'     => 'Configurar resultados de pesquisas',
'resultsperpage'        => 'Resultados por página',
'contextlines'          => 'Linhas por resultados',
'contextchars'          => 'Letras de contexto por linha',
'recentchangescount'    => 'Número de títulos em Mudanças Recentes',
'savedprefs'            => 'Suas preferências foram salvas.',
'timezonetext'          => 'Entre com o número de horas que o seu horário local difere do horário do servidor (UTC).',
'localtime'             => 'Display de hora local',
'timezoneoffset'        => 'Offset',
'servertime'            => 'Horário do servidor é',
'guesstimezone'         => 'Colocar no navegador',
'defaultns'             => 'Procurar nestes namespaces por padrão:',
'files'                 => 'Arquivos',

# User rights
'userrights-lookup-user'           => 'Administrar grupos de usuários',
'userrights-user-editname'         => 'Forneça um nome de usuário:',
'editusergroup'                    => 'Editar grupos de usuários',
'userrights-editusergroup'         => 'Editar grupos do usuário',
'saveusergroups'                   => 'Salvar grupos do usuário',
'userrights-groupsavailable'       => 'Grupos disponíveis:',
'userrights-groupshelp'            => 'Selecione os grupos nos quais deseja que o usuário seja removido ou adicionado.
Grupos não selecionados não serão alterados. Você pode selecionar ou des-selecionar um grupo com CTRL + clique esquerdo',
'userrights-reason'                => 'Motivo das alterações:',
'userrights-available-none'        => 'Não é possível alterar o grupo de acesso.',
'userrights-available-add'         => 'É possível adicionar usuários {{PLURAL:$2|neste grupo|nestes grupos}}: $1',
'userrights-available-remove'      => 'É possível remover usuários {{PLURAL:$2|deste grupo|destes grupos}}: $1.',
'userrights-available-add-self'    => 'Você pode se adicionar {{PLURAL:$2|neste grupo|nestes grupos}}: $1.',
'userrights-available-remove-self' => 'Você pode se remover {{PLURAL:$2|deste grupo|destes grupos}}: $1.',
'userrights-no-interwiki'          => 'Você não tem permissão de alterar privilégios de usuários em outras wikis.',
'userrights-nodatabase'            => 'O banco de dados $1 não existe ou não é um banco de dados local.',
'userrights-nologin'               => 'Você precisa [[Special:Userlogin|autenticar-se]] como um administrador para especificar os privilégios de usuário.',
'userrights-notallowed'            => 'Sua conta não possui permissão para conceder privilégios a usuários.',

# Groups
'group'               => 'Grupo:',
'group-autoconfirmed' => 'Usuários auto-confirmados',
'group-bot'           => 'Robôs',
'group-sysop'         => 'Administradores',
'group-bureaucrat'    => 'Burocratas',
'group-all'           => '(todos)',

'group-autoconfirmed-member' => 'Usuário auto-confirmado',
'group-bot-member'           => 'Robô',
'group-sysop-member'         => 'Administrador',
'group-bureaucrat-member'    => 'Burocrata',

'grouppage-autoconfirmed' => '{{ns:project}}:Auto-confirmados',
'grouppage-bot'           => '{{ns:project}}:Robôs',
'grouppage-sysop'         => '{{ns:project}}:Administradores',
'grouppage-bureaucrat'    => '{{ns:project}}:Burocratas',

# User rights log
'rightslog'      => 'Registro de privilégios de usuário',
'rightslogtext'  => 'Este é um registro de mudanças nos privilégios de usuários.',
'rightslogentry' => 'foi alterado o grupo de acesso de $1 (de $2 para $3)',
'rightsnone'     => '(nenhum)',

# Recent changes
'nchanges'                          => '$1 {{PLURAL:$1|alteração|alterações}}',
'recentchanges'                     => 'Mudanças recentes',
'recentchangestext'                 => 'Veja as mais novas mudanças na {{SITENAME}} nesta página.',
'recentchanges-feed-description'    => 'Acompanhe as Mudanças recentes deste wiki por este feed.',
'rcnote'                            => "A seguir {{PLURAL:$1|está listada '''uma''' alteração ocorrida|estão listadas '''$1''' alterações ocorridas}} {{PLURAL:$2|no último dia|nos últimos '''$2''' dias}}, a partir de $3.",
'rcnotefrom'                        => 'Abaixo estão as mudanças desde <b>$2</b> (mostradas até <b>$1</b>).',
'rclistfrom'                        => 'Mostrar as novas alterações a partir de $1',
'rcshowhideminor'                   => '$1 edições menores',
'rcshowhidebots'                    => '$1 bots',
'rcshowhideliu'                     => '$1 usuários registrados',
'rcshowhideanons'                   => '$1 usuários anônimos',
'rcshowhidepatr'                    => '$1 edições verificadas',
'rcshowhidemine'                    => '$1 as minhas edições',
'rclinks'                           => 'Mostrar as últimas $1 mudanças nos últimos $2 dias<br />$3',
'diff'                              => 'dif',
'hist'                              => 'hist',
'hide'                              => 'Esconder',
'show'                              => 'Mostrar',
'minoreditletter'                   => 'm',
'newpageletter'                     => 'N',
'boteditletter'                     => 'b',
'number_of_watching_users_pageview' => '[{{PLURAL:$1|$1 usuário|$1 usuários}} vigiando]',
'newsectionsummary'                 => '/* $1 */ nova seção',

# Recent changes linked
'recentchangeslinked'          => 'Alterações relacionadas',
'recentchangeslinked-title'    => 'Alterações relacionadas com $1',
'recentchangeslinked-noresult' => 'Não ocorreram alterações em páginas relacionadas no intervalo de tempo fornecido.',
'recentchangeslinked-summary'  => "Esta página especial lista as alterações mais recentes de páginas que possuam um link a outra. Páginas que estejam em sua lista de páginas vigiadas são exibidas em '''negrito'''.",

# Upload
'upload'                 => 'Carregar arquivo',
'uploadbtn'              => 'Enviar arquivo',
'reupload'               => 'Re-carregar',
'reuploaddesc'           => 'Retornar ao formulário de Uploads.',
'uploadnologin'          => 'Não autenticado',
'uploadnologintext'      => 'Você deve estar [[Special:Userlogin|autenticado]]
para carregar arquivos.',
'uploaderror'            => 'Erro ao Carregar',
'upload-permitted'       => 'Tipos de arquivos permitidos: $1.',
'upload-preferred'       => 'Tipos de arquivos preferidos: $1.',
'upload-prohibited'      => 'Tipos de arquivo proibidos: $1.',
'uploadlog'              => 'log de uploads',
'uploadlogpage'          => 'Registro de upload',
'uploadlogpagetext'      => 'Segue uma lista dos uploads mais recentes.
Todas as datas mostradas são do servidor (UTC).',
'filename'               => 'Nome do arquivo',
'filedesc'               => 'Sumário',
'fileuploadsummary'      => 'Sumário:',
'filestatus'             => 'Situação dos direitos autorais',
'filesource'             => 'Fonte',
'uploadedfiles'          => 'Arquivos carregados',
'minlength1'             => 'Os nomes de arquivos devem possuir no mínimo uma letra.',
'badfilename'            => 'O nome da imagem mudou para "$1".',
'filetype-unwanted-type' => "'''\".\$1\"''' é um tipo de arquivo não desejado. Os preferíveis são \$2.",
'filetype-banned-type'   => "'''\".\$1\"''' é um tipo de arquivo proibido. Os permitidos são \$2.",
'filetype-missing'       => 'O arquivo não possui uma extensão (como, por exemplo, ".jpg").',
'large-file'             => 'É recomendável que os arquivos não sejam maiores que $1; este possui $2.',
'fileexists-thumb'       => "<center>'''Imagem existente'''</center>",
'successfulupload'       => 'Carregamento efetuado com sucesso',
'uploadwarning'          => 'Aviso de Upload',
'savefile'               => 'Salvar arquivo',
'uploadedimage'          => 'enviou "[[$1]]"',
'overwroteimage'         => 'foi enviada uma nova versão de "[[$1]]"',
'uploaddisabled'         => 'Upload desativado.',
'uploaddisabledtext'     => 'O envio de arquivos se encontra desativado neste wiki.',
'uploadvirus'            => 'O arquivo contém vírus! Detalhes: $1',
'sourcefilename'         => 'Nome do arquivo de origem',
'destfilename'           => 'Nome do arquivo de destino',
'watchthisupload'        => 'Vigiar esta página',

'upload-proto-error' => 'Protocolo incorreto',
'upload-file-error'  => 'Erro interno',

# Some likely curl errors. More could be added from <http://curl.haxx.se/libcurl/c/libcurl-errors.html>
'upload-curl-error28' => 'Foi excedido o tempo limite para o envio do arquivo',

'license'            => 'Licença',
'nolicense'          => 'Nenhuma selecionada',
'license-nopreview'  => '(Previsão indisponível)',
'upload_source_file' => ' (um arquivo de seu computador)',

# Image list
'imagelist'                 => 'Lista de Imagens',
'imagelisttext'             => "É exibida a seguir uma listagem {{PLURAL:$1|de '''um''' arquivo organizado|de '''$1''' arquivos organizados}} por $2.",
'getimagelist'              => 'buscando lista de imagens',
'ilsubmit'                  => 'Procura',
'showlast'                  => 'Mostrar as  $1 imagens organizadas $2.',
'byname'                    => 'por nome',
'bydate'                    => 'por data',
'bysize'                    => 'por tamanho',
'imgdelete'                 => 'eli',
'imgdesc'                   => 'desc',
'imgfile'                   => 'arquivo',
'filehist'                  => 'Histórico do arquivo',
'filehist-help'             => 'Clique em uma data/horário para ver o arquivo tal como ele se encontrava em tal momento.',
'filehist-deleteall'        => 'eliminar todas',
'filehist-deleteone'        => 'eliminar esta',
'filehist-revert'           => 'reverter',
'filehist-current'          => 'atual',
'filehist-datetime'         => 'Data/Horário',
'filehist-user'             => '{{ns:user}}',
'filehist-dimensions'       => 'Dimensões',
'filehist-filesize'         => 'Tamanho do arquivo',
'filehist-comment'          => 'Comentário',
'imagelinks'                => 'Links',
'linkstoimage'              => 'As seguintes páginas apontam para este arquivo:',
'nolinkstoimage'            => 'Nenhuma página aponta para este arquivo.',
'sharedupload'              => 'Este arquivo encontra-se partilhado, podendo ser utilizado por outros projetos.',
'shareduploadwiki'          => 'Por gentileza, consulte a $1 para maiores informações.',
'noimage'                   => 'Não existe nenhum arquivo com este nome. Se desejar, pode $1',
'noimage-linktext'          => 'carregá-lo',
'uploadnewversion-linktext' => 'Enviar uma nova versão deste arquivo',
'imagelist_date'            => 'Data',
'imagelist_name'            => 'Nome',
'imagelist_user'            => 'Usuário',
'imagelist_size'            => 'Tamanho',
'imagelist_description'     => 'Descrição',

# File reversion
'filerevert-legend'     => 'Reverter arquivo',
'filerevert-badversion' => 'Não há uma versão local anterior deste arquivo no período de tempo especificado.',

# File deletion
'filedelete-legend'          => 'Eliminar arquivo',
'filedelete-iscurrent'       => 'Você está tentando eliminar a versão mais recente deste arquivo. Por gentileza, reverta para uma edição anterior antes de tentar novamente.',
'filedelete-reason-dropdown' => '*Motivos comuns para eliminação
** Violação de direitos autorais
** Arquivo em duplicata',

# MIME search
'mimesearch' => 'Pesquisa MIME',

# Unwatched pages
'unwatchedpages' => 'Páginas não vigiadas',

# List redirects
'listredirects' => 'Listar redirecionamentos',

# Unused templates
'unusedtemplates' => 'Predefinições não utilizadas',

# Random page
'randompage' => 'Página aleatória',

# Random redirect
'randomredirect' => 'Redirecionamento aleatório',

# Statistics
'statistics'    => 'Estatísticas',
'sitestats'     => 'Estatísticas do Site',
'userstats'     => 'Estatística dos usuários',
'sitestatstext' => "Há atualmente um total de {{PLURAL:\$1|'''\$1''' página|'''\$1''' páginas}} no banco de dados.
Isto inclui páginas de \"discussão\", páginas sobre o projecto ({{SITENAME}}), páginas de rascunho, redirecionamentos e outras que provavelmente não são qualificadas como páginas de conteúdo.
Excluindo estas, há {{PLURAL:\$2|'''\$2''' página que provavelmente é uma página de conteúdo legítima|'''\$2''' páginas que provavelmente são páginas de conteúdo legítimas}}.

'''\$8''' {{PLURAL:\$8|arquivo foi enviado|arquivos foram enviados}}.

Há um total de '''\$3''' {{PLURAL:\$3|página vista|páginas vistas}} e '''\$4''' {{PLURAL:\$4|edição|edições}} em páginas desde que este wiki foi instalado.
Isso nos leva a aproximadamente '''\$5''' edições por página e '''\$6''' acessos por edição.

O tamanho da [http://meta.wikimedia.org/wiki/Help:Job_queue fila de tarefas] é atualmente de '''\$7'''.",
'userstatstext' => "Há atualmente {{PLURAL:$1|'''$1''' usuário registrado|'''$1''' usuários registrados}}, dentre os quais '''$2''' (ou '''$4%''') {{PLURAL:$2|é|são}} $5.",

'disambiguations'     => 'Páginas de desambiguamento',
'disambiguationspage' => '{{ns:project}}:Links_para_desambiguar_páginas',

'doubleredirects'     => 'Redirecionamentos duplos',
'doubleredirectstext' => '<b>Atenção:</b> Esta lista pode conter positivos falsos. O que usualmente significa que há texto adicional com links depois do primeiro #REDIRECT.<br />
Cada linha contem links para o primeiro e segundo redirecionamento, bem como a primeira linha do segundo texto redirecionado , geralmente dando o artigo alvo "real" , para onde o primeiro redirecionamento deveria apontar.',

'brokenredirects'     => 'Redirecionamentos quebrados',
'brokenredirectstext' => 'Os seguintes redirecionamentos apontam para um artigo inexistente.',

'withoutinterwiki' => 'Páginas sem interwikis de idiomas',

'fewestrevisions' => 'Páginas com menos edições',

# Miscellaneous special pages
'nbytes'                  => '$1 {{PLURAL:$1|byte|bytes}}',
'nlinks'                  => '$1 {{PLURAL:$1|link|links}}',
'nmembers'                => '$1 {{PLURAL:$1|membro|membros}}',
'nviews'                  => '$1 {{PLURAL:$1|acesso|acessos}}',
'lonelypages'             => 'Páginas órfãs',
'uncategorizedpages'      => 'Páginas não categorizadas',
'uncategorizedcategories' => 'Categorias não categorizadas',
'uncategorizedimages'     => 'Imagens não categorizadas',
'uncategorizedtemplates'  => 'Predefinições não categorizadas',
'unusedcategories'        => 'Categorias não utilizadas',
'unusedimages'            => 'Imagens não utilizadas',
'popularpages'            => 'Páginas populares',
'wantedcategories'        => 'Categorias pedidas',
'wantedpages'             => 'Páginas pedidas',
'mostlinked'              => 'Páginas com mais afluentes',
'mostlinkedcategories'    => 'Categorias com mais membros',
'mostlinkedtemplates'     => 'Predefinições com mais afluentes',
'mostcategories'          => 'Páginas de conteúdo com mais categorias',
'mostimages'              => 'Imagens com mais afluentes',
'mostrevisions'           => 'Páginas de conteúdo com mais edições',
'allpages'                => 'Todas as páginas',
'prefixindex'             => 'Índice de prefixo',
'shortpages'              => 'Páginas curtas',
'longpages'               => 'Paginas longas',
'deadendpages'            => 'Páginas sem saída',
'protectedpages'          => 'Páginas protegidas',
'listusers'               => 'Lista de usuários',
'specialpages'            => 'Páginas especiais',
'spheading'               => 'Páginas especiais para todos os usuários',
'newpages'                => 'Páginas novas',
'newpages-username'       => 'Nome de usuário:',
'ancientpages'            => 'Páginas mais antigas',
'intl'                    => 'Links interlínguas',
'move'                    => 'Mover',
'movethispage'            => 'Mover esta página',
'unusedimagestext'        => '<p>Note que outros websites podem apontar para uma imagem através de um URL diretamente e, por isso, podem estar não aparecendo aqui, mesmo estando em uso.</p>',
'notargettitle'           => 'Sem alvo',
'notargettext'            => 'Você não especificou um alvo ou usuário para performar esta função.',

# Book sources
'booksources' => 'Fontes de livros',

'userrights'     => 'Gestão de privilégios de usuários',
'groups'         => 'Grupos de usuários',
'alphaindexline' => '$1 até $2',
'version'        => 'Versão',

# Special:Log
'specialloguserlabel'  => 'Usuário:',
'speciallogtitlelabel' => 'Título:',
'log'                  => 'Registros',
'all-logs-page'        => 'Todos os registros',
'log-search-legend'    => 'Pesquisar nos registros',
'logempty'             => 'Nenhum item idêntico no registro.',

# Special:Allpages
'nextpage'       => 'Próxima página ($1)',
'prevpage'       => 'Página anterior ($1)',
'allpagesfrom'   => 'Mostrar páginas a partir de:',
'allarticles'    => 'Todas as páginas',
'allpagesprev'   => 'Anterior',
'allpagesnext'   => 'Posterior',
'allpagessubmit' => 'Ir',
'allpagesprefix' => 'Exibir páginas com o prefixo:',

# Special:Listusers
'listusersfrom'      => 'Mostrar usuários a partir de:',
'listusers-submit'   => 'Exibir',
'listusers-noresult' => 'Não foram encontrados usuários para a forma pesquisada.',

# E-mail user
'mailnologin'     => 'Sem endereço ed envio',
'mailnologintext' => 'Você deve estar [[Special:Userlogin|autenticado]]
e ter um e-mail válido em suas [[Special:Preferences|preferências]]
para poder enviar e-mails para outros usuários.',
'emailuser'       => 'Contactar usuário',
'emailpage'       => 'Enviar e-mail ao usuário',
'emailpagetext'   => 'Se este usuário disponibilizou um endereço válido de e-mail em suas preferências, o formulário a seguir enviará uma mensagem única.
O endereço de e-mail que você disponibilizou em suas preferências aparecerá como remetente da mensagem, então, o usuário poderá responder a você diretamente.',
'noemailtitle'    => 'Sem endereço de e-mail',
'noemailtext'     => 'Este usuário não especificou um endereço de e-mail válido, ou optou por não receber mensagens de outros usuários.',
'emailfrom'       => 'De',
'emailto'         => 'Para',
'emailsubject'    => 'Assunto',
'emailmessage'    => 'Mensagem',
'emailsend'       => 'Enviar',
'emailsent'       => 'E-mail enviado',
'emailsenttext'   => 'Sua mensagem foi enviada.',

# Watchlist
'watchlist'            => 'Páginas vigiadas',
'mywatchlist'          => 'Páginas vigiadas',
'watchlistfor'         => "(para '''$1''')",
'nowatchlist'          => 'Você não está monitorando nenhum artigo.',
'watchnologin'         => 'Não está autenticado',
'watchnologintext'     => 'Você deve estar [[Special:Userlogin|autenticado]]
para modificar a lista de artigos do seu interesse.',
'addedwatch'           => 'Adicionada à lista',
'addedwatchtext'       => "A página \"[[:\$1]]\" foi adicionada à sua [[{{ns:special}}:Watchlist|lista de páginas vigiadas]].
Modificações futuras em tal página e em sua página de discussão serão listadas aqui, com a página aparecendo em '''negrito''' na [[{{ns:special}}:Recentchanges|lista de mudanças recentes]], para que
possa encontrá-la com maior facilidade.

Se desejar remover a página da sua lista de vigiados, clique em \"Deixar de vigiar\" na barra lateral ou de topo.",
'removedwatch'         => 'Removida da lista de páginas vigiadas',
'removedwatchtext'     => 'A página "<nowiki>$1</nowiki>" foi removida de sua lista de páginas vigiadas.',
'watch'                => 'Vigiar',
'watchthispage'        => 'Interessar-se por esta página',
'unwatch'              => 'Deixar de vigiar',
'unwatchthispage'      => 'Desinteressar-se',
'notanarticle'         => 'Não é um artigo',
'watchnochange'        => 'Nenhum dos itens monitorados foram editados no período exibido.',
'watchlist-details'    => '{{PLURAL:$1|$1 página vigiada|$1 páginas vigiadas}}, excluindo páginas de discussão.',
'watchmethod-recent'   => 'checando edições recentes para os artigos monitorados',
'watchmethod-list'     => 'checando páginas monitoradas de edições recentes',
'watchlistcontains'    => 'Sua lista de vigiadas contém $1 {{PLURAL:$1|página|páginas}}.',
'iteminvalidname'      => "Problema com item '$1', nome inválido...",
'wlnote'               => "A seguir {{PLURAL:$1|está a última alteração ocorrida|estão as últimas '''$1''' alterações ocorridas}} {{PLURAL:$2|na última hora|nas últimas '''$2''' horas}}.",
'wlshowlast'           => 'Ver últimas $1 horas $2 dias $3',
'watchlist-show-bots'  => 'Mostrar edições de robôs',
'watchlist-hide-bots'  => 'Ocultar edições de bots',
'watchlist-show-own'   => 'Mostrar minhas edições',
'watchlist-hide-own'   => 'Ocultar as minhas edições',
'watchlist-show-minor' => 'Mostrar edições menores',
'watchlist-hide-minor' => 'Ocultar edições menores',

# Displayed when you click the "watch" button and it's in the process of watching
'watching'   => 'Vigiando...',
'unwatching' => 'Deixando de vigiar...',

'changed'            => 'alterada',
'created'            => 'criada',
'enotif_anon_editor' => 'usuário anônimo $1',

# Delete/protect/revert
'deletepage'                  => 'Eliminar página',
'confirm'                     => 'Confirmar',
'excontent'                   => "conteúdo era: '$1'",
'exbeforeblank'               => "conteúdo antes de apagar era: '$1'",
'exblank'                     => 'página estava vazia',
'delete-confirm'              => 'Eliminar "$1"',
'delete-legend'               => 'Eliminar',
'historywarning'              => 'Atenção: A página que você quer apagar tem um histórico de edições:',
'confirmdeletetext'           => 'Você está  prestes a deletar permanentemente uma página ou imagem junto com todo seu histórico.
Por favor, confirme que você realmente pretende fazer isto, que você compreende as conseqüências, e que você está fazendo isto em acordo com a [[{{MediaWiki:Policy-url}}|Política da {{SITENAME}}]].',
'actioncomplete'              => 'Ação efetuada com sucesso',
'deletedtext'                 => '"<nowiki>$1</nowiki>" foi eliminada.
Veja $2 para um registro de eliminações recentes.',
'deletedarticle'              => 'eliminou "$1"',
'dellogpage'                  => 'Registro de eliminação',
'dellogpagetext'              => 'Segue uma lista das deleções mais recentes.
Todos os horários mostrados estão no horário do servidor (UTC).',
'deletionlog'                 => 'registro de deleções',
'reverted'                    => 'Revertido para versão mais nova',
'deletecomment'               => 'Motivo de eliminação',
'deleteotherreason'           => 'Justificativa adicional:',
'deletereasonotherlist'       => 'Outro motivo',
'deletereason-dropdown'       => '* Motivos de eliminação comuns
** Pedido do autor
** Violação de direitos autorais
** Vandalismo',
'rollback'                    => 'Voltar edições',
'rollbacklink'                => 'voltar',
'rollbackfailed'              => 'A reversão falhou',
'cantrollback'                => 'Não foi possível reverter a edição; o último contribuidor é o único autor deste artigo.',
'alreadyrolled'               => 'Não foi possível reverter as edições de  [[:$1]]
por [[User:$2|$2]] ([[User talk:$2|discussão]]); alguém o editou ou já o reverteu.

A última edição foi de  [[User:$3|$3]] ([[User talk:$3|Conversar com ele]]).',
'editcomment'                 => 'O comentário de edição era: "<i>$1</i>".', # only shown if there is an edit comment
'revertpage'                  => 'Revertidas as edições por [[Special:Contributions/$2|$2]] ([[User talk:$2|disc]]) para a última versão por [[User:$1|$1]]', # Additional available: $3: revid of the revision reverted to, $4: timestamp of the revision reverted to, $5: revid of the revision reverted from, $6: timestamp of the revision reverted from
'rollback-success'            => 'Foram revertidas as edições de $1, com o conteúdo passando a estar como na última edição de $2.',
'protectlogpage'              => 'Registro de proteções',
'protectedarticle'            => 'protegeu "[[$1]]"',
'modifiedarticleprotection'   => 'foi alterado o nível de proteção para "[[$1]]"',
'unprotectedarticle'          => 'desprotegeu "[[$1]]"',
'protectsub'                  => '(Protegendo "$1")',
'confirmprotect'              => 'Confirmar proteção',
'protectcomment'              => 'Motivo de proteção',
'protectexpiry'               => 'Expira em:',
'protect_expiry_invalid'      => 'O tempo de expiração fornecido é inválido.',
'protect_expiry_old'          => 'O tempo de expiração fornecido se situa no passado.',
'unprotectsub'                => '(Desprotegendo "$1")',
'protect-unchain'             => 'Desbloquear permissões de moção',
'protect-text'                => 'Você pode, nesta página, alterar o nível de proteção para <strong><nowiki>$1</nowiki></strong>.',
'protect-locked-access'       => 'Sua conta não possui permissões para alterar os níveis de proteção de uma página.
Esta é a configuração atual para a página <strong>$1</strong>:',
'protect-cascadeon'           => 'Esta página se encontra protegida, uma vez que se encontra incluída {{PLURAL:$1|na página listada a seguir, protegida|nas páginas listadas a seguir, protegidas}} com a "proteção progressiva" ativada. Você poderá alterar o nível de proteção desta página, mas isso não afetará a "proteção progressiva".',
'protect-default'             => '(padrão)',
'protect-fallback'            => 'É necessário o privilégio de "$1"',
'protect-level-autoconfirmed' => 'Bloquear usuários não-registados',
'protect-level-sysop'         => 'Apenas administradores',
'protect-summary-cascade'     => 'p. progressiva',
'protect-expiring'            => 'expira em $1 (UTC)',
'protect-cascade'             => '"Proteção progressiva" - proteja quaisquer páginas que estejam incluídas nesta.',
'protect-cantedit'            => 'Você não pode alterar o nível de proteção desta página, uma vez que você não se encontra habilitado a editá-la.',
'restriction-type'            => 'Permissão:',
'restriction-level'           => 'Nível de restrição:',

# Restrictions (nouns)
'restriction-edit'   => 'Editar',
'restriction-move'   => 'Mover',
'restriction-create' => 'Criar',

# Restriction levels
'restriction-level-sysop'         => 'totalmente protegida',
'restriction-level-autoconfirmed' => 'semi-protegida',
'restriction-level-all'           => 'qualquer nível',

# Undelete
'undelete'                 => 'Restaurar páginas deletadas',
'undeletepage'             => 'Ver e restaurar páginas deletadas',
'undeletepagetext'         => 'As páginas seguintes foram apagadas mas ainda permanecem no bando de dados e podem ser restauradas. O arquivo pode ser limpo periodicamente.',
'undeleterevisions'        => '$1 {{PLURAL:$1|edição disponível|edições disponíveis}}',
'undeletehistory'          => 'Se você restaurar uma página, todas as revisões serão restauradas para o histórico.
Se uma nova página foi criada com o mesmo nome desde a deleção, as revisões restauradas aparecerão primeiro no histórico e a página existente não será automaticamente recolocada.',
'undeletebtn'              => 'Restaurar',
'undeletecomment'          => 'Comentário:',
'undeletedarticle'         => ' "$1" restaurado',
'undeletedrevisions'       => '$1 {{PLURAL:$1|edição restaurada|edições restauradas}}',
'undeletedrevisions-files' => '$1 {{PLURAL:$2|edição restaurada|edições restauradas}} e $2 {{PLURAL:$2|arquivo restaurado|arquivos restaurados}}',
'undeletedfiles'           => '{{PLURAL:$1|arquivo restaurado|$1 arquivos restaurados}}',
'undelete-cleanup-error'   => 'Erro ao eliminar o arquivo não utilizado "$1".',

# Namespace form on various pages
'namespace'      => 'Espaço nominal:',
'invert'         => 'Inverter seleção',
'blanknamespace' => '(Principal)',

# Contributions
'contributions' => 'Contribuições de usuários',
'mycontris'     => 'Minhas contribuições',
'contribsub2'   => 'Para $1 ($2)',
'nocontribs'    => 'Não foram encontradas mudanças com este critério.',
'ucnote'        => 'Segue as últimas  <b>$1</b> mudanças nos últimos <b>$2</b> dias do usuário.',
'uclinks'       => 'Ver as últimas $1 mudanças; ver os últimos $2 dias.',
'uctop'         => '(edição atual)',
'month'         => 'Mês (inclusive anteriores):',
'year'          => 'Ano (inclusive anteriores):',

'sp-contributions-newbies-sub' => 'Para contas novas',
'sp-contributions-blocklog'    => 'Registro de bloqueios',
'sp-contributions-username'    => 'Endereço de IP ou usuário:',

# What links here
'whatlinkshere'       => 'Páginas afluentes',
'whatlinkshere-title' => 'Páginas que apontam para $1',
'whatlinkshere-page'  => 'Página:',
'linklistsub'         => '(Lista de links)',
'linkshere'           => "As seguintes páginas possuem links que apontam para '''[[:$1]]''':",
'nolinkshere'         => "Não existem links para '''[[:$1]]'''.",
'isredirect'          => 'página de redirecionamento',
'istemplate'          => 'inclusão',
'whatlinkshere-prev'  => '{{PLURAL:$1|anterior|$1 anteriores}}',
'whatlinkshere-next'  => '{{PLURAL:$1|próximo|próximos $1}}',
'whatlinkshere-links' => '← links',

# Block/unblock
'blockip'                  => 'Bloquear usuário',
'blockiptext'              => 'Utilize o formulário abaixo para bloquear o acesso à escrita de um endereço específico de IP ou nome de usuário.
Isto só deve ser feito para prevenir vandalismo, e de acordo com a [[{{MediaWiki:Policy-url}}|política]]. Preencha com um motivo específico a seguir (por exemplo, citando páginas que sofreram vandalismo).',
'ipaddress'                => 'Endereço de IP',
'ipadressorusername'       => 'Endereço de IP ou nome de usuário:',
'ipbreason'                => 'Motivo',
'ipbreasonotherlist'       => 'Outro motivo',
'ipbreason-dropdown'       => '*Razões comuns para um bloqueio
** Inserindo informações falsas
** Removendo o conteúdo de páginas
** Fazendo "spam" de sítios externos
** Inserindo conteúdo sem sentido/incompreensível nas páginas
** Comportamento intimidador/inoportuno
** Uso abusivo de contas múltiplas
** Nome de usuário inaceitável',
'ipbanononly'              => 'Bloquear apenas usuários anônimos',
'ipbsubmit'                => 'Bloquear este endereço',
'ipboptions'               => '2 horas:2 hours,1 dia:1 day,3 dias:3 days,1 semana:1 week,2 semanas:2 weeks,1 mês:1 month,3 meses:3 months,6 meses:6 months,1 ano:1 year,indefinido:infinite', # display1:time1,display2:time2,...
'ipbhidename'              => 'Ocultar usuário/IP do registro de bloqueios, lista de bloqueios e lista de usuários',
'badipaddress'             => 'O endereço de IP está mal-formado.',
'blockipsuccesssub'        => 'Bloqueio bem sucedido',
'blockipsuccesstext'       => 'O endereço de IP "$1" Foi bloqueado.
<br />Veja [[Special:Ipblocklist|Lista de IP\'s bloqueados]] para rever os bloqueios.',
'ipb-unblock'              => 'Desbloquear um usuário ou endereço de IP',
'unblockip'                => 'Desbloquear endereço de IP',
'unblockiptext'            => 'Utilize o formulário a seguir para restaurar o acesso a escrita para um endereço de IP previamente bloqueado.',
'ipusubmit'                => 'Desbloquear este endereço',
'ipblocklist'              => "Lista de IP's e usuários bloqueados",
'ipblocklist-legend'       => 'Procurar por um usuário bloqueado',
'ipblocklist-username'     => 'Usuário ou endereço de IP:',
'blocklistline'            => '$1, $2 bloqueado $3 ($4)',
'infiniteblock'            => 'indefinido',
'ipblocklist-no-results'   => 'O endereço de IP ou nome de usuário procurado não se encontra bloqueado.',
'blocklink'                => 'bloquear',
'unblocklink'              => 'desbloquear',
'contribslink'             => 'contribs',
'autoblocker'              => 'Você foi automaticamente bloqueado, pois partilha um endereço de IP com "[[User:$1|$1]]". O motivo apresentado foi: "$2".',
'blocklogpage'             => 'Registro de bloqueios',
'blocklogentry'            => '"[[$1]]" foi bloqueado pelo período de $2 $3',
'blocklogtext'             => 'Este é um registro de ações de bloqueio e desbloqueio. Endereços IP sujeitos a bloqueio automático não são listados. Consulte a [[{{ns:special}}:Ipblocklist|lista de IPs bloqueados]] para obter a lista de bloqueios e banimentos atualmente válidos.',
'block-log-flags-anononly' => 'apenas usuários anônimos',

# Developer tools
'lockdb'              => 'Trancar Banco de Dados',
'unlockdb'            => 'Destrancar Banco de Dados',
'lockdbtext'          => 'Trancar o banco de dados suspenderá a habilidade de todos os usuários de editarem páginas, mudarem suas preferências, listas de monitoramento e outras coisas que requerem mudanças no banco de dados.
Por favor confirme que você realmente pretende fazer isto, e que você vai desbloquear o banco de dados quando sua manutenção estiver completa.',
'unlockdbtext'        => 'Desbloquear o banco de dados vai restaurar a habilidade de todos os usuários de editar artigos, mudar suas preferências, editar suas listas de monitoramento e outras coisas que requerem mudanças no banco de dados. Por favor, confirme que você realmente pretende fazer isto.',
'lockconfirm'         => 'SIM, eu realmente pretendo trancar o banco de dados.',
'unlockconfirm'       => 'SIM, eu realmente pretendo destrancar o banco de dados.',
'lockbtn'             => 'Trancar banco',
'unlockbtn'           => 'Destrancar banco',
'locknoconfirm'       => 'Você não checou a caixa de confirmação.',
'lockdbsuccesssub'    => 'Tranca bem sucedida',
'unlockdbsuccesssub'  => 'Destranca bem sucedida',
'lockdbsuccesstext'   => 'O banco de dados da {{SITENAME}} foi trancado.
<br />Lembre-se de remover a tranca após a manutenção.',
'unlockdbsuccesstext' => 'O bando de dados da {{SITENAME}} foi destrancado.',

# Move page
'movepage'         => 'Mover página',
'movepagetext'     => "Utilizando o seguinte formulário você poderá renomear uma página, movendo todo o histórico para o novo título. O título anterior será transformado num redirecionamento para o novo.

Links para as páginas antigas não serão mudados; certifique-se de verificar por redirecionamentos quebrados ou duplos. Você é o responsável por certificar-se de que os links continuam apontando para onde eles deveriam apontar.

Note que a página '''não''' será movida se já existir uma página com o novo título, a não ser que ele esteja vazio ou seja um redirecionamento e que não tenha um histórico de edições. Isto significa que você pode renomear uma página de volta para o nome que possuía anteriormente se cometer algum engano e que não é possível sobrescrever uma página.

<b>CUIDADO!</b>
Isto pode ser uma mudança drástica e inesperada para uma página popular; por favor, tenha certeza de que compreende as conseqüências da mudança antes de prosseguir.",
'movepagetalktext' => "A página associada, se existir, será automaticamente movida, '''a não ser que:'''
*Uma página de discussão não-vazia já exista sob o novo nome, ou
*Você não marque a caixa abaixo.

Nestes casos, você terá que mover ou mesclar a página manualmente, se desejar.",
'movearticle'      => 'Mover página',
'movenologin'      => 'Não Autenticado',
'movenologintext'  => 'Você deve ser um usuário registrado e [[Special:Userlogin|autenticado]]
para mover uma página.',
'newtitle'         => 'Pata novo título',
'move-watch'       => 'Vigiar esta página',
'movepagebtn'      => 'Mover página',
'pagemovedsub'     => 'Página movida com sucesso',
'movepage-moved'   => '<big>\'\'\'"$1" foi movido para "$2"\'\'\'</big>', # The two titles are passed in plain text as $3 and $4 to allow additional goodies in the message.
'articleexists'    => 'Uma página com este título já existe, ou o título que você escolheu é inválido.
Por favor, escolha outro título.',
'talkexists'       => "'''A página em si foi movida com sucesso, porém, a página de discussão não pode ser movida já que já existe uma com este nome. Por favor, mescle-as manualmente.'''",
'movedto'          => 'movido para',
'movetalk'         => 'Mover também a página de discussão, se aplicável.',
'talkpagemoved'    => 'A página de discussão correspondente foi movida com sucesso.',
'talkpagenotmoved' => 'A página de discussão correspondente <strong>não</strong> foi movida.',
'1movedto2'        => '[[$1]] foi movido para [[$2]]',
'1movedto2_redir'  => '[[$1]] foi movido para [[$2]] sob redirecionamento',
'movelogpage'      => 'Registro de movimentações',
'movereason'       => 'Motivo:',
'revertmove'       => 'reverter',

# Export
'export' => 'Exportar páginas',

# Namespace 8 related
'allmessages' => 'Todas as mensagens de sistema',

# Thumbnails
'thumbnail-more'  => 'Ampliar',
'thumbnail_error' => 'Erro ao criar miniatura: $1',

# Import log
'importlogpage' => 'Registro de importações',

# Tooltip help for the actions
'tooltip-pt-userpage'             => 'Minha página de usuário',
'tooltip-pt-mytalk'               => 'Minha página de discussão',
'tooltip-pt-preferences'          => 'Minhas preferências',
'tooltip-pt-watchlist'            => 'Lista de páginas vigiadas.',
'tooltip-pt-mycontris'            => 'Lista das minhas contribuições',
'tooltip-pt-login'                => 'Você é encorajado a autenticar-se, apesar disso não ser obrigatório.',
'tooltip-pt-logout'               => 'Sair',
'tooltip-ca-talk'                 => 'Discussão sobre o conteúdo da página',
'tooltip-ca-edit'                 => 'Você pode editar esta página. Por favor, utilize o botão Mostrar Previsão antes de salvar.',
'tooltip-ca-addsection'           => 'Adicionar um comentário a essa discussão.',
'tooltip-ca-viewsource'           => 'Esta página está protegida; você pode, no entanto, exibir seu código.',
'tooltip-ca-protect'              => 'Proteger esta página',
'tooltip-ca-delete'               => 'Apagar esta página',
'tooltip-ca-move'                 => 'Mover esta página',
'tooltip-ca-watch'                => 'Adicionar esta página às páginas vigiadas',
'tooltip-ca-unwatch'              => 'Remover esta página de suas páginas vigiadas',
'tooltip-search'                  => 'Pesquisar nesta wiki',
'tooltip-n-mainpage'              => 'Visitar a página principal',
'tooltip-n-portal'                => 'Sobre o projeto',
'tooltip-n-recentchanges'         => 'A lista de mudanças recentes nesta wiki.',
'tooltip-n-randompage'            => 'Acessa uma página aleatória',
'tooltip-n-help'                  => 'Um local para procurar por ajuda.',
'tooltip-n-sitesupport'           => 'Ajude-nos',
'tooltip-t-whatlinkshere'         => 'Lista de todas as páginas que se ligam à esta',
'tooltip-t-contributions'         => 'Ver as contribuições deste usuário',
'tooltip-t-emailuser'             => 'Enviar um e-mail a este usuário',
'tooltip-t-upload'                => 'Carregar imagens ou arquivos multimídia',
'tooltip-t-specialpages'          => 'Lista de páginas especiais',
'tooltip-ca-nstab-user'           => 'Ver a página deste usuário',
'tooltip-ca-nstab-project'        => 'Ver a página de projeto',
'tooltip-ca-nstab-image'          => 'Ver a página de imagem',
'tooltip-ca-nstab-template'       => 'Ver a predefinição',
'tooltip-ca-nstab-help'           => 'Ver a página de ajuda',
'tooltip-ca-nstab-category'       => 'Ver a página de categoria',
'tooltip-minoredit'               => 'Marcar como uma edição menor',
'tooltip-save'                    => 'Salvar as alterações',
'tooltip-preview'                 => 'Prever as suas alterações. Por gentileza, use antes de salvar!',
'tooltip-diff'                    => 'Mostrar as alterações feitas por você a este texto.',
'tooltip-compareselectedversions' => 'Ver as diferenças entre as versões selecionadas desta página.',
'tooltip-watch'                   => 'Adicionar esta página à sua lista de páginas vigiadas',

# Spam protection
'subcategorycount'       => '{{PLURAL:$1|Existe uma subcategoria|Existem $1 subcategorias}} nesta categoria.',
'categoryarticlecount'   => '{{PLURAL:$1|Existe uma página|Existem $1 páginas}} nesta categoria.',
'category-media-count'   => '{{PLURAL:$1|Há um arquivo|Há $1 arquivos}} nesta categoria.',
'listingcontinuesabbrev' => 'cont.',

# Math options
'mw_math_png'    => 'Sempre renderizar PNG',
'mw_math_simple' => 'HTML se for bem simples e PNG',
'mw_math_html'   => 'HTML se possível ou então PNG',
'mw_math_source' => 'Deixar como TeX (para navegadores em modo texto)',
'mw_math_modern' => 'Recomendado para navegadores modernos',
'mw_math_mathml' => 'MathML',

# Browsing diffs
'previousdiff' => '← Ver a alteração anterior',
'nextdiff'     => 'Ver a alteração posterior →',

# Media information
'file-info-size'       => '($1 × $2 pixels, tamanho: $3, tipo MIME: $4)',
'file-nohires'         => '<small>Sem resolução maior disponível.</small>',
'svg-long-desc'        => '(arquivo SVG de $1 × $2 pixels; tamanho: $3)',
'show-big-image'       => 'Resolução completa',
'show-big-image-thumb' => '<small>Tamanho desta previsão: $1 × $2 pixels</small>',

# Special:Newimages
'newimages' => 'Galeria de novos arquivos',

# Metadata
'metadata'          => 'Metadados',
'metadata-help'     => 'Este arquivo possui informações adicionais que provavelmente foram adicionadas a partir da câmara digital ou scanner utilizada para criar ou digitalizar a imagem. Caso o arquivo tenha sido modificado a partir do seu estado original, alguns detalhes poderão não refletir completamente as mudanças efetuadas.',
'metadata-expand'   => 'Mostrar detalhes restantes',
'metadata-collapse' => 'Esconder detalhes adicionais',
'metadata-fields'   => 'Os campos de metadados EXIF listados nesta mensagem poderão estar presente na exibição da página de imagem quando a tabela de metadados estiver no modo "expandida". Outros poderão estar escondidos por padrão.
* make
* model
* datetimeoriginal
* exposuretime
* fnumber
* focallength', # Do not translate list items

# External editor support
'edit-externally'      => 'Editar este arquivo utilizando um programa externo',
'edit-externally-help' => 'Consulte as [http://meta.wikimedia.org/wiki/Help:External_editors instruções de instalação] para maiores informações.',

# 'all' in various places, this might be different for inflected languages
'recentchangesall' => 'todas',
'imagelistall'     => 'todas',
'watchlistall2'    => 'todas',
'namespacesall'    => 'todas',
'monthsall'        => 'todos',

# HTML dump
'redirectingto' => 'Redirecionando para [[$1]]...',

# action=purge
'confirm_purge_button' => 'OK',

# Multipage image navigation
'imgmultipageprev' => '← página anterior',
'imgmultipagenext' => 'próxima página →',
'imgmultigo'       => 'Ir!',
'imgmultigotopre'  => 'Mostrar página',

# Auto-summaries
'autosumm-blank'   => 'Foi removido o conteúdo completo desta página',
'autosumm-replace' => "Página substituída por '$1'",
'autoredircomment' => 'Redirecionando para [[$1]]',
'autosumm-new'     => 'Nova página: $1',

# Watchlist editor
'watchlistedit-numitems'       => 'A sua lista de vigiados possui {{PLURAL:$1|um título|$1 títulos}}, além das respectivas páginas de discussão.',
'watchlistedit-noitems'        => 'A sua lista de vigiados não possui títulos.',
'watchlistedit-normal-title'   => 'Editar lista de vigiados',
'watchlistedit-normal-legend'  => 'Remover títulos da lista de vigiados',
'watchlistedit-normal-explain' => 'Os títulos de sua lista de vigiados são exibidos a seguir. Para remover um título, clique no box ao lado do mesmo e no botão Remover Títulos. Você também pode [[{{ns:special}}:Watchlist/raw|editar a lista crua]] ou [[{{ns:special}}:Watchlist/clear|remover todos os títulos]].',
'watchlistedit-normal-submit'  => 'Remover Títulos',
'watchlistedit-normal-done'    => '{{PLURAL:$1|um título foi removido|$1 títulos foram removidos}} de sua lista de vigiados:',
'watchlistedit-raw-title'      => 'Edição crua dos vigiados',
'watchlistedit-raw-legend'     => 'Edição crua dos vigiados',
'watchlistedit-raw-explain'    => 'Os títulos de sua lista de vigiados são exibidos a seguir e podem ser adicionados ou removidos ao se editar a lista, mantendo-se um por linha. Ao terminar, clique no botão correspondente para atualizar.

Você também pode [[{{ns:special}}:Watchlist/edit|editar a lista da forma convencional]] ou [[{{ns:special}}:Watchlist/clear|remover todos os títulos]].',
'watchlistedit-raw-titles'     => 'Títulos:',
'watchlistedit-raw-submit'     => 'Atualizar a lista de vigiados',
'watchlistedit-raw-done'       => 'Sua lista de vigiados foi atualizada.',
'watchlistedit-raw-added'      => '{{PLURAL:$1|Foi adicionado um título|Foram adicionados $1 títulos}}:',
'watchlistedit-raw-removed'    => '{{PLURAL:$1|Foi removido um título|Foram removidos $1 títulos}}:',

# Watchlist editing tools
'watchlisttools-view' => 'Ver alterações relevantes',
'watchlisttools-edit' => 'Ver e editar a lista de vigiadas',
'watchlisttools-raw'  => 'Edição crua das vigiadas',

# Special:Version
'version-extensions'            => 'Extensões instaladas',
'version-specialpages'          => 'Páginas especiais',
'version-variables'             => 'Variáveis',
'version-other'                 => 'Diversos',
'version-mediahandlers'         => 'Reprodutores de mídia',
'version-hooks'                 => 'Hooks',
'version-extension-functions'   => 'Funções da extensão',
'version-parser-extensiontags'  => 'Etiquetas das extensões de tipo "parser"',
'version-parser-function-hooks' => 'Funções "hooks" dos "parsers"',
'version-hook-name'             => 'Nome do hook',
'version-version'               => 'Versão',

# Special:Filepath
'filepath'         => 'Diretório do arquivo',
'filepath-page'    => 'Arquivo:',
'filepath-submit'  => 'Diretório',
'filepath-summary' => 'Através dsta página especial é possível descobrir o endereço completo de um determinado arquivo. As imagens serão exibidas em sua resolução máxima, outros tipos de arquivos serão iniciados automaticamente em seus programas correspondentes.

Entre com o nome do arquivo sem utilizar o prefixo "{{ns:image}}:".',

);
