Of the various features that people ask for in MaraDNS, the one that most 
consistently comes up is the request for SQL support.  While it is far too 
late in the development cycle of MaraDNS to add SQL support to the 1.0.x 
release of MaraDNS, this is a feature that I hope to eventually add to 
MaraDNS.

The question, of course, is what is the best way to go about adding SQL 
support.

First of all, SQL and DNS, while both databases, are based on completely
different paradigms.  SQL is based on the idea the one big huge expensive
buffed machine has all of the data in question.  DNS is based on the idea
of zillions of small to big machines, each of which has a subset of the
data--it is a much more distributed database (now, with the huge size of
the namespace one level below .com., DNS has strayed pretty far from this
idea, but still...) [1]

In addition, DNS is based on the idea that the end user knows exactly the 
data in one field of the data they want (the domain name of the machine 
they wish to contact), which SQL is based on the idea that the user may 
not, for example, know someone's last name, but they know their first 
name, the city they live in, and the first three digits of their phone 
number (SELECT * FROM ADDRESSBOOK WHERE FIRSTNAME = "John" AND CITY = 
"Anytown" AND PHONE HAS 555, if I recall correctly).

Of course, SQL is a very flexible protocol, and I believe it is possible 
to take advantage of the advantages of DNS' ability to scale across 
multiple machines with SQL's ability to have one machine handle a large 
number of queries.

The best way to support SQL with MaraDNS is the easiest to implement, 
since, this being a free software project, I do not always have as much 
time as I would like to work on the code.  [2]

The idea I currently have is to have the DNS->SQL query translator be part 
of the recursive engine.  I think this is the best place to place the data 
because SQL queries are, compared to the overhead of DNS queries, rather 
slow.  So, we have a structure like this:

end user request -> DNS server cache -> cloud of SQL servers

Where the DNS server is acting like a caching recursive server, but is 
sending out SQL requests instead of DNS requests.  This, naturally, 
requires that a DNS server which queries a SQL server can not act as a 
recursive nameserver.  

To make this modification to MaraDNS, it is simply a matter of having two 
versions of the query_nameserver() routine in server/recursive.c: One that 
sends out DNS requests (perhaps with the name query_nameserver_DNS), and 
another which sends out SQL requests.

Of course, this requires that SQL servers send out responses in a form 
that most closely resembles a DNS reply.  I am thinking that a SQL table 
would be required to look like this:

Name		Type of data
LABEL1		text
LABEL2		text
LABEL3		text
LABEL4		text
LABEL5		text
LABEL6 		text
LABEL7		text
LABEL8		text
DATATYPE	text (This is whether this is a A, NS, MX, etc. query)
TTL 		number
DATA1		text
DATA2		text
DATA3		text
DATA4		text

Where an A reply for www.example.com would look like this:

LABEL1		"com"
LABEL2		"example"
LABEL3		"www"
LABEL4		""
LABEL5		""
LABEL6		""
LABEL7 		""
LABEL8		""
DATATYPE	"A"
TTL		86400
DATA1		"192.168.10.11"
DATA2		""
DATA3		""
DATA4		""

And a request in the form Awww.example.com. would become this SQL query 
like this:

SELECT ALL FROM DNSDATA WHERE LABEL1="com" AND LABEL2="example" AND 
LABEL3="www" and LABEL4="" AND DATATYPE="A"

We can, because of the way MaraDNS stores data, also make the SQL database 
scalable across multiple machines, as follows:

* If the data is not found, change the SQL query that asks for a referral.  
  We do this bottom-up, as follows:

SELECT ALL FROM DNSDATA WHERE LABEL1="com" AND LABEL2="example" AND 
LABEL3="www" AND LABEL4="" AND DATATYPE="REFER"

If this doesn't find anything:

SELECT ALL FROM DNSDATA WHERE LABEL1="com" AND LABEL2="example" AND
LABEL3="" AND DATATYPE="REFER"

Followed by:

SELECT ALL FROM DNSDATA WHERE LABEL1="com" AND LABEL2="" AND 
DATATYPE="REFER"

Until the SQL server tells us which SQL server to bug to get the data we 
are looking for.

Footnotes:

[1] Of course, there are ways to modify DNS so that data in that form 
    distributes more evenly, but would require some fundamental changes 
    to how DNS handles referrals.  The idea is, when www.example.com is
    not in our database, turn the nodes upside-down so the query looks
    like com.example.www, then start truncating the string at the end 
    until there is a referral server in our cache which matches.  So,
    we look for a com.example.ww* referral in our cache, then a 
    com.example.w* referral in our cache, then a com.example.* referral
    in our cache, then a com.exampl* referral in our cache, until we 
    find out that the name servers which handle all com.ex* queries have
    the ips 192.168.116.12 and 10.9.8.78.

[2] Once I had a dream that a 1.0 release of MaraDNS would be released in
    May or June of 2001.  

