from SCons.Util import Split

intl_header_files = Split('''
    eval-plural.h
    gettextP.h
    gmo.h
    hash-string.h
    libgnuintl.h
    libintl.h
    loadinfo.h
    localcharset.h
    os2compat.h
    plural-exp.h
    printf-args.h
    printf-parse.h
    relocatable.h
    vasnprintf.h
    vasnwprintf.h
    wprintf-parse.h
    xsize.h
''')


intl_files = Split('''
    bindtextdom.c
    dcgettext.c
    dcigettext.c
    dcngettext.c
    dgettext.c
    dngettext.c
    explodename.c
    finddomain.c
    gettext.c
    intl-compat.c
    l10nflist.c
    loadmsgcat.c
    localcharset.c
    localealias.c
    localename.c
    log.c
    ngettext.c
    osdep.c
    plural-exp.c
    plural.c
    printf.c
    relocatable.c
    textdomain.c
''')


boost_libs_signals_src_files = Split('''
    connection.cpp
    named_slot_map.cpp
    signal_base.cpp
    slot.cpp
    trackable.cpp
''')


boost_libs_regex_src_files = Split('''
    c_regex_traits.cpp
    c_regex_traits_common.cpp
    cpp_regex_traits.cpp
    cregex.cpp
    fileiter.cpp
    instances.cpp
    posix_api.cpp
    regex.cpp
    regex_debug.cpp
    regex_synch.cpp
    w32_regex_traits.cpp
    wide_posix_api.cpp
    winstances.cpp
''')


boost_libs_filesystem_src_files = Split('''
    convenience.cpp
    exception.cpp
    operations_posix_windows.cpp
    path_posix_windows.cpp
''')


boost_libs_iostreams_src_files = Split('''
    file_descriptor.cpp
    mapped_file.cpp
    zlib.cpp
''')


src_support_header_files = Split('''
    FileMonitor.h
    RandomAccessList.h
    convert.h
    copied_ptr.h
    cow_ptr.h
    debugstream.h
    environment.h
    gzstream.h
    filefilterlist.h
    filename.h
    filetools.h
    forkedcall.h
    forkedcallqueue.h
    forkedcontr.h
    fs_extras.h
    limited_stack.h
    lstrings.h
    lyxalgo.h
    lyxlib.h
    lyxmanip.h
    lyxtime.h
    os.h
    os_win32.h
    package.h
    path.h
    socktools.h
    std_istream.h
    std_ostream.h
    systemcall.h
    textutils.h
    translator.h
    types.h
    userinfo.h
''')


src_support_files = Split('''
    FileMonitor.C
    abort.C
    chdir.C
    convert.C
    copy.C
    environment.C
    filefilterlist.C
    filename.C
    filetools.C
    forkedcall.C
    forkedcallqueue.C
    forkedcontr.C
    fs_extras.C
    getcwd.C
    gzstream.C
    kill.C
    lstrings.C
    lyxsum.C
    lyxtime.C
    mkdir.C
    os.C
    package.C
    path.C
    rename.C
    socktools.C
    systemcall.C
    tempname.C
    unlink.C
    userinfo.C
''')


src_mathed_header_files = Split('''
    command_inset.h
    formulamacro.h
    math_amsarrayinset.h
    math_arrayinset.h
    math_atom.h
    math_autocorrect.h
    math_biginset.h
    math_binominset.h
    math_boldsymbolinset.h
    math_boxedinset.h
    math_boxinset.h
    math_braceinset.h
    math_casesinset.h
    math_charinset.h
    math_colorinset.h
    math_commentinset.h
    math_data.h
    math_decorationinset.h
    math_deliminset.h
    math_dfracinset.h
    math_diffinset.h
    math_diminset.h
    math_dotsinset.h
    math_envinset.h
    math_exfuncinset.h
    math_exintinset.h
    math_extern.h
    math_factory.h
    math_fboxinset.h
    math_fontinset.h
    math_fontoldinset.h
    math_fracbase.h
    math_fracinset.h
    math_frameboxinset.h
    math_gridinfo.h
    math_gridinset.h
    math_hullinset.h
    math_inset.h
    math_kerninset.h
    math_lefteqninset.h
    math_liminset.h
    math_macro.h
    math_macroarg.h
    math_macrotable.h
    math_macrotemplate.h
    math_makeboxinset.h
    math_mathmlstream.h
    math_matrixinset.h
    math_mboxinset.h
    math_nestinset.h
    math_numberinset.h
    math_oversetinset.h
    math_parinset.h
    math_parser.h
    math_phantominset.h
    math_replace.h
    math_rootinset.h
    math_scriptinset.h
    math_sizeinset.h
    math_spaceinset.h
    math_splitinset.h
    math_sqrtinset.h
    math_stackrelinset.h
    math_streamstr.h
    math_stringinset.h
    math_substackinset.h
    math_support.h
    math_symbolinset.h
    math_tabularinset.h
    math_tfracinset.h
    math_undersetinset.h
    math_unknowninset.h
    math_xarrowinset.h
    math_xyarrowinset.h
    math_xymatrixinset.h
    ref_inset.h
    textpainter.h
''')


src_mathed_files = Split('''
    command_inset.C
    math_amsarrayinset.C
    math_arrayinset.C
    math_atom.C
    math_autocorrect.C
    math_biginset.C
    math_binominset.C
    math_boldsymbolinset.C
    math_boxedinset.C
    math_boxinset.C
    math_braceinset.C
    math_casesinset.C
    math_charinset.C
    math_colorinset.C
    math_commentinset.C
    math_data.C
    math_decorationinset.C
    math_deliminset.C
    math_dfracinset.C
    math_diffinset.C
    math_diminset.C
    math_dotsinset.C
    math_envinset.C
    math_exfuncinset.C
    math_exintinset.C
    math_extern.C
    math_factory.C
    math_fboxinset.C
    math_fontinset.C
    math_fontoldinset.C
    math_fracbase.C
    math_fracinset.C
    math_frameboxinset.C
    math_gridinset.C
    math_hullinset.C
    math_inset.C
    math_kerninset.C
    math_lefteqninset.C
    math_liminset.C
    math_macro.C
    math_macroarg.C
    math_macrotable.C
    math_macrotemplate.C
    math_makeboxinset.C
    math_mathmlstream.C
    math_matrixinset.C
    math_nestinset.C
    math_numberinset.C
    math_oversetinset.C
    math_parinset.C
    math_parser.C
    math_phantominset.C
    math_rootinset.C
    math_scriptinset.C
    math_sizeinset.C
    math_spaceinset.C
    math_splitinset.C
    math_sqrtinset.C
    math_stackrelinset.C
    math_streamstr.C
    math_stringinset.C
    math_substackinset.C
    math_support.C
    math_symbolinset.C
    math_tabularinset.C
    math_tfracinset.C
    math_undersetinset.C
    math_unknowninset.C
    math_xarrowinset.C
    math_xymatrixinset.C
    ref_inset.C
    textpainter.C
''')


src_insets_header_files = Split('''
    ExternalSupport.h
    ExternalTemplate.h
    ExternalTransforms.h
    inset.h
    insetbase.h
    insetbibitem.h
    insetbibtex.h
    insetbox.h
    insetbranch.h
    insetcaption.h
    insetcharstyle.h
    insetcite.h
    insetcollapsable.h
    insetcommand.h
    insetcommandparams.h
    insetenv.h
    insetert.h
    insetexternal.h
    insetfloat.h
    insetfloatlist.h
    insetfoot.h
    insetfootlike.h
    insetgraphics.h
    insetgraphicsParams.h
    insethfill.h
    insetinclude.h
    insetindex.h
    insetlabel.h
    insetlatexaccent.h
    insetline.h
    insetmarginal.h
    insetnewline.h
    insetnote.h
    insetoptarg.h
    insetpagebreak.h
    insetquotes.h
    insetref.h
    insetspace.h
    insetspecialchar.h
    insettabular.h
    insettext.h
    insettheorem.h
    insettoc.h
    inseturl.h
    insetvspace.h
    insetwrap.h
    mailinset.h
    render_base.h
    render_button.h
    render_graphic.h
    render_preview.h
''')


src_insets_files = Split('''
    ExternalSupport.C
    ExternalTemplate.C
    ExternalTransforms.C
    inset.C
    insetbase.C
    insetbibitem.C
    insetbibtex.C
    insetbox.C
    insetbranch.C
    insetcaption.C
    insetcharstyle.C
    insetcite.C
    insetcollapsable.C
    insetcommand.C
    insetcommandparams.C
    insetenv.C
    insetert.C
    insetexternal.C
    insetfloat.C
    insetfloatlist.C
    insetfoot.C
    insetfootlike.C
    insetgraphics.C
    insetgraphicsParams.C
    insethfill.C
    insetinclude.C
    insetindex.C
    insetlabel.C
    insetlatexaccent.C
    insetline.C
    insetmarginal.C
    insetnewline.C
    insetnote.C
    insetoptarg.C
    insetpagebreak.C
    insetquotes.C
    insetref.C
    insetspace.C
    insetspecialchar.C
    insettabular.C
    insettext.C
    insettoc.C
    inseturl.C
    insetvspace.C
    insetwrap.C
    mailinset.C
    render_button.C
    render_graphic.C
    render_preview.C
''')


src_frontends_header_files = Split('''
    Alert.h
    Alert_pimpl.h
    Clipboard.h
    Dialogs.h
    FileDialog.h
    Gui.h
    LyXKeySym.h
    LyXKeySymFactory.h
    LyXScreenFactory.h
    LyXView.h
    Menubar.h
    Painter.h
    Selection.h
    Timeout.h
    Toolbars.h
    WorkArea.h
    WorkAreaFactory.h
    font_metrics.h
    guiapi.h
    key_state.h
    lyx_gui.h
    mouse_state.h
    nullpainter.h
    screen.h
''')


src_frontends_files = Split('''
    Alert.C
    Dialogs.C
    LyXView.C
    Painter.C
    Timeout.C
    Toolbars.C
    guiapi.C
    nullpainter.C
    screen.C
''')


src_graphics_header_files = Split('''
    GraphicsCache.h
    GraphicsCacheItem.h
    GraphicsConverter.h
    GraphicsImage.h
    GraphicsLoader.h
    GraphicsParams.h
    GraphicsTypes.h
    LoaderQueue.h
    PreviewImage.h
    PreviewLoader.h
    Previews.h
''')


src_graphics_files = Split('''
    GraphicsCache.C
    GraphicsCacheItem.C
    GraphicsConverter.C
    GraphicsImage.C
    GraphicsLoader.C
    GraphicsParams.C
    GraphicsTypes.C
    LoaderQueue.C
    PreviewImage.C
    PreviewLoader.C
    Previews.C
''')


src_frontends_controllers_header_files = Split('''
    BCView.h
    ButtonController.h
    ButtonPolicies.h
    ControlAboutlyx.h
    ControlBibtex.h
    ControlBox.h
    ControlBranch.h
    ControlChanges.h
    ControlCharacter.h
    ControlCitation.h
    ControlCommand.h
    ControlCommandBuffer.h
    ControlDocument.h
    ControlERT.h
    ControlErrorList.h
    ControlExternal.h
    ControlFloat.h
    ControlGraphics.h
    ControlInclude.h
    ControlLog.h
    ControlMath.h
    ControlNote.h
    ControlParagraph.h
    ControlPrefs.h
    ControlPrint.h
    ControlRef.h
    ControlSearch.h
    ControlSendto.h
    ControlShowFile.h
    ControlSpellchecker.h
    ControlTabular.h
    ControlTabularCreate.h
    ControlTexinfo.h
    ControlThesaurus.h
    ControlToc.h
    ControlVSpace.h
    ControlWrap.h
    Dialog.h
    Kernel.h
    biblio.h
    character.h
    frnt_lang.h
    helper_funcs.h
    tex_helpers.h
''')


src_frontends_controllers_files = Split('''
    BCView.C
    ButtonController.C
    ButtonPolicies.C
    ControlAboutlyx.C
    ControlBibtex.C
    ControlBox.C
    ControlBranch.C
    ControlChanges.C
    ControlCharacter.C
    ControlCitation.C
    ControlCommand.C
    ControlCommandBuffer.C
    ControlDocument.C
    ControlERT.C
    ControlErrorList.C
    ControlExternal.C
    ControlFloat.C
    ControlGraphics.C
    ControlInclude.C
    ControlLog.C
    ControlMath.C
    ControlNote.C
    ControlParagraph.C
    ControlPrefs.C
    ControlPrint.C
    ControlRef.C
    ControlSearch.C
    ControlSendto.C
    ControlShowFile.C
    ControlSpellchecker.C
    ControlTabular.C
    ControlTabularCreate.C
    ControlTexinfo.C
    ControlThesaurus.C
    ControlToc.C
    ControlVSpace.C
    ControlWrap.C
    Dialog.C
    Kernel.C
    biblio.C
    character.C
    frnt_lang.C
    helper_funcs.C
    tex_helpers.C
''')


src_frontends_qt2_ui_files = Split('''
    BiblioModuleBase.ui
    BranchesModuleBase.ui
    BulletsModuleBase.ui
    LaTeXModuleBase.ui
    LanguageModuleBase.ui
    MarginsModuleBase.ui
    MathsModuleBase.ui
    NumberingModuleBase.ui
    PageLayoutModuleBase.ui
    PreambleModuleBase.ui
    QAboutDialogBase.ui
    QAskForTextDialog.ui
    QBibitemDialogBase.ui
    QBibtexAddDialogBase.ui
    QBibtexDialogBase.ui
    QBoxDialogBase.ui
    QBranchDialogBase.ui
    QChangesDialogBase.ui
    QCharacterDialogBase.ui
    QCitationDialogBase.ui
    QCitationFindDialogBase.ui
    QDelimiterDialogBase.ui
    QDocumentDialogBase.ui
    QERTDialogBase.ui
    QErrorListDialogBase.ui
    QExternalDialogBase.ui
    QFloatDialogBase.ui
    QGraphicsDialogBase.ui
    QIncludeDialogBase.ui
    QIndexDialogBase.ui
    QLogDialogBase.ui
    QMathDialogBase.ui
    QMathMatrixDialogBase.ui
    QNoteDialogBase.ui
    QParagraphDialogBase.ui
    QPrefAsciiModule.ui
    QPrefColorsModule.ui
    QPrefConvertersModule.ui
    QPrefCopiersModule.ui
    QPrefCygwinPathModule.ui
    QPrefDateModule.ui
    QPrefDisplayModule.ui
    QPrefFileformatsModule.ui
    QPrefIdentityModule.ui
    QPrefKeyboardModule.ui
    QPrefLanguageModule.ui
    QPrefLatexModule.ui
    QPrefPathsModule.ui
    QPrefPrinterModule.ui
    QPrefScreenFontsModule.ui
    QPrefSpellcheckerModule.ui
    QPrefUIModule.ui
    QPrefsDialogBase.ui
    QPrintDialogBase.ui
    QRefDialogBase.ui
    QSearchDialogBase.ui
    QSendtoDialogBase.ui
    QShowFileDialogBase.ui
    QSpellcheckerDialogBase.ui
    QTabularCreateDialogBase.ui
    QTabularDialogBase.ui
    QTexinfoDialogBase.ui
    QThesaurusDialogBase.ui
    QTocDialogBase.ui
    QURLDialogBase.ui
    QVSpaceDialogBase.ui
    QWrapDialogBase.ui
    TextLayoutModuleBase.ui
''')


src_frontends_qt2_moc_files = Split('''
    BulletsModule.C
    emptytable.C
    FileDialog_private.C
    floatplacement.C
    iconpalette.C
    lengthcombo.C
    panelstack.C
    QAboutDialog.C
    QBibitemDialog.C
    QBibtexDialog.C
    QBoxDialog.C
    QBranchDialog.C
    QBrowseBox.C
    QChangesDialog.C
    QCharacterDialog.C
    QCitationDialog.C
    QCommandBuffer.C
    QCommandEdit.C
    QContentPane.C
    QDelimiterDialog.C
    QDocumentDialog.C
    QErrorListDialog.C
    QERTDialog.C
    QExternalDialog.C
    QFloatDialog.C
    QGraphicsDialog.C
    QIncludeDialog.C
    QIndexDialog.C
    QLogDialog.C
    QLPopupMenu.C
    QLPrintDialog.C
    QMathDialog.C
    QMathMatrixDialog.C
    QNoteDialog.C
    QParagraphDialog.C
    QPrefsDialog.C
    QRefDialog.C
    QSearchDialog.C
    QSendtoDialog.C
    qsetborder.C
    QShowFileDialog.C
    QSpellcheckerDialog.C
    QDialogView.C
    QTabularCreateDialog.C
    QTabularDialog.C
    QTexinfoDialog.C
    QThesaurusDialog.C
    QTocDialog.C
    qttableview.C
    QtView.C
    QURLDialog.C
    QVSpaceDialog.C
    QWrapDialog.C
    QLToolbar.C
    socket_callback.C
    validators.C
''')


src_frontends_qt2_header_files = Split('''
    BulletsModule.h
    FileDialog_private.h
    GuiImplementation.h
    GuiSelection.h
    GuiWorkArea.h
    QAbout.h
    QAboutDialog.h
    QBibitem.h
    QBibitemDialog.h
    QBibtex.h
    QBibtexDialog.h
    QBox.h
    QBoxDialog.h
    QBranch.h
    QBranchDialog.h
    QBrowseBox.h
    QChanges.h
    QChangesDialog.h
    QCharacter.h
    QCharacterDialog.h
    QCitation.h
    QCitationDialog.h
    QCommandBuffer.h
    QCommandEdit.h
    QContentPane.h
    QDelimiterDialog.h
    QDialogView.h
    QDocument.h
    QDocumentDialog.h
    QERT.h
    QERTDialog.h
    QErrorList.h
    QErrorListDialog.h
    QExternal.h
    QExternalDialog.h
    QFloat.h
    QFloatDialog.h
    QGraphics.h
    QGraphicsDialog.h
    QInclude.h
    QIncludeDialog.h
    QIndex.h
    QIndexDialog.h
    QLImage.h
    QLMenubar.h
    QLPainter.h
    QLPopupMenu.h
    QLPrintDialog.h
    QLToolbar.h
    QLog.h
    QLogDialog.h
    QLyXKeySym.h
    QMath.h
    QMathDialog.h
    QMathMatrixDialog.h
    QNote.h
    QNoteDialog.h
    QParagraph.h
    QParagraphDialog.h
    QPrefs.h
    QPrefsDialog.h
    QPrint.h
    QRef.h
    QRefDialog.h
    QSearch.h
    QSearchDialog.h
    QSendto.h
    QSendtoDialog.h
    QShowFile.h
    QShowFileDialog.h
    QSpellchecker.h
    QSpellcheckerDialog.h
    QTabular.h
    QTabularCreate.h
    QTabularCreateDialog.h
    QTabularDialog.h
    QTexinfo.h
    QTexinfoDialog.h
    QThesaurus.h
    QThesaurusDialog.h
    QToc.h
    QTocDialog.h
    QURL.h
    QURLDialog.h
    QVSpace.h
    QVSpaceDialog.h
    QWorkArea.h
    QWrap.h
    QWrapDialog.h
    Qt2BC.h
    QtLyXView.h
    QtView.h
    checkedwidgets.h
    emptytable.h
    floatplacement.h
    iconpalette.h
    lcolorcache.h
    lengthcombo.h
    panelstack.h
    qcoloritem.h
    qfont_loader.h
    qfontexample.h
    qlkey.h
    qscreen.h
    qsetborder.h
    qtTimeout.h
    qt_helpers.h
    qttableview.h
    socket_callback.h
    validators.h
''')


src_frontends_qt2_files = Split('''
    Alert_pimpl.C
    BulletsModule.C
    Dialogs.C
    FileDialog.C
    FileDialog_private.C
    LyXKeySymFactory.C
    LyXScreenFactory.C
    QAbout.C
    QAboutDialog.C
    QBibitem.C
    QBibitemDialog.C
    QBibtex.C
    QBibtexDialog.C
    QBox.C
    QBoxDialog.C
    QBranch.C
    QBranchDialog.C
    QBrowseBox.C
    QChanges.C
    QChangesDialog.C
    QCharacter.C
    QCharacterDialog.C
    QCitation.C
    QCitationDialog.C
    QCommandBuffer.C
    QCommandEdit.C
    QContentPane.C
    QDelimiterDialog.C
    QDialogView.C
    QDocument.C
    QDocumentDialog.C
    QERT.C
    QERTDialog.C
    QErrorList.C
    QErrorListDialog.C
    QExternal.C
    QExternalDialog.C
    QFloat.C
    QFloatDialog.C
    QGraphics.C
    QGraphicsDialog.C
    QInclude.C
    QIncludeDialog.C
    QIndex.C
    QIndexDialog.C
    QLImage.C
    QLMenubar.C
    QLPainter.C
    QLPopupMenu.C
    QLPrintDialog.C
    QLToolbar.C
    QLog.C
    QLogDialog.C
    QLyXKeySym.C
    QMath.C
    QMathDialog.C
    QMathMatrixDialog.C
    QNote.C
    QNoteDialog.C
    QParagraph.C
    QParagraphDialog.C
    QPrefs.C
    QPrefsDialog.C
    QPrint.C
    QRef.C
    QRefDialog.C
    QSearch.C
    QSearchDialog.C
    QSendto.C
    QSendtoDialog.C
    QShowFile.C
    QShowFileDialog.C
    QSpellchecker.C
    QSpellcheckerDialog.C
    QTabular.C
    QTabularCreate.C
    QTabularCreateDialog.C
    QTabularDialog.C
    QTexinfo.C
    QTexinfoDialog.C
    QThesaurus.C
    QThesaurusDialog.C
    QToc.C
    QTocDialog.C
    QURL.C
    QURLDialog.C
    QVSpace.C
    QVSpaceDialog.C
    QWorkArea.C
    QWrap.C
    QWrapDialog.C
    Qt2BC.C
    QtView.C
    checkedwidgets.C
    emptytable.C
    floatplacement.C
    iconpalette.C
    lcolorcache.C
    lengthcombo.C
    lyx_gui.C
    panelstack.C
    qcoloritem.C
    qfont_loader.C
    qfont_metrics.C
    qfontexample.C
    qscreen.C
    qsetborder.C
    qtTimeout.C
    qt_helpers.C
    qttableview.C
    socket_callback.C
    validators.C
    WorkAreaFactory.C
''')


src_client_header_files = Split('''
    debug.h
    gettext.h
    messages.h
''')


src_client_files = Split('''
    boost.C
    client.C
    debug.C
    gettext.C
    messages.C
''')


src_tex2lyx_header_files = Split('''
    Spacing.h
    context.h
    gettext.h
    lyxfont.h
    tex2lyx.h
    texparser.h
''')


src_tex2lyx_files = Split('''
    FloatList.C
    Floating.C
    boost.C
    context.C
    counters.C
    gettext.C
    lengthcommon.C
    lyxfont.C
    lyxlayout.C
    lyxlex.C
    lyxlex_pimpl.C
    lyxtextclass.C
    math.C
    preamble.C
    table.C
    tex2lyx.C
    texparser.C
    text.C
''')


src_header_files = Split('''
    Bidi.h
    BranchList.h
    BufferView.h
    BufferView_pimpl.h
    Bullet.h
    Chktex.h
    CutAndPaste.h
    DepTable.h
    FloatList.h
    Floating.h
    FontIterator.h
    FuncStatus.h
    InsetList.h
    LColor.h
    LaTeX.h
    LaTeXFeatures.h
    LyXAction.h
    MenuBackend.h
    ParagraphList.h
    ParagraphList_fwd.h
    ParagraphParameters.h
    PrinterParams.h
    RowList_fwd.h
    Sectioning.h
    Spacing.h
    SpellBase.h
    Thesaurus.h
    ToolbarBackend.h
    Variables.h
    WordLangTuple.h
    aspell_local.h
    author.h
    box.h
    buffer.h
    buffer_funcs.h
    bufferlist.h
    bufferparams.h
    bufferview_funcs.h
    changes.h
    chset.h
    converter.h
    coordcache.h
    counters.h
    cursor.h
    cursor_slice.h
    debug.h
    dimension.h
    dispatchresult.h
    dociterator.h
    encoding.h
    errorlist.h
    exporter.h
    factory.h
    format.h
    funcrequest.h
    gettext.h
    graph.h
    importer.h
    insetiterator.h
    intl.h
    ispell.h
    kbmap.h
    kbsequence.h
    language.h
    layout.h
    lengthcommon.h
    lfuns.h
    lyx_cb.h
    lyx_main.h
    lyx_sty.h
    lyxfind.h
    lyxfont.h
    lyxfunc.h
    lyxgluelength.h
    lyxlayout.h
    lyxlayout_ptr_fwd.h
    lyxlength.h
    lyxlex.h
    lyxlex_pimpl.h
    lyxrc.h
    lyxrow.h
    lyxrow_funcs.h
    lyxserver.h
    lyxsocket.h
    lyxtext.h
    lyxtextclass.h
    lyxtextclasslist.h
    lyxvc.h
    messages.h
    metricsinfo.h
    mover.h
    output.h
    output_docbook.h
    output_latex.h
    output_linuxdoc.h
    output_plaintext.h
    outputparams.h
    paper.h
    paragraph.h
    paragraph_funcs.h
    paragraph_pimpl.h
    pariterator.h
    pspell.h
    rowpainter.h
    lastfiles.h
    sgml.h
    tabular.h
    tex-accent.h
    tex-strings.h
    texrow.h
    toc.h
    trans.h
    trans_decl.h
    trans_mgr.h
    undo.h
    vc-backend.h
    version.h
    vspace.h
''')


src_pre_files = Split('''
    Bidi.C
    BranchList.C
    BufferView.C
    BufferView_pimpl.C
    Bullet.C
    Chktex.C
    CutAndPaste.C
    DepTable.C
    FloatList.C
    Floating.C
    FontIterator.C
    FuncStatus.C
    InsetList.C
    LColor.C
    LaTeX.C
    LaTeXFeatures.C
    LyXAction.C
    MenuBackend.C
    ParagraphParameters.C
    Spacing.C
    ToolbarBackend.C
    author.C
    boost.C
    buffer.C
    buffer_funcs.C
    bufferlist.C
    bufferparams.C
    bufferview_funcs.C
    changes.C
    chset.C
    converter.C
    coordcache.C
    counters.C
    cursor.C
    cursor_slice.C
    debug.C
    dociterator.C
    encoding.C
    errorlist.C
    exporter.C
    factory.C
    format.C
    funcrequest.C
    gettext.C
    graph.C
    importer.C
    insetiterator.C
    intl.C
    kbmap.C
    kbsequence.C
    language.C
    lengthcommon.C
    lyx_cb.C
    lyx_main.C
    lyx_sty.C
    lyxfind.C
    lyxfont.C
    lyxfunc.C
    lyxgluelength.C
    lyxlayout.C
    lyxlength.C
    lyxlex.C
    lyxlex_pimpl.C
    lyxrc.C
    lyxrow.C
    lyxrow_funcs.C
    lyxserver.C
    lyxsocket.C
    lyxtextclass.C
    lyxtextclasslist.C
    lyxvc.C
    messages.C
    metricsinfo.C
    mover.C
    output.C
    output_docbook.C
    output_latex.C
    output_linuxdoc.C
    output_plaintext.C
    outputparams.C
    paragraph.C
    paragraph_funcs.C
    paragraph_pimpl.C
    pariterator.C
    rowpainter.C
    lastfiles.C
    sgml.C
    tex-accent.C
    tex-strings.C
    texrow.C
    text.C
    text2.C
    text3.C
    toc.C
    trans.C
    trans_mgr.C
    undo.C
    vc-backend.C
    version.C
    vspace.C
''')


src_post_files = Split('''
    tabular.C
    dimension.C
    PrinterParams.C
    box.C
    Thesaurus.C
    SpellBase.C
''')


lib_files = Split('''
    lyxrc.example
    CREDITS
    chkconfig.ltx
    external_templates
    encodings
    languages
    symbols
    syntax.default
    configure.py
''')


# do not install, ignore
lib_image_noinst_files = Split('''
    images/README
    images/font-smallcaps.xpm
    images/math/ams_arrows.xbm
    images/math/ams_misc.xbm
    images/math/ams_nrel.xbm
    images/math/ams_ops.xbm
    images/math/ams_rel.xbm
    images/math/arrows.xbm
    images/math/bop.xbm
    images/math/brel.xbm
    images/math/deco.xbm
    images/math/deco.xpm
    images/math/delim0.xpm
    images/math/delim1.xpm
    images/math/delim.xbm
    images/math/dots.xbm
    images/math/font.xbm
    images/math/frac-square.xpm
    images/math/greek.xbm
    images/math/misc.xbm
    images/math/varsz.xbm
''')


lib_bind_files = Split('''
    broadway.bind
    cua.bind
    cyrkeys.bind
    de_menus.bind
    emacs.bind
    fi_menus.bind
    greekkeys.bind
    hollywood.bind
    latinkeys.bind
    mac.bind
    math.bind
    menus.bind
    pt_menus.bind
    sciword.bind
    sv_menus.bind
    xemacs.bind
    aqua.bind
''')

lib_clipart_files = ['platypus.eps']


lib_examples_files = Split('''
    Foils.lyx
    ItemizeBullets.lyx
    Literate.lyx
    Minipage.lyx
    TableExamples.lyx
    aa_sample.lyx
    aas_sample.lyx
    amsart-test.lyx
    amsbook-test.lyx
    ca_splash.lyx
    chess-article.lyx
    chessgame.lyx
    cs_splash.lyx
    currency.lyx
    cv.lyx
    da_splash.lyx
    de_ItemizeBullets.lyx
    de_Lebenslauf.lyx
    de_Minipage.lyx
    de_TableExamples.lyx
    de_Waehrungen.lyx
    de_beispiel_gelyxt.lyx
    de_beispiel_roh.lyx
    de_decimal.lyx
    de_splash.lyx
    de_mathed.lyx
    de_multicol.lyx
    decimal.lyx
    docbook_article.lyx
    es_ejemplo_con_lyx.lyx
    es_ejemplo_sin_lyx.lyx
    es_splash.lyx
    eu_adibide_gordina.lyx
    eu_adibide_lyx-atua.lyx
    eu_splash.lyx
    example_lyxified.lyx
    example_raw.lyx
    fr_AlignementDecimal.lyx
    fr_CV.lyx
    fr_ExemplesTableaux.lyx
    fr_Foils.lyx
    fr_ListesPuces.lyx
    fr_Minipage.lyx
    fr_exemple_brut.lyx
    fr_exemple_lyxifie.lyx
    fr_mathed.lyx
    fr_multicol.lyx
    fr_splash.lyx
    he_example_raw.lyx
    he_he_example_lyxified.lyx
    he_he_example_raw.lyx
    hu_splash.lyx
    iecc05.fen
    iecc07.fen
    iecc12.fen
    it_ItemizeBullets.lyx
    it_splash.lyx
    landslide.lyx
    linuxdoc_manpage.lyx
    listerrors.lyx
    mathed.lyx
    multicol.lyx
    nl_multicol.lyx
    nl_opsommingstekens.lyx
    nl_splash.lyx
    nl_voorbeeld_ruw.lyx
    nl_voorbeeld_verlyxt.lyx
    noweb2lyx.lyx
    pl_splash.lyx
    pt_splash.lyx
    ru_splash.lyx
    script_form.lyx
    sl_primer_lyxan.lyx
    sl_primer_surov.lyx
    sl_splash.lyx
    splash.lyx
    g-brief2.lyx
    ro_splash.lyx
''')


lib_images_files = Split('''
    amssymb.xpm
    banner.ppm
    bookmark-goto.xpm
    bookmark-save.xpm
    break-line.xpm
    buffer-close.xpm
    buffer-export_dvi.xpm
    buffer-export_latex.xpm
    buffer-export_ps.xpm
    buffer-export_text.xpm
    buffer-new.xpm
    buffer-reload.xpm
    buffer-update_dvi.xpm
    buffer-update_ps.xpm
    buffer-view_dvi.xpm
    buffer-view_ps.xpm
    buffer-write-as.xpm
    buffer-write.xpm
    build-program.xpm
    copy.xpm
    cut.xpm
    depth-decrement.xpm
    depth-increment.xpm
    dialog-preferences.xpm
    dialog-show-new-inset_citation.xpm
    dialog-show-new-inset_graphics.xpm
    dialog-show-new-inset_include.xpm
    dialog-show-new-inset_ref.xpm
    dialog-show_character.xpm
    dialog-show_findreplace.xpm
    dialog-show_mathpanel.xpm
    dialog-show_print.xpm
    dialog-show_spellchecker.xpm
    down.xpm
    ert-insert.xpm
    file-open.xpm
    float-insert_figure.xpm
    float-insert_table.xpm
    font-bold.xpm
    font-emph.xpm
    font-free-apply.xpm
    font-noun.xpm
    font-sans.xpm
    footnote-insert.xpm
    index-insert.xpm
    label-insert.xpm
    layout-document.xpm
    layout-paragraph.xpm
    layout_Description.xpm
    layout_Enumerate.xpm 
    layout_Itemize.xpm
    layout_List.xpm
    layout_LyX-Code.xpm
    layout_Scrap.xpm
    layout_Section.xpm
    lyx-quit.xpm
    lyx.xpm
    marginalnote-insert.xpm
    math-display.xpm
    math-matrix.xpm
    math-mode.xpm
    math-subscript.xpm
    math-superscript.xpm
    note-insert.xpm
    paste.xpm
    psnfss1.xpm
    psnfss2.xpm
    psnfss3.xpm
    psnfss4.xpm
    redo.xpm
    standard.xpm
    tabular-feature_align-center.xpm
    tabular-feature_align-left.xpm
    tabular-feature_align-right.xpm
    tabular-feature_append-column.xpm
    tabular-feature_append-row.xpm
    tabular-feature_delete-column.xpm
    tabular-feature_delete-row.xpm
    tabular-feature_multicolumn.xpm
    tabular-feature_set-all-lines.xpm
    tabular-feature_set-longtabular.xpm
    tabular-feature_set-rotate-cell.xpm
    tabular-feature_set-rotate-tabular.xpm
    tabular-feature_toggle-line-bottom.xpm
    tabular-feature_toggle-line-left.xpm
    tabular-feature_toggle-line-right.xpm
    tabular-feature_toggle-line-top.xpm
    tabular-feature_unset-all-lines.xpm
    tabular-feature_valign-bottom.xpm
    tabular-feature_valign-middle.xpm
    tabular-feature_valign-top.xpm
    tabular-insert.xpm
    thesaurus-entry.xpm
    toc-view.xpm
    undo.xpm
    unknown.xpm
    up.xpm
    url-insert.xpm
''')


lib_images_math_files = Split('''
    style.xbm
    font.xpm
    delim.xpm
    equation.xpm
    matrix.xpm
    space.xpm
    sqrt-square.xpm
    style.xpm
    sub.xpm
    super.xpm
    Bbbk.xpm
    Finv.xpm
    Game.xpm
    Im.xpm
    Lleftarrow.xpm
    Lsh.xpm
    Re.xpm
    Rsh.xpm
    Vert.xpm
    Vvdash.xpm
    acute.xpm
    aleph.xpm
    alpha.xpm
    amalg.xpm
    angle.xpm
    approx.xpm
    approxeq.xpm
    asymp.xpm
    backepsilon.xpm
    backprime.xpm
    backsim.xpm
    backsimeq.xpm
    backslash.xpm
    bar.xpm
    bars.xpm
    barwedge.xpm
    because.xpm
    beta.xpm
    beth.xpm
    between.xpm
    bigcap.xpm
    bigcirc.xpm
    bigcup.xpm
    bigodot.xpm
    bigoplus.xpm
    bigotimes.xpm
    bigsqcup.xpm
    bigstar.xpm
    bigtriangledown.xpm
    bigtriangleup.xpm
    biguplus.xpm
    bigvee.xpm
    bigwedge.xpm
    blacklozenge.xpm
    blacksquare.xpm
    blacktriangle.xpm
    blacktriangledown.xpm
    blacktriangleleft.xpm
    blacktriangleright.xpm
    bot.xpm
    bowtie.xpm
    boxdot.xpm
    boxminus.xpm
    boxplus.xpm
    boxtimes.xpm
    breve.xpm
    bullet.xpm
    bumpeq.xpm
    bumpeq2.xpm
    cap.xpm
    cap2.xpm
    cases.xpm
    cdot.xpm
    cdots.xpm
    centerdot.xpm
    check.xpm
    chi.xpm
    circ.xpm
    circeq.xpm
    circlearrowleft.xpm
    circlearrowright.xpm
    circledS.xpm
    circledast.xpm
    circledcirc.xpm
    circleddash.xpm
    clubsuit.xpm
    complement.xpm
    cong.xpm
    coprod.xpm
    cup.xpm
    cup2.xpm
    curlyeqprec.xpm
    curlyeqsucc.xpm
    curlyvee.xpm
    curlywedge.xpm
    curvearrowleft.xpm
    curvearrowright.xpm
    dagger.xpm
    daleth.xpm
    dashleftarrow.xpm
    dashrightarrow.xpm
    dashv.xpm
    ddagger.xpm
    ddot.xpm
    ddots.xpm
    delta.xpm
    delta2.xpm
    diagdown.xpm
    diagup.xpm
    diamond.xpm
    diamondsuit.xpm
    digamma.xpm
    div.xpm
    divideontimes.xpm
    dot.xpm
    doteq.xpm
    doteqdot.xpm
    dotplus.xpm
    doublebarwedge.xpm
    downarrow.xpm
    downarrow2.xpm
    downdownarrows.xpm
    downharpoonleft.xpm
    downharpoonright.xpm
    ell.xpm
    empty.xpm
    emptyset.xpm
    epsilon.xpm
    eqcirc.xpm
    eqslantgtr.xpm
    eqslantless.xpm
    equiv.xpm
    eta.xpm
    eth.xpm
    exists.xpm
    fallingdotseq.xpm
    flat.xpm
    forall.xpm
    frac.xpm
    frown.xpm
    gamma.xpm
    gamma2.xpm
    geq.xpm
    geqq.xpm
    geqslant.xpm
    gg.xpm
    ggg.xpm
    gimel.xpm
    gnapprox.xpm
    gneq.xpm
    gneqq.xpm
    gnsim.xpm
    grave.xpm
    gtrapprox.xpm
    gtrdot.xpm
    gtreqless.xpm
    gtreqqless.xpm
    gtrless.xpm
    gtrsim.xpm
    gvertneqq.xpm
    hat.xpm
    hbar.xpm
    heartsuit.xpm
    hookleftarrow.xpm
    hookrightarrow.xpm
    hphantom.xpm
    hslash.xpm
    imath.xpm
    in.xpm
    infty.xpm
    int.xpm
    intercal.xpm
    intop.xpm
    iota.xpm
    jmath.xpm
    kappa.xpm
    lambda.xpm
    lambda2.xpm
    langle.xpm
    lbrace.xpm
    lbrace_rbrace.xpm
    lbracket.xpm
    lbracket_rbracket.xpm
    lceil.xpm
    lceil_rceil.xpm
    ldots.xpm
    leftarrow.xpm
    leftarrow2.xpm
    leftarrowtail.xpm
    leftharpoondown.xpm
    leftharpoonup.xpm
    leftleftarrows.xpm
    leftrightarrow.xpm
    leftrightarrow2.xpm
    leftrightarrows.xpm
    leftrightharpoons.xpm
    leftrightsquigarrow.xpm
    leftthreetimes.xpm
    leq.xpm
    leqq.xpm
    leqslant.xpm
    lessapprox.xpm
    lessdot.xpm
    lesseqgtr.xpm
    lesseqqgtr.xpm
    lessgtr.xpm
    lesssim.xpm
    lfloor.xpm
    lfloor_rfloor.xpm
    ll.xpm
    llcorner.xpm
    lll.xpm
    lnapprox.xpm
    lneq.xpm
    lneqq.xpm
    lnsim.xpm
    longleftarrow.xpm
    longleftarrow2.xpm
    longleftrightarrow.xpm
    longleftrightarrow2.xpm
    longmapsto.xpm
    longrightarrow.xpm
    longrightarrow2.xpm
    looparrowleft.xpm
    looparrowright.xpm
    lozenge.xpm
    lparen.xpm
    lparen_rparen.xpm
    lrcorner.xpm
    ltimes.xpm
    lvertneqq.xpm
    mapsto.xpm
    mathbb_C.xpm
    mathbb_H.xpm
    mathbb_N.xpm
    mathbb_Q.xpm
    mathbb_R.xpm
    mathbb_Z.xpm
    mathcal_F.xpm
    mathcal_H.xpm
    mathcal_L.xpm
    mathcal_O.xpm
    mathcircumflex.xpm
    mathrm_T.xpm
    measuredangle.xpm
    mho.xpm
    mid.xpm
    models.xpm
    mp.xpm
    mu.xpm
    multimap.xpm
    nabla.xpm
    natural.xpm
    ncong.xpm
    nearrow.xpm
    neg.xpm
    neq.xpm
    nexists.xpm
    ngeq.xpm
    ngeqq.xpm
    ngeqslant.xpm
    ngtr.xpm
    ni.xpm
    nleftarrow.xpm
    nleftarrow2.xpm
    nleftrightarrow.xpm
    nleftrightarrow2.xpm
    nleq.xpm
    nleqq.xpm
    nleqslant.xpm
    nless.xpm
    nmid.xpm
    notin.xpm
    nparallel.xpm
    nprec.xpm
    npreceq.xpm
    nrightarrow.xpm
    nrightarrow2.xpm
    nshortmid.xpm
    nshortparallel.xpm
    nsim.xpm
    nsubseteq.xpm
    nsucc.xpm
    nsucceq.xpm
    nsupseteq.xpm
    nsupseteqq.xpm
    ntriangleleft.xpm
    ntrianglelefteq.xpm
    ntriangleright.xpm
    ntrianglerighteq.xpm
    nu.xpm
    nvdash.xpm
    nvdash2.xpm
    nvdash3.xpm
    nwarrow.xpm
    odot.xpm
    oint.xpm
    ointop.xpm
    omega.xpm
    omega2.xpm
    ominus.xpm
    oplus.xpm
    oslash.xpm
    otimes.xpm
    overbrace.xpm
    overleftarrow.xpm
    overleftrightarrow.xpm
    overline.xpm
    overrightarrow.xpm
    overset.xpm
    parallel.xpm
    partial.xpm
    perp.xpm
    phantom.xpm
    phi.xpm
    phi2.xpm
    pi.xpm
    pi2.xpm
    pitchfork.xpm
    pm.xpm
    prec.xpm
    precapprox.xpm
    preccurlyeq.xpm
    preceq.xpm
    precnapprox.xpm
    precnsim.xpm
    precsim.xpm
    prime.xpm
    prod.xpm
    propto.xpm
    psi.xpm
    psi2.xpm
    rangle.xpm
    rbrace.xpm
    rbracket.xpm
    rceil.xpm
    rfloor.xpm
    rho.xpm
    rightarrow.xpm
    rightarrow2.xpm
    rightarrowtail.xpm
    rightharpoondown.xpm
    rightharpoonup.xpm
    rightleftarrows.xpm
    rightleftharpoons.xpm
    rightrightarrows.xpm
    rightsquigarrow.xpm
    rightthreetimes.xpm
    risingdotseq.xpm
    root.xpm
    rparen.xpm
    rtimes.xpm
    searrow.xpm
    setminus.xpm
    sharp.xpm
    shortmid.xpm
    shortparallel.xpm
    sigma.xpm
    sigma2.xpm
    sim.xpm
    simeq.xpm
    slash.xpm
    smallfrown.xpm
    smallsetminus.xpm
    smallsmile.xpm
    smile.xpm
    spadesuit.xpm
    sphericalangle.xpm
    sqcap.xpm
    sqcup.xpm
    sqrt.xpm
    sqsubset.xpm
    sqsubseteq.xpm
    sqsupset.xpm
    sqsupseteq.xpm
    square.xpm
    star.xpm
    subset.xpm
    subset2.xpm
    subseteq.xpm
    subseteqq.xpm
    subsetneq.xpm
    subsetneqq.xpm
    succ.xpm
    succapprox.xpm
    succcurlyeq.xpm
    succeq.xpm
    succnapprox.xpm
    succnsim.xpm
    succsim.xpm
    sum.xpm
    supset.xpm
    supset2.xpm
    supseteq.xpm
    supseteqq.xpm
    supsetneq.xpm
    supsetneqq.xpm
    surd.xpm
    swarrow.xpm
    tau.xpm
    textrm_Oe.xpm
    textrm_AA.xpm
    therefore.xpm
    theta.xpm
    theta2.xpm
    thickapprox.xpm
    thicksim.xpm
    tilde.xpm
    times.xpm
    top.xpm
    triangle.xpm
    triangledown.xpm
    triangleleft.xpm
    trianglelefteq.xpm
    triangleq.xpm
    triangleright.xpm
    trianglerighteq.xpm
    twoheadleftarrow.xpm
    twoheadrightarrow.xpm
    ulcorner.xpm
    underbrace.xpm
    underleftarrow.xpm
    underleftrightarrow.xpm
    underline.xpm
    underrightarrow.xpm
    underscore.xpm
    underset.xpm
    uparrow.xpm
    uparrow2.xpm
    updownarrow.xpm
    updownarrow2.xpm
    upharpoonleft.xpm
    upharpoonright.xpm
    uplus.xpm
    upsilon.xpm
    upsilon2.xpm
    upuparrows.xpm
    urcorner.xpm
    varepsilon.xpm
    varkappa.xpm
    varnothing.xpm
    varphi.xpm
    varpi.xpm
    varpropto.xpm
    varsigma.xpm
    varsubsetneq.xpm
    varsubsetneqq.xpm
    varsupsetneq.xpm
    varsupsetneqq.xpm
    vartheta.xpm
    vartriangle.xpm
    vartriangleleft.xpm
    vartriangleright.xpm
    vdash.xpm
    vdash2.xpm
    vdash3.xpm
    vdots.xpm
    vec.xpm
    vee.xpm
    veebar.xpm
    vphantom.xpm
    wedge.xpm
    widehat.xpm
    widetilde.xpm
    wp.xpm
    wr.xpm
    xi.xpm
    xi2.xpm
    zeta.xpm
''')


lib_kbd_files = Split('''
    american-2.kmap
    american.kmap
    arabic.kmap
    bg-bds-1251.kmap
    brazil.kmap
    brazil2.kmap
    cp1251.cdef
    czech-prg.kmap
    czech.kmap
    european.kmap
    francais.kmap
    french.kmap
    german-2.kmap
    german-3.kmap
    german.kmap
    greek.kmap
    hebrew.kmap
    ibm866.cdef
    iso8859-1.cdef
    iso8859-15.cdef
    iso8859-2.cdef
    iso8859-3.cdef
    iso8859-4.cdef
    iso8859-7.cdef
    iso8859-8.cdef
    iso8859-9.cdef
    koi8-r.cdef
    koi8-r.kmap
    koi8-t.cdef
    koi8-u.cdef
    koi8-u.kmap
    latvian.kmap
    magyar-2.kmap
    magyar-3.kmap
    magyar.kmap
    null.kmap
    polish.kmap
    polski.kmap
    portuges.kmap
    romanian.kmap
    serbian.kmap
    serbocroatian.kmap
    sf.kmap
    sg.kmap
    slovak.kmap
    slovene.kmap
    thai-kedmanee.kmap
    tis620-0.cdef
    transilvanian.kmap
    turkish-f.kmap
    turkish.kmap
    espanol.kmap
''')


lib_layouts_files = Split('''
    IEEEtran.layout
    aa.layout
    aapaper.inc
    aapaper.layout
    aastex.layout
    aguplus.inc
    amsart-plain.layout
    amsart-seq.layout
    amsart.layout
    amsbook.layout
    amsdefs.inc
    amsmaths-plain.inc
    amsmaths-seq.inc
    amsmaths.inc
    apa.layout
    article.layout
    book.layout
    broadway.layout
    chess.layout
    cl2emult.layout
    cv.layout
    db_lyxmacros.inc
    db_stdclass.inc
    db_stdcharstyles.inc
    db_stdcounters.inc
    db_stdlayouts.inc
    db_stdlists.inc
    db_stdsections.inc
    db_stdstarsections.inc
    db_stdstruct.inc
    db_stdtitle.inc
    dinbrief.layout
    docbook-book.layout
    docbook-chapter.layout
    docbook-section.layout
    docbook.layout
    dtk.layout
    egs.layout
    elsart.layout
    entcs.layout
    extarticle.layout
    extbook.layout
    extletter.layout
    extreport.layout
    foils.layout
    g-brief-de.layout
    g-brief-en.layout
    heb-article.layout
    heb-letter.layout
    hollywood.layout
    ijmpc.layout
    ijmpd.layout
    jgrga.layout
    kluwer.layout
    latex8.layout
    letter.layout
    linuxdoc.layout
    literate-article.layout
    literate-book.layout
    literate-report.layout
    literate-scrap.inc
    llncs.layout
    ltugboat.layout
    lyxmacros.inc
    manpage.layout
    mwart.layout
    mwbk.layout
    mwrep.layout
    paper.layout
    report.layout
    revtex.layout
    revtex4.layout
    scrartcl.layout
    scrbook.layout
    scrclass.inc
    scrlettr.layout
    scrlttr2.layout
    scrreprt.layout
    seminar.layout
    siamltex.layout
    slides.layout
    spie.layout
    stdclass.inc
    stdcounters.inc
    stdfloats.inc
    stdlayouts.inc
    stdletter.inc
    stdlists.inc
    stdsections.inc
    stdstarsections.inc
    stdstruct.inc
    stdtitle.inc
    svjog.layout
    svjour.inc
    svprobth.layout
    agums.layout
    memoir.layout
    numarticle.inc
    numreport.inc
    numrevtex.inc
    agu-dtd.layout
    agu_stdclass.inc
    agu_stdcounters.inc
    agu_stdlists.inc
    agu_stdsections.inc
    agu_stdtitle.inc
    g-brief2.layout
    svglobal.layout
''')


lib_scripts_files = Split('''
    TeXFiles.py
    clean_dvi.py
    convertDefault.py
    fen2ascii.py
    fig2pdftex.py
    fig2pstex.py
    fig_copy.py
    layout2layout.py
    legacy_lyxpreview2ppm.py
    listerrors
    lyxpreview2bitmap.py
    lyxpreview_tools.py
    tex_copy.py
''')


lib_templates_files = Split('''
    IEEEtran.lyx
    README.new_templates
    aa.lyx
    aastex.lyx
    dinbrief.lyx
    docbook_article.lyx
    elsart.lyx
    g-brief-de.lyx
    g-brief-en.lyx
    hollywood.lyx
    kluwer.lyx
    koma-letter2.lyx
    latex8.lyx
    letter.lyx
    linuxdoc_article.lyx
    revtex.lyx
    revtex4.lyx
    slides.lyx
    ijmpc.lyx
    ijmpd.lyx
    agu_article.lyx
''')


lib_tex_files = Split('''
    broadway.cls
    cv.cls
    hollywood.cls
    lyxchess.sty
    lyxskak.sty
    revtex.cls
''')


lib_ui_files = Split('''
    classic.ui
    default.ui
    stdmenus.ui
    stdtoolbars.ui
''')


lib_doc_files = Split('''
    cs_Tutorial.lyx
    Customization.lyx
    da_Intro.lyx
    de_Customization.lyx
    de_Extended.lyx
    de_FAQ.lyx
    de_Intro.lyx
    de_Tutorial.lyx
    de_UserGuide.lyx
    DocStyle.lyx
    es_Intro.lyx
    es_Tutorial.lyx
    eu_Customization.lyx
    eu_Extended.lyx
    eu_FAQ.lyx
    eu_Intro.lyx
    eu_Tutorial.lyx
    eu_UserGuide.lyx
    Extended.lyx
    FAQ.lyx
    fr_Customization.lyx
    fr_Extended.lyx
    fr_FAQ.lyx
    fr_Intro.lyx
    fr_Tutorial.lyx
    fr_UserGuide.lyx
    he_Intro.lyx
    he_Tutorial.lyx
    hu_Intro.lyx
    hu_Tutorial.lyx
    Intro.lyx
    it_Customization.lyx
    it_Intro.lyx
    it_Tutorial.lyx
    it_UserGuide.lyx
    LaTeXConfig.lyx.in
    nl_Intro.lyx
    nl_Tutorial.lyx
    nb_Intro.lyx
    pl_Extended.lyx
    pl_Intro.lyx
    pl_Tutorial.lyx
    pt_Intro.lyx
    pt_Tutorial.lyx
    Reference.lyx
    ro_Intro.lyx
    ru_FAQ.lyx
    ru_Intro.lyx
    ru_Tutorial.lyx
    sk_Tutorial.lyx
    sk_UserGuide.lyx
    sl_Intro.lyx
    sl_Tutorial.lyx
    sv_Intro.lyx
    sv_Tutorial.lyx
    Tutorial.lyx
    UserGuide.lyx
    escher-lsd.eps
    mobius.eps
    platypus.eps
''')


lib_lyx2lyx_files = Split('''
    lyx2lyx
    parser_tools.py
    LyX.py
    lyx_0_12.py
    lyx_1_0_0.py
    lyx_1_0_1.py
    lyx_1_1_4.py
    lyx_1_1_5.py
    lyx_1_1_6fix3.py
    lyx_1_1_6.py
    lyx_1_2.py
    lyx_1_3.py
    lyx_1_4.py
    profiling.py
''')

