/*
 * Copyright (c) 2010 Andreas Hofmeister <andi@collax.com>
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#ifndef _WRITER_H
#define _WRITER_H

#include <stdio.h>

struct writer {
	void	* priv;
	void	(*start)(struct writer *, const char * tag, const char * descr);
	void	(*attr)(struct writer *, const char * tag, const char * descr, const char * value);
	void	(*data)(struct writer *, const char * data);
	void	(*end)(struct writer *);
	void	(*finish)(struct writer *);
};

#define tag_start(w,...)	w->start(w,## __VA_ARGS__)
#define tag_attr(w,...)		w->attr(w,## __VA_ARGS__)
#define tag_data(w,...)		w->data(w,## __VA_ARGS__)
#define tag_end(w,...)		w->end(w,## __VA_ARGS__)
#define tag_datatag(w,t,d,...)	{ w->start(w,t,d); w->data(w,## __VA_ARGS__); w->end(w); }

extern struct writer * txt_init( FILE * );
extern struct writer * kv_init( FILE * );

#ifdef USE_XML
extern struct writer * xml_init( FILE * );
#endif

#endif /* _WRITER_H */
