/***************************************************************************
 *   Copyright (C) 2005 - 2006 by Christian Muehlhaeuser, Last.fm Ltd.            *
 *   chris@last.fm                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02111-1307, USA.          *
 ***************************************************************************/

#ifndef __WEBSERVICECONNECTOR_H__
#define __WEBSERVICECONNECTOR_H__

#include <QObject>
#include <QHash>

class QHttp;
class QHttpResponseHeader;
class QTimer;
class QUrl;

class Playlist;
class SettingsForm;
class Song;

class WebserviceConnector : public QObject
{
    Q_OBJECT

    static WebserviceConnector *s_instance;

    public:
        WebserviceConnector();
        ~WebserviceConnector();

        static WebserviceConnector *instance() { return s_instance; }

        void handshake( QString username, QString password );
        bool isConnected() { return m_connected; }
        bool isSubscriber() { return m_subscriber; }

        void searchArtist( QString artist );
        void searchTag( QString tag );

        void tagsForArtist( QString artist );
        void tagsForUser( QString artist );
        void tagsForUserArtist( QString user, QString artist );
        void tagsForUserTrack( QString user, QString artist, QString track );
        void tagsForUserAlbum( QString user, QString artist, QString album );

        void setTag( Song *song, int mode, QString tag );

        void changeStation( QString url );

        void playlistRemove( QString id );
        void playlistClear();

    private:
        bool m_connected;
        bool m_subscriber;
        bool m_forcedUpdate;

        QString m_session;
        QString m_baseHost;
        QString m_basePath;

        QString m_lastStation;
        Song *m_lastSong;
        QHash<int, QHttp *> m_httpStack;
        QTimer *m_refreshTimer;

        QString parameter( QString keyName, QString data );
        QStringList parameterArray( QString keyName, QString data );
        QStringList parameterKeys( QString keyName, QString data );

        void stackAppend( QHttp *http );
        QHttp* stackGet( int id );
        void stackRemove( int id, bool keepAnimation = false );

        void errorCode( int id, QString errorMessage = QString() );

    public slots:
        void metaData( bool force = true );

        void skip();
        void love();
        void ban();

        void recordToProfile( bool enabled );
        void discoveryMode( bool enabled );

    signals:
        void handshakeResult( bool connected, bool loginDone, const QUrl& streamUrl );
        void metaDataResult( const Song& song, bool discovery = false );
        void playlistResult( const Playlist& playlist );

        void searchArtistResult( const QString& artist, const QString& image, bool streamable, const QStringList& result, const QStringList& resultImages );
        void searchTagResult( const QStringList& result, const QList<QStringList>& topArtists );

        void tagsForArtistResult( const QStringList& result );
        void tagsForUserResult( const QStringList& result );
        void tagsForUserArtistResult( const QStringList& result );
        void tagsForUserTrackResult( const QStringList& result );
        void tagsForUserAlbumResult( const QStringList& result );

        void skipResult();
        void loveResult();
        void banResult();

        void recordToProfileResult();
        void changeStationResult( bool error = false );

        void skipPrepared();
        void lovePrepared();
        void banPrepared();
        void changeStationPrepared();

        void actionStarted();
        void actionFinished();

    private slots:
        void handshakeHeaderReceived( const QHttpResponseHeader &resp );
        void handshakeFinished( int id, bool error );
        void metaDataFinished( int id, bool error );

        void searchArtistFinished( int id, bool error );
        void searchTagFinished( int id, bool error );

        void tagsForArtistFinished( int id, bool error );
        void tagsForUserFinished( int id, bool error );
        void tagsForUserArtistFinished( int id, bool error );
        void tagsForUserTrackFinished( int id, bool error );
        void tagsForUserAlbumFinished( int id, bool error );
        void setTagFinished( int id, bool error );

        void skipFinished( int id, bool error );
        void loveFinished( int id, bool error );
        void banFinished( int id, bool error );

        void changeStationFinished( int id, bool error );

        void defaultFinished( int id, bool error );
};

#endif
