/***************************************************************************
 *   Copyright (C) 2003 by Tom Deblauwe                                    *
 *   tomNOSPAM.deblauwe@pandora.be                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#include "selectfromlistdialog.h"
#include "subtitlelistviewitem.h"
#include "csubtitles.h"
#include "csubtitle.h"

#include <iostream>

#include "qdialog.h"
#include "qlistview.h"
#include "qpoint.h"
#include "qcheckbox.h"
#include "qlineedit.h"
#include "qlabel.h"

#include "klistview.h"
#include "klocale.h"


SelectFromListDialog::SelectFromListDialog(QWidget * parent, const char * name, bool modal) : SelectFromListDlg(parent, name, modal)
{
    subtitles = 0;

    //add columns

    lv_list->addColumn( i18n("Nr") );
    lv_list->addColumn( i18n("Start Time") );
    lv_list->addColumn( i18n("Length") );
    lv_list->addColumn( i18n("Text") );

    //make the items in the columns align to top

    lv_list->setColumnAlignment(0, Qt::AlignTop);
    lv_list->setColumnAlignment(1, Qt::AlignTop);
    lv_list->setColumnAlignment(2, Qt::AlignTop);
    lv_list->setColumnAlignment(3, Qt::AlignTop);

    //set default values for find 
    
    caseFind = false;

    //connect double clicked signal to slot

    connect(lv_list, SIGNAL(executed(QListViewItem *)), this, SLOT(slotDoubleClicked(QListViewItem *)));
}

SelectFromListDialog::~SelectFromListDialog()
{}

void SelectFromListDialog::loadSubtitles(CSubtitles* loadSubtitles, CSubtitle* highlightSub)
{
    //clear screen

    lv_list->clear();

    //put it in our private variable

    subtitles = loadSubtitles;

    //add all items

    QPtrListIterator<CSubtitle> it = subtitles->getIterator();
    CSubtitle* sub;
    long counter = 0;
    while ( (sub = it.current() ) != 0 )
    {
        ++it;
        counter++;
        new SubtitleListViewItem(lv_list, QString::number(counter), CSubtitles::getQTimeFromMSecs(sub->getStartTime()).toString( QString("hh:mm:ss,zzz") ), CSubtitles::getQTimeFromMSecs(sub->getEndTime() - sub->getStartTime()).toString( QString("hh:mm:ss,zzz") ), sub->getLine1() + "\n" + sub->getLine2());
    }

    //select the current subtitle

    QListViewItem* lvItem = lv_list->findItem(CSubtitles::getQTimeFromMSecs(highlightSub->getStartTime()).toString( QString("hh:mm:ss,zzz") ), 1);
    lv_list->setSelected(lvItem, true);

    //sort on starttime

    lv_list->setSorting(1, true);
    lv_list->setShowSortIndicator(true);

    //make selected subtitle centered

    lv_list->ensureItemVisible(lvItem);
}

void SelectFromListDialog::slotDoubleClicked(QListViewItem *)
{
    //double clicked on the listview

    pb_select_clicked();
}


CSubtitle * SelectFromListDialog::getSubtitle()
{
    return selectedSubtitle;
}

void SelectFromListDialog::pb_select_clicked()
{
    //printf("select clicked\n");

    //set selected subtitle

    //get selected subtitles, but only one can be selected so we get the first and only one

    QPtrList<QListViewItem> sel = lv_list->selectedItems();
    QListViewItem* lvItem = sel.getFirst();

    //we get the number of the subtitle from the first column and then jump according to this number
    QPtrListIterator<CSubtitle> it = subtitles->getIterator();
    it += (lvItem->text(0)).toLong() - 1;

    selectedSubtitle = it.current();

    //close window with accept return value

    accept();
}

void SelectFromListDialog::pb_cancel_clicked()
{
    //close with reject return value

    reject();
}

void SelectFromListDialog::pb_next_clicked()
{
    QString em("");
    l_notify->setText( em );
    
    // get string to search for
    QString str = le_find->text();
    if ( str.isEmpty() ) return;

    //sort on starttime
    lv_list->setSorting(1, true);
    lv_list->setShowSortIndicator(true);
    
    //fprintf(stdout, "searching for string: %s\n", str.latin1() );
    
    //get selected subtitles, but only one can be selected so we get the first and only one
    QPtrList<QListViewItem> sel = lv_list->selectedItems();
    QListViewItem* lvItem = sel.getFirst();

    //we get the number of the subtitle from the first column and then jump according to this number
    QPtrListIterator<CSubtitle> it = subtitles->getIterator();
    it += (lvItem->text(0)).toLong();

    // record starting position ( one more than actually )
    long startPos = (lvItem->text(0)).toLong();

    //search from here until the end
    CSubtitle* sub;
    long counter = 0;
    while ( (sub = it.current() ) != 0 )
    {
        ++it;
        counter++;
        
        // build sub to 1 line
        QString temp = sub->getLine1();
        temp.append(' ');
        temp.append( sub->getLine2() );
        
        // look for pattern
        if ( temp.contains( str, caseFind ) ) { 
            selectedSubtitle = it.current();

            // make new sub visible and old not
            QListViewItem* lvItemit = lv_list->itemAtIndex( startPos + counter - 1 );
            lv_list->setSelected( lvItemit , true );
            lv_list->ensureItemVisible( lvItemit );
            
            return;
        }
    }

    // wrap around from start
    //fprintf(stdout, "wrapping around...\n");
    counter = 0;
    it.toFirst();
    while ( counter < startPos && ( sub = it.current() ) != 0 )
    {
        ++it;
        counter++;

        // build sub to 1 line
        QString temp = sub->getLine1();
        temp.append(' ');
        temp.append( sub->getLine2() );
        
        // look for pattern
        if ( temp.contains( str, caseFind ) ) { 
            //fprintf( stderr, "found it (wrapped)\n");
            selectedSubtitle = it.current();

            // make new sub visible
            QListViewItem* lvItemit = lv_list->itemAtIndex( counter - 1);
            lv_list->setSelected( lvItemit , true );
            lv_list->ensureItemVisible( lvItemit );

            return;
        }
    }

    l_notify->setText( i18n("Text not found!") ); 
}

void SelectFromListDialog::cb_case_stateChanged(int state)
{
        if ( state == QCheckBox::On ) 
                caseFind = true;
        else if ( state == QCheckBox::Off ) 
                caseFind = false;
}


#include "selectfromlistdialog.moc"
