/***************************************************************************
                          popupnotification.cpp  -  description
                             -------------------
    begin                : Thu Jan 30 2003
    copyright            : (C) 2003 by Mike K. Bennett
    email                : mkb137b@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "popupnotification.h"

#include <qcolor.h>

#include <kdebug.h>
#include <klocale.h>
#include <kurllabel.h>

#include "../currentaccount.h"
#include "../kmessdebug.h"
#include "../systemtraywidget.h"
#include "balloon.h"

// The constructor
PopupNotification::PopupNotification(SystemTrayWidget *systemTrayWidget, QWidget *parent, const char *name )
 : QWidget(parent,name),
   balloon_(0),
   systemTrayWidget_(systemTrayWidget)
{
  currentAccount_ = CurrentAccount::instance();
  connect( &balloonTimer_, SIGNAL(      timeout() ),
           this,           SLOT  ( closeBalloon() ) );
}



// The destructor
PopupNotification::~PopupNotification()
{
#ifdef KMESSDEBUG_POPUPNOTIFICATION
  kdDebug() << "DESTROYED PopupNotification" << endl;
#endif
}



// Get an "anchor" point from the system tray widget
QPoint PopupNotification::anchor()
{
  QPoint point;

  if ( systemTrayWidget_ != 0 )
  {
    point = systemTrayWidget_->mapToGlobal( systemTrayWidget_->pos() );
  }
  return point;
}



// Close and delete the balloon
void PopupNotification::closeBalloon()
{
#ifdef KMESSDEBUG_POPUPNOTIFICATION
  kdDebug() << "PopupNotification - Closing balloon" << endl;
#endif
  if ( balloon_ != 0 )
  {
#ifdef KMESSDEBUG_POPUPNOTIFICATION
    kdDebug() << "PopupNotification - Balloon is not null - disconnecting" << endl;
#endif
    disconnect( balloon_, SIGNAL( signalCloseClicked() ),
                this,     SLOT  (        hideBalloon() ) );
    disconnect( balloon_, SIGNAL( signalLabelClicked() ),
                this,     SLOT  (     balloonClicked() ) );
#ifdef KMESSDEBUG_POPUPNOTIFICATION
    kdDebug() << "PopupNotification - Closing..." << endl;
#endif
    balloon_->hide();
#ifdef KMESSDEBUG_POPUPNOTIFICATION
    kdDebug() << "PopupNotification - Deleting the balloon..." << endl;
#endif
    delete balloon_;
#ifdef KMESSDEBUG_POPUPNOTIFICATION
    kdDebug() << "PopupNotification - Resetting the balloon to null..." << endl;
#endif
    balloon_ = 0;
#ifdef KMESSDEBUG_POPUPNOTIFICATION
    kdDebug() << "PopupNotification - Stopping the timer..." << endl;
#endif
//    balloonTimer_.stop();  // Stopping the timer causes a crash for some unknown reason.
  }
#ifdef KMESSDEBUG_POPUPNOTIFICATION
  kdDebug() << "PopupNotification - Done closing balloon" << endl;
#endif
}



// Hide the balloon
void PopupNotification::hideBalloon()
{
#ifdef KMESSDEBUG_POPUPNOTIFICATION
  kdDebug() << "PopupNotification - Hide the balloon" << endl;
#endif
  if ( balloon_ != 0 )
  {
    balloon_->hide();
  }
}




// Show the popup balloon with the given text, picture, and color
void PopupNotification::showBalloon(QString& text, const QPixmap& pixmap, const QString& colorName)
{
  if ( currentAccount_ == 0 )
  {
    kdDebug() << "PopupNotification::showBalloon() - WARNING - Current account is null!" << endl;
    return;
  }

  if ( currentAccount_->getUseNotifier() )
  {
    // Check if the balloon is already showing
    if ( balloon_ == 0 )
    {
      // If not, create it
      balloon_ = new Balloon();
      // Connect it up
      connect( balloon_, SIGNAL( signalCloseClicked() ),
               this,     SLOT  (        hideBalloon() ) );
      connect( balloon_, SIGNAL( signalLabelClicked() ),
               this,     SLOT  (     balloonClicked() ) );
    }
    else
    {
      // If the balloon exists, append the given text to the balloon text
      text = balloon_->getText() + "\n" + i18n("and") + "\n" + text;
    }

    balloon_->setColor( colorName );
    balloon_->setPixmap( pixmap );
    balloon_->setText( text );
    balloon_->setAnchor( anchor() );
    
    balloon_->show();

    // Start the timer that will close and delete the balloon
    balloonTimer_.start( currentAccount_->getNotificationDuration() * 1000, true );
  }
}

#include "popupnotification.moc"
