/***************************************************************************
                          notificationitem.cpp  -  description
                             -------------------
    begin                : Thu May 22 2003
    copyright            : (C) 2003 by Michael Curtis
    email                : michael@kmess.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "notificationitem.h"

#include <qcolor.h>
#include <qpixmap.h>
#include <qstring.h>
#include <qtimer.h>

#include <kdebug.h>
#include <kiconloader.h>
#include <kurllabel.h>

#include "../currentaccount.h"
#include "notificationwidget.h"

// the constructor
NotificationItem::NotificationItem( NotificationWidget *parent, char *name,
   QString text, QString icon, QStringList linkedStrings, QObject *linkedClass )
 : QObject( parent, name ),
   icon_(icon),
   linkedClass_(linkedClass),
   linkedStrings_(linkedStrings),
   text_(text)
{
  KIconLoader    *loader = KGlobal::iconLoader();
  CurrentAccount *currentAccount = CurrentAccount::instance();

  if ( !pixmap_.load( icon_ ) )
  {
    pixmap_ = loader->loadIcon( icon_, KIcon::Small );
  }

  widget_ = new KURLLabel( parent );
  widget_->setAlignment( AlignAuto | AlignVCenter | WordBreak );
  widget_->setText( text_ );

  // start the self-destruct timer
  timer_ = new QTimer( this, "selfDestructTimer" );
  timer_->start( currentAccount->getNotificationDuration() * 1000, true );

  connect( timer_ ,    SIGNAL(         timeout() ),
           this   ,      SLOT(    selfDestruct() ) );

  connect( widget_,    SIGNAL(  leftClickedURL() ),
           this   ,      SLOT(         clicked() ) );
}




// the destructor
NotificationItem::~NotificationItem()
{
  // we'd better stop and delete the timer, because there might be a possibilty that it will try
  // and trigger if we were killed early, causing a crash
  timer_->stop();
  delete timer_;

  // remove the widget
  delete widget_;
}



void NotificationItem::clicked()
{
  emit forwardClicked( linkedStrings_, linkedClass_ );

  blockSignals( true );

  widget_->hide();

  timer_->stop();
  // self destruct in t minus 10ms
  timer_->start( 10, true );
}



// get the icon path
const QString & NotificationItem::getIcon() const
{
  return icon_;
}



// get a pixmap that corresponds to the icon
const QPixmap & NotificationItem::getPixmap() const
{
  return pixmap_;
}



// get the text of the item
const QString & NotificationItem::getText() const
{
  return text_;
}



// get the widget
KURLLabel * NotificationItem::getWidget() const
{
  return widget_;
}



// just commit suicide
void NotificationItem::selfDestruct()
{
#ifdef KMESSDEBUG_POPUPNOTIFICATION
  kdDebug() << "NotificationItem: committing suicide" << endl;
#endif

  delete this;
}


#include "notificationitem.moc"
