/***************************************************************************
                          emailnotification.cpp  -  description
                             -------------------
    begin                : Fri Jan 31 2003
    copyright            : (C) 2003 by Mike K. Bennett
    email                : mkb137b@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "emailnotification.h"

#include <qstringlist.h>

#include <kdebug.h>
#include <kiconloader.h>
#include <klocale.h>
#include <knotifyclient.h>

#include "balloonwidget.h"
#include "notificationwidget.h"
#include "notificationitem.h"

#include "../currentaccount.h"
#include "../kmessdebug.h"
#include "../systemtraywidget.h"

// The constructor
EmailNotification::EmailNotification( BalloonWidget *balloonWidget )
 : balloonWidget_( balloonWidget )
{
  notificationWidget_ = new NotificationWidget( balloonWidget );
  notificationWidget_->setCaption( i18n( "You have new mail:" ) );

  notificationWidget_->setPaletteBackgroundColor( "#D6BCFF" );

  connect( notificationWidget_,  SIGNAL(   clicked( QStringList, QObject * ) ),
           this,                   SLOT(   clicked( QStringList, QObject * ) ) );

  currentAccount_ = CurrentAccount::instance();
}



EmailNotification::~EmailNotification()
{
#ifdef KMESSDEBUG_EMAILNOTIFICATION
  kdDebug() << "DESTROYED EmailNotification" << endl;
#endif
}



// The balloon was clicked
void EmailNotification::clicked( QStringList stringList, QObject */*object*/ )
{
  // We need a non-const current account to open hotmail
  CurrentAccount *currentAccount = CurrentAccount::instance();

#ifdef KMESSTEST
  ASSERT( currentAccount != 0 );
#endif
#ifdef KMESSDEBUG_EMAILNOTIFICATION
  kdDebug() << "EmailNotification - Balloon clicked - open the inbox." << endl;
#endif
  if ( currentAccount != 0 )
  {
    // Open hotmail at the given email
    currentAccount->openHotmail( stringList[0], stringList[1], stringList[2] );
  }
}



// Called when a new email is received
void EmailNotification::newEmail(QString sender, QString subject, bool inInbox, QString command, QString folder, QString url)
{
#ifdef KMESSTEST
  ASSERT( currentAccount_ != 0 );
#endif
#ifdef KMESSDEBUG_EMAILNOTIFICATION
  kdDebug() << "EmailNotification - New email from " << sender << " in inbox: " << inInbox << "." << endl;
  kdDebug() << "EmailNotification - Show 'other folders' is " << currentAccount_->getShowOtherFolders() << "." << endl;
#endif
  QPixmap      pixmap;
  QString      text;
  QStringList  stringList;
//  KIconLoader *loader = KGlobal::iconLoader();

  // Save the command, folder, and url
  command_ = command;
  folder_ = folder;
  url_ = url;

  if ( currentAccount_->getShowEmail() )
  {
    if ( inInbox || ( currentAccount_->getShowOtherFolders() ) )
    {
#ifdef KMESSDEBUG_NOTIFYMASTER
      kdDebug() << "EmailNotification:   Prepare the notification message." << endl;
#endif
      // Prepare the notification message
//      text =  "\"" + subject + "\"\n ";
//      text += i18n("from") + " " + sender + "\n";
//      text += dir;
      if(inInbox)
      {
        text = i18n( "\"%1\"\nfrom %2\nin your inbox" ).arg( subject ).arg( sender );
      }
      else
      {
        text = i18n( "\"%1\"\nfrom %2\nin another folder" ).arg( subject ).arg( sender );
      }

      stringList.append( command );
      stringList.append( folder  );
      stringList.append( url     );

      new NotificationItem( notificationWidget_, 0, text, "mail_generic.png", stringList, 0 );

      //pixmap = loader->loadIcon( "mail_generic.png", KIcon::Small );
      //showBalloon( text, pixmap, "#D6BCFF" );

      // Send a system notification.
      KNotifyClient::event( "new email", text );

    }
#ifdef KMESSDEBUG_NOTIFYMASTER
    else
    {
      kdDebug() << "EmailNotification:   Don't show the notification message." << endl;
    }
#endif
  }
#ifdef KMESSDEBUG_NOTIFYMASTER
  else
  {
    kdDebug() << "EmailNotification:   Don't show any email stuff." << endl;
  }
#endif
}


#include "emailnotification.moc"
