/*
 *   componentSelectionPage.cpp
 *
 *   Copyright (C) 2004 Waldo Bastian <bastian@kde.org>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License version 2 as
 *   published by the Free Software Foundation.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include "componentSelectionPage.h"

#include <qpushbutton.h>

#include <kapplication.h>
#include <kconfig.h>
#include <kiconloader.h>
#include <kiconview.h>
#include <klocale.h>

#include "kioskdata.h"

class ComponentViewItem : public QIconViewItem
{
public:
   ComponentViewItem( QIconView * parent, const QString & text, const QPixmap & icon, const QString & _id )
    :  QIconViewItem( parent, text, icon), id(_id)
   {
   }

   QString id;
};

ComponentSelectionPage::ComponentSelectionPage( KioskData *data, QWidget* parent, const char* name, WFlags fl )
 : ComponentSelectionPageUI(parent, name, fl), PageWidget(this), m_data(data)
{
   listComponent->setSelectionMode(QIconView::Single);
   listComponent->setItemsMovable(false);
   listComponent->setSpacing(20);
   listComponent->setGridX(110);
   listComponent->setGridY(75);
   loadComponentList();
   connect(listComponent, SIGNAL(clicked(QIconViewItem *)), this, SLOT(slotComponentActivated(QIconViewItem *)));
   connect(listComponent, SIGNAL(returnPressed (QIconViewItem *)), this, SLOT(slotComponentActivated(QIconViewItem *)));
   connect(pbSetup, SIGNAL(clicked()), this, SLOT(slotComponentActivated()));
}

ComponentSelectionPage::~ComponentSelectionPage()
{
}

void ComponentSelectionPage::load()
{
}

bool ComponentSelectionPage::save()
{
   KConfig *config = kapp->config();
   config->setGroup("General");
   config->writeEntry("CurrentComponent", currentComponent());
   config->sync();
   return true;
}

void ComponentSelectionPage::setFocus()
{
}

QString ComponentSelectionPage::subCaption()
{
   return QString::null;
}

void ComponentSelectionPage::loadComponentList()
{
    listComponent->clear();
    for(QStringList::ConstIterator it = m_data->m_componentList.begin();
        it != m_data->m_componentList.end(); ++it)
    {
       ComponentData *data = m_data->m_componentData.find(*it);
       Q_ASSERT(data);
       if (!data) continue;
       QPixmap icon = DesktopIcon( data->icon, KIcon::SizeMedium );
       new ComponentViewItem(listComponent, data->caption, icon, data->id);
    }
}

bool ComponentSelectionPage::hasSelection()
{
   return !currentComponent().isEmpty();
}

QString ComponentSelectionPage::currentComponent()
{
   ComponentViewItem *item = static_cast<ComponentViewItem *>(listComponent->firstItem());
   while(item)
   {
      if (item->isSelected())
         return item->id;

      item = static_cast<ComponentViewItem *>(item->nextItem());
   }
   return QString::null;
}

void ComponentSelectionPage::setCurrentComponent(const QString &id)
{
   ComponentViewItem *item = static_cast<ComponentViewItem *>(listComponent->firstItem());
   while(item)
   {
      if (item->id == id)
      {
         listComponent->setSelected(item, true);
         return;
      }
      item = static_cast<ComponentViewItem *>(item->nextItem());
   }
   if (listComponent->firstItem())
      listComponent->setSelected(listComponent->firstItem(), true);
}

void ComponentSelectionPage::slotComponentActivated(QIconViewItem *item)
{
   if (item)
      emit componentActivated();
}

void ComponentSelectionPage::slotComponentActivated()
{
   if (!currentComponent().isEmpty())
      emit componentActivated();
}

#include "componentSelectionPage.moc"
