/***************************************************************************
 *   Copyright (C) 2004, 2005 Thomas Nagy                                  *
 *   tnagy2^8@yahoo.fr                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation (see COPYING)            *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 ***************************************************************************/

#ifndef _DITEM_H
#define _DITEM_H

#include <qobject.h>

#include "aux.h"

/**
 * This class handles the necessary code for registering
 * and manipulating mindmap items (data and views)
 *
 * @short Mindmap item common class
 * @author Thomas Nagy <tnagy2^8@yahoo.fr>
 */
class DItem
{
	public:
		DItem(int);
		virtual ~DItem();

		/**
		 * Returns the unique identification number representing an item
		 */
		int Id() const;

		/**
		 * Special id, representing the null item
		 */
		static const int NOITEM=-1;

	private:
		/**
		 * Id if an item - it cannot be equal to NOITEM (-1)
		 */
		int m_id;
};

#endif // _DITEM_H
