/*
    Copyright (  C ) 2003 Arnold Krille <arnold@arnoldarts.de>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation;
    version 2 of the License.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.

*/

#ifndef ARTS_KLEVELMETER_NORMALBARS_H
#define ARTS_KLEVELMETER_NORMALBARS_H

#include "klevelmeter_template.h"

#include <qptrlist.h>

class Bar;
class QBoxLayout;

class KLevelMeter_NormalBars : public KLevelMeter_Template {
   Q_OBJECT
public:
	KLevelMeter_NormalBars( Arts::KLevelMeter_impl*, QWidget* =0, long substyle=0, long count=25, Arts::Direction =Arts::BottomToTop, float _dbmin=-24, float _dbmax=6 );

	void invalue( float, float =0 );

	void count( long );
	long count();

	void resizeEvent( QResizeEvent* =0 );
private:
	float _value, _peak;
	QPtrList <Bar> bars;
//	long _count;
	QBoxLayout *_layout;
};

class Bar : public QWidget {
   Q_OBJECT
private:
	float _min, _max;
	QColor _color;
	bool _on;
public:
	Bar( float min, float max, QColor color, QWidget* parent ) : QWidget( parent ), _min( min ), _max( max ), _color( color ), _on( false ) {
		setBackgroundColor( _color.dark() );
	}
	void setValue( float n ) {
		if ( n>_min /*&& n<_max*/ ) on( true );
		else on( false );
	}
	void on( bool n ) {
		if ( _on != n )
		{
			_on = n;
			if ( _on ) setBackgroundColor( _color );
				else setBackgroundColor( _color.dark() );
		}
	}
	void setValues( float min, float max, QColor color ) { _min = min; _max = max; _color = color; on( _on ); }
};

#endif
// vim: sw=4 ts=4
