#ifndef INFOS_LIST_VIEW_ITEM_H
#define INFOS_LIST_VIEW_ITEM_H

#include <qlistview.h>

/*!
 * This class represents the "Show infos about contacts..." data row.
 * It reimplements the paintCell(...) to draw odd rows in different color
 * than even ones.
 * \brief This class represents the "Show infos about contacts..." data row.
 */
class InfosListViewItem : public QListViewItem
{
	public:
		/*!
		 * \brief Default constructor
		 * \param parent Parent object
		 * \param label1 %Ignored here (passed to QListViewItem's default constructor)
		 * \param label2 %Ignored here (passed to QListViewItem's default constructor)
		 * \param label3 %Ignored here (passed to QListViewItem's default constructor)
		 * \param label4 %Ignored here (passed to QListViewItem's default constructor)
		 * \param label5 %Ignored here (passed to QListViewItem's default constructor)
		 * \param label6 %Ignored here (passed to QListViewItem's default constructor)
		 * \param label7 %Ignored here (passed to QListViewItem's default constructor)
		 */
		InfosListViewItem(QListView *parent, QString label1, QString label2, QString label3, QString label4,
			QString label5, QString label6, QString label7);

		//! Default destructor
		~InfosListViewItem();

		/*!
		 * \brief Paints the item (odd rows in different color than even ones)
		 * \param p Painter device
		 * \param cg Color group to use
		 * \param column The logical column number within the item that is to be painted
		 * \param width The width of the item (row)
		 * \param align Alingment. See Qt::AlignmentFlags
		 */
		virtual void paintCell(QPainter *p, const QColorGroup &cg, int column, int width, int align);
	private:
		static bool alternativeColor;
		QListView *parentList;
};

#endif
