/*      $Id: irmp3-ncurses.h,v 1.65 2005/03/26 17:53:20 ross Exp $       */

/*******************************************************\
* irmp3-ncurses - An ncurses frontend for irmp3 using   *
* the Network Control Module                            *
* (C) 2003 Ross Axe                                     *
*                                                       *
* irmp3-ncurses.h - global headers                      *
\*******************************************************/

#ifndef _POSIX_C_SOURCE
#  define _POSIX_C_SOURCE 2
#endif
#ifndef _GNU_SOURCE
#  define _GNU_SOURCE
#endif

#include <assert.h>
#include <stdio.h>
#if HAVE_STDLIB_H
#  include <stdlib.h>
#endif
#if HAVE_STRING_H
#  include <string.h>
#elif HAVE_STRINGS_H
#  include <strings.h>
#endif
#include <errno.h>
#include <ctype.h>
#if HAVE_STDBOOL_H
#  include <stdbool.h>
#else
typedef bool enum {false, true};
#endif
#if HAVE_MALLOC_H
#  include <malloc.h>
#endif
#if HAVE_MEMORY_H
#  include <memory.h>
#endif

#include "autocurses.h"

#include "../libcompat/libcompat.h"


#define STRINGIZE(str) #str
#define STR(str) STRINGIZE(str)
#define COPYING "(C) 2003-2005 Ross Axe"

#ifdef __GNUC__
#  define vcid(id) static const __attribute__((used)) char vcid[] = id
#else
#  define vcid(id) static const char vcid[] = id
#endif

/* feature detection */
#if WANT_MOUSE
#  if defined NCURSES_MOUSE_VERSION
#    define USE_MOUSE 1
#  else
#    warning Mouse support requested, but ncurses mouse support not found
#  endif
#endif
#if HAVE_RESIZE_WINDOW && defined KEY_RESIZE
#  define TERM_RESIZE 1
#endif

/* screen layout definitions */
#define DEBUG_HEIGHT 5		/* height of debug window */
#define PLAYLIST_LEFT 42	/* column of playlist window */
#define PLAYLIST_TOP 0		/* top row of playlist window */
#define STATE_TOP 0		/* row of state window */
#define BUTTON_LEFT 20		/* column on button bar */
#define FILENAME_ROW 1
#define TIME_ROW 2
#define SHUFFLE_REPEAT_ROW 3
#define BUTTON_ROW 4
#define ARTIST_ROW 6
#define ALBUM_ROW 7
#define TITLE_ROW 8
#define YEAR_GENRE_ROW 9
#define COMMENT_ROW 10
#define VOLUME_ROW 11
#define BASS_ROW 12
#define TREBLE_ROW 13
#define BALANCE_ROW 14
#define STATE_HEIGHT 16		/* height of state window */
extern int timeleft;
extern int repeatleft;
extern int volumeleft;
extern int balanceleft;
extern int bassleft;
extern int trebleleft;
#define COLOURPAIR_TITLE 1
#define COLOURPAIR_BORDER 2
#define COLOURPAIR_CURSOR 3
#if USE_COLOUR
#  define TITLE_ATTR (has_colors() ? COLOR_PAIR(COLOURPAIR_TITLE) : A_REVERSE)
#  define BORDER_ATTR (has_colors() ? COLOR_PAIR(COLOURPAIR_BORDER) : 0)
#  define CURSOR_ATTR (has_colors() ? COLOR_PAIR(COLOURPAIR_CURSOR) : A_REVERSE)
#else
#  define TITLE_ATTR (A_REVERSE)
#  define BORDER_ATTR (0)
#  define CURSOR_ATTR (A_REVERSE)
#endif


/* playlist/song/player information */
extern WINDOW *plwin, *plouterwin;
extern int plcount;
extern WINDOW *debugwin;
extern WINDOW *statewin;

struct songinfo {
    char title[256];
    char artist[256];
    char album[256];
    char genre[256];
    char comment[256];
    char year[16];
    char filename[2048];
    int length;			/* in seconds, -1 for unknown */
    int pos;			/* current position in seconds, -1 for N/A */
};

enum repeat {RP_NONE, RP_TRACK, RP_ALL};
enum play {PS_STOP, PS_PLAY, PS_PAUSE, PS_HALT};
struct playerstate {
    char version[1024];		/* version string for irmp3 itself */
    char playermodule[32];	/* name of module handling current file */
    char playerversion[1024];	/* version string for mpg123, ogg123 etc... */
    enum play playstate;
    bool shuffle;
    enum repeat repeat;
    int volume;
    bool mute;
    int balance;
    int bass;
    int treble;
};

extern struct songinfo songinfo;
extern struct playerstate playerstate;

#if PLAYLIST
extern bool show_playlist;
#else
#  define show_playlist false
#endif

#ifndef LOGGING
#  define loglevel 0
#else
extern int loglevel;
#endif

/* some useful macros */
#ifndef max
#  define max(a,b) (((a) > (b)) ? (a) : (b))
#endif
#define NUMELEMENTS(a) (sizeof (a) / sizeof (a)[0])
#define STRLEN(s) (NUMELEMENTS(s)-1)
#define strstart(s1,s2) (strncmp((s1), (s2), STRLEN(s1)) == 0)	/* does s2
								   start with
								   s1? */
#ifdef __GNUC__
#  define PRINTF_FMT(fmt, ap) __attribute__((format(printf, fmt, ap)))
#else
#  define PRINTF_FMT(fmt, ap)
#endif


void error_sleep(void);
extern WINDOW *brwnd;
bool browser_net_callback(int sock, char *buf);
bool main_net_callback(int sock, char *buf);
bool key_callback(int sock, int chr);
bool browser_key_callback(int sock, int chr);
int main_poll_loop(int sock);
void browser_init(int sock);

/* network functions */
bool handle_net(int sock);
int netputs(const char *msg, int sock);
int netprintf(int sock, const char *fmt, ...);
void init_queries(int sock);
bool start_network(void);
bool stop_network(void);
bool set_address(const char *hostname, const char *port);
int connect_irmp3(void);
void send_query(int sock, const char *value);

/* display functions */
PRINTF_FMT(1, 2) int sbar_printf(const char *fmt, ...);
PRINTF_FMT(1, 2) int sbar_printf_noscroll(const char *fmt, ...);
#define dbg_printf(level, ...) ((loglevel > level) ? sbar_printf(__VA_ARGS__) \
				: 0)
PRINTF_FMT(3, 4) int sbar_getstr(char *buf, size_t size, const char *fmt, ...);
PRINTF_FMT(3, 4) void printtitlebar(WINDOW *win, const char *caption,
				    const char *fmt, ...);
void wprintslider(WINDOW *wnd, int length, int value, int min, int max);
void mvwprintslider(WINDOW *wnd, int r, int c, int length, int value, int min,
		    int max);
void mvwprintvslider(WINDOW *wnd, int r, int c, int length, int value, int min,
		     int max);

void printtime(int secs, int rsecs);
void printsonginfo(void);
void printplayerstate(void);
void redraw_all(void);
void init_ui(void);
void destroy_ui(void);
void resize_terminal(void);
void about(void);
int wcr(WINDOW *win);

/* scroller definitions */
struct scroller {
    WINDOW **wnd;
    char *msg;
    int x, y, len;
    int pos, dir;
    void *(*entryhook)(struct scroller *scroller);
    void (*exithook)(struct scroller *scroller, void *data);
};
#define SCROLLER_INITIALISER {}
#define wscroller(wnd, scroller, msg, right)				\
	wscroller_hook(wnd, scroller, msg, right, NULL, NULL)
void wscroller_hook(WINDOW **wnd, struct scroller *scroller, const char *msg,
		    bool right, void *(*entryhook)(struct scroller *),
		    void (*exithook)(struct scroller *, void *));
void scroller_end(struct scroller *scroller);
void scroller_endall(void);

/* player/song information manipulation */
void setartist(const char *artist);
void setalbum(const char *album);
void settitle(const char *title);
void setyear(const char *year);
void setgenre(const char *genre);
void setcomment(const char *comment);
void setplaystate(enum play playstate);
void setshufflemode(bool shuffle);
void setrepeatmode(enum repeat repeat);
void setfilename(const char *filename);
void clearsonginfo(void);
void setirmp3version(char *name);
void setplayermodule(char *name);
void setplayerversion(char *name);
void setvolume(int vol);
void setmute(bool mute);
void setbalance(int balance);
void setbass(int bass);
void settreble(int treble);


/* playlist functions */
#if PLAYLIST
void playlist_dirty(int sock);
#else
#  define playlist_dirty(sock) ((void)0)
#endif
bool handle_plfiles(int sock, char *buf);
void playlist_print(void);
void plwin_create(int sock);
void plwin_destroy(void);
int playlist_find(const char *name);
void playlist_setplaying(int i);
bool playlist_key_callback(int sock, int chr);

/* mouse functions */
#if USE_MOUSE
bool playlist_mouse(MEVENT *mevent, int sock);
#endif

/* gettext */
#include "gettext.h"
#define _(String) gettext(String)
#define N_(String) gettext_noop(String)
