/*
     This file is part of GNUnet.
     (C) 2005 Christian Grothoff (and other contributing authors)

     GNUnet is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published
     by the Free Software Foundation; either version 2, or (at your
     option) any later version.

     GNUnet is distributed in the hope that it will be useful, but
     WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with GNUnet; see the file COPYING.  If not, write to the
     Free Software Foundation, Inc., 59 Temple Place - Suite 330,
     Boston, MA 02111-1307, USA.
*/

/**
 * @file src/plugins/daemon/daemon.c
 * @brief code for gnunet-gtk gnunetd interaction
 * @author Christian Grothoff
 */

#include "platform.h"
#include "gnunetgtk_common.h"
#include <GNUnet/gnunet_getoption_lib.h>



/**
 * cron job that periodically updates the model for the
 * application list.
 */
static void updateAppModelSafe(void * unused) {
  GNUNET_TCP_SOCKET * sock;
  GtkWidget * w;
  GtkListStore * model;
  GtkTreeIter iter;
  char * apps;
  char * next;
  char * pos;
  char * desc;

  model = gtk_list_store_new(2,
			     G_TYPE_STRING,
			     G_TYPE_STRING);
  sock = getClientSocket();
  if (sock == NULL) {
    apps = NULL;
  } else {
    apps
      = getConfigurationOptionValue(sock,
				    "GNUNETD",
				    "APPLICATIONS");
  }
  if (apps != NULL) {
    next = apps;
    do {
      while (*next == ' ')
	next++;
      pos = next;
      while ( (*next != '\0') &&
	      (*next != ' ') )
	next++;
      if (*next == '\0') {
	next = NULL; /* terminate! */
      } else {
	*next = '\0'; /* add 0-termination for pos */
	next++;
      }
      if (strlen(pos) > 0) {
	desc
	  = getConfigurationOptionValue(sock,
					"ABOUT",
					pos);
	
	gtk_list_store_append(model,
			      &iter);
	gtk_list_store_set(model,
			   &iter,
			   0, pos,
			   1, dgettext("GNUnet", desc),
			   -1);
	FREENONNULL(desc);
      }
    } while (next != NULL);
    FREE(apps);
  }
  w = glade_xml_get_widget(getMainXML(),
			   "applicationList");
  gtk_tree_view_set_model(GTK_TREE_VIEW(w),
			  GTK_TREE_MODEL(model));
  releaseClientSocket(sock);
}

static void updateAppModel(void * dummy) {
  gtkSaveCall(&updateAppModelSafe, NULL);
}


static void doUpdateMenus(void * arg) {
  int ret = *(int*) arg;
  static GtkWidget * killEntry = NULL;
  static GtkWidget * launchEntry = NULL;
  static GtkWidget * statsEntryYes = NULL;
  static GtkWidget * statsEntryNo = NULL;
  static int once = 1;
  static int isLocal;
  char * host;

  if (once) {
    once = 0;
    killEntry
      = glade_xml_get_widget(getMainXML(),
			     "stopDaemon");
    launchEntry
      = glade_xml_get_widget(getMainXML(),
			     "startDaemon");
    statsEntryYes
      = glade_xml_get_widget(getMainXML(),
			     "statusPixmapYes");
    statsEntryNo
      = glade_xml_get_widget(getMainXML(),
			     "statusPixmapNo");
    host = getConfigurationString("NETWORK",
				  "HOST");
    if ( (host == NULL) ||
	 (strcmp(host, "localhost")==0) )
      isLocal = TRUE;
    else
      isLocal = FALSE;
    FREENONNULL(host);
  }
  updateAppModelSafe(NULL);
  if (ret == SYSERR) {
    gtk_widget_hide(statsEntryYes);
    gtk_widget_show_all(statsEntryNo);
    gtk_widget_set_sensitive(killEntry, FALSE);
    gtk_widget_set_sensitive(launchEntry, (TRUE & isLocal) );
  } else {
    gtk_widget_hide(statsEntryNo);
    gtk_widget_show_all(statsEntryYes);
    gtk_widget_set_sensitive(killEntry, TRUE);
    gtk_widget_set_sensitive(launchEntry, FALSE);
  }
}

static void cronCheckDaemon(void * dummy) {
  static int last = 42;
  int ret;

  ret = checkGNUnetDaemonRunning();
  if (ret != last) {
    last = ret;
    gtkSaveCall(&doUpdateMenus, &ret);
  }
}


/**
 * Launch gnunetd w/ checks
 */
void on_startDaemon_clicked(GtkWidget * widget,
			    gpointer data) {
  GtkWidget * launchEntry;
  launchEntry
    = glade_xml_get_widget(getMainXML(),
			   "startDaemon");
  gtk_widget_set_sensitive(launchEntry, FALSE);
  if (OK == checkGNUnetDaemonRunning() ) {
    cronCheckDaemon(NULL);
    return;
  } else {	
    addLogEntry(_("Launching gnunetd..."));
    if (SYSERR != startGNUnetDaemon(YES)) {
      addLogEntry(_("Launched gnunetd"));
    } else {
      addLogEntry(_("Launching gnunetd failed"));
    }
  }
}

/**
 * Kill gnunetd
 */
void on_stopDaemon_clicked(GtkWidget * widget,
			   gpointer data) {
  GtkWidget * killEntry = NULL;
  killEntry
    = glade_xml_get_widget(getMainXML(),
			   "stopDaemon");
  gtk_widget_set_sensitive(killEntry, FALSE);

  if (OK == checkGNUnetDaemonRunning() ) {
    if (OK != stopGNUnetDaemon()) {
      GtkWidget * dialog;

      dialog = gtk_message_dialog_new
	(NULL,
	 GTK_DIALOG_MODAL,
	 GTK_MESSAGE_ERROR,
	 GTK_BUTTONS_CLOSE,
	 _("Error requesting shutdown of gnunetd."));
      gtk_dialog_run(GTK_DIALOG(dialog));
      gtk_widget_destroy(dialog);
    } else {
      addLogEntry(_("Terminating gnunetd..."));
    }
  }
  cronCheckDaemon(NULL);
}

void init_daemon() {
  GtkWidget * tab;
  GtkWidget * apps;
  GtkListStore * model;
  GtkCellRenderer * renderer;
  int col;

  apps
    = glade_xml_get_widget(getMainXML(),
			   "applicationList");
  model = gtk_list_store_new(1, G_TYPE_STRING);
  gtk_tree_view_set_model(GTK_TREE_VIEW(apps),
			  GTK_TREE_MODEL(model));
  renderer = gtk_cell_renderer_text_new();
  col = gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW(apps),
					      -1,
					      _("Application"),
					      renderer,
					      "text", 0,
					      NULL);
  gtk_tree_view_column_set_resizable(gtk_tree_view_get_column(GTK_TREE_VIEW(apps),
                                              col - 1),
                                              TRUE);
  renderer = gtk_cell_renderer_text_new();
  col = gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW(apps),
					      -1,
					      _("Description"),
					      renderer,
					      "text", 1,
					      NULL);
  gtk_tree_view_column_set_resizable(gtk_tree_view_get_column(GTK_TREE_VIEW(apps),
                                              col - 1),
                                              TRUE);

  updateAppModelSafe(NULL);
  tab
    = glade_xml_get_widget(getMainXML(),
			   "daemonScrolledWindow");
  gtk_widget_show(tab);
  addCronJob(&cronCheckDaemon,
	     0,
	     15 * cronSECONDS,
	     NULL);
  addCronJob(&updateAppModel,
	     5 * cronMINUTES,
	     5 * cronMINUTES,
	     NULL);
}

void done_daemon() {
  delCronJob(&cronCheckDaemon,
	     15 * cronSECONDS,
	     NULL);
  delCronJob(&updateAppModel,
	     5 * cronMINUTES,
	     NULL);
}

/* end of daemon.c */
