/*  GFAX - Gnome fax application
 *  Copyright (C) 1999 George A. Farris
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

/* #undef GLADEDIR
#define GLADEDIR "src" */

#define CONFIG_PATH	"/Gfax"
#define CALL_FROM_MAIN TRUE

#define NO_EMAIL_ADDRESS 	10
#define NO_FAX_NUMBER		11
#define CHANGED				TRUE

/* new type that holds a single destination */

typedef struct _destination Destination;

struct _destination
{
	gchar *faxNumber;
	gchar *organization;
	gchar *attention;	
	gchar *fileName;
	gint deleteFile;
};

/* Global data */
	gint ampm;						/* whether time is am or pm, 0=am, 1=pm */
	
	/* Configuration data */
	gchar *transmitAgent;    /* should be mgetty or hylafax */
	gchar *emailAddress;	  /* email address of user */
	gchar *phonePrefix;	  /* prefix for telephone dial out */
	gchar *ourFaxNumber;
	gchar *fileName;      /* filename from command line or fax file*/ 
	gchar *hour;
	gchar *minute;
	gboolean sendNow_state;			/* send now or at later time */
	gboolean emailNotify_state;		/* should we notify by email */
	gboolean coverPage_state;		/* should we send a cover page */
	gboolean resolution_state;		/* fax is normal or fine resolution */
        gchar *hylafaxServerName;               /* name of hylafax server */
        int    hylafaxServerPort;               /* port of hylafax server */
        gboolean hylafaxInternalSendfax;        /* use build-in hylafax */
/* end global data */


/* common function declarations */
	void get_config(gboolean fromMain);
	void fax_file(GtkWidget *button, gpointer data);
	gint send_fax(Destination *dest, gboolean b);
	gint setup(void);
	void do_message(gchar *msg);
	Destination	*phone_book(Destination *dest);

/* These are Emacs variables to use a common "Gfax" coding style:
 * ;;; Local Variables: ***
 * ;;; mode:C ***
 * ;;; c-basic-offset:8 ***
 * ;;; indent-tabs-mode:t ***
 * ;;; End: ***
 */
