/*  GFAX - Gnome fax application
 *  Copyright (C) 1999 George A. Farris
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/


#include <config.h>
#include <gnome.h>
#include <glade/glade.h>
#include "gfax.h"

void on_faxFileOkB_clicked(GtkWidget *button, gpointer data);
void on_faxFileCancelB_clicked(GtkWidget *button, gpointer data);

GtkEntry *faxFileE;	


/*=========================================================================
 * fax_file()
 *	
 *
 *-----------------------------------------------------------------------*/
void fax_file(GtkWidget *widget, gpointer data)
{
	GladeXML *window;				/* The main window */

	window = glade_xml_new(GLADEDIR "/gfax.glade", "file");

	faxFileE = (GtkEntry *)glade_xml_get_widget(window, "faxFileE");

	glade_xml_signal_autoconnect(window);
	
	return;
}

void on_faxFileOkB_clicked(GtkWidget *button, gpointer data)
{
		
	/* get the file name. We put a \ on the front as an easy way to return
	   a flag to gfax that this file shouldn't be deleted. */
 	fileName = g_strdup_printf("\\%s", gtk_entry_get_text(GTK_ENTRY(faxFileE)));
	gtk_object_destroy(GTK_OBJECT(gtk_widget_get_toplevel(GTK_WIDGET(button))));
	
	return;
}

void on_faxFileCancelB_clicked(GtkWidget *button, gpointer data)
{
	gtk_object_destroy(GTK_OBJECT(gtk_widget_get_toplevel(GTK_WIDGET(button))));
	return;
}
