
/* Several defines and includes for different OSes. */

#include "../config.h"

#ifdef USE_LINUX
  #define NOBODY "nobody"
  #define ADDUSER "useradd"
  #define ADDGROUP "groupadd"
  #define DELUSER "userdel"
  #define NULLDEVICE "/dev/null"
#elif defined USE_SUNOS
  #define NOBODY "nobody"
  #define ADDUSER "useradd"
  #define ADDGROUP "groupadd"
  #define NULLDEVICE "/dev/null"
#elif defined USE_FREEBSD
  #define NOBODY "nobody"
  #define ADDUSER "pw useradd"
  #define ADDGROUP "pw groupadd"
  #define NULLDEVICE "/dev/null"
#elif defined USE_OPENBSD  
  #define NOBODY "nobody"
  #define ADDUSER "useradd"
  #define ADDGROUP "groupadd"
  #define NULLDEVICE "/dev/null"
#elif defined USE_NETBSD
  #define NOBODY "nobody"
  #define ADDUSER "useradd"
  #define ADDGROUP "groupadd"
  #define NULLDEVICE "/dev/null"
#elif defined USE_DARWIN
  #define NOBODY "nobody"
  #define ADDUSER "useradd"
  #define ADDGROUP "groupadd"
  #define NULLDEVICE "/dev/null"
//  #include "osx_functions.h"
#elif defined USE_AIX
  #define NOBODY "nobody"
  #define ADDUSER "useradd"
  #define ADDGROUP "groupadd"
  #define NULLDEVICE "/dev/null"
#elif defined USE_HPUX
  #define NOBODY "nobody"
  #define ADDUSER "useradd"
  #define ADDGROUP "groupadd"
  #define NULLDEVICE "/dev/null"
#else
  /* Default defines */
  #define NOBODY "nobody"
  #define ADDUSER "useradd"
  #define ADDGROUP "groupadd"
  #define NULLDEVICE "/dev/null"
#endif
