<?php
$regexpLines = array();
if (php_sapi_name() == 'cli') {
    $illegalFunctions = array();
    $illegalFunctions[] = 'aggregate';                                     // >=4.2.0
    $illegalFunctions[] = 'aggregate_methods';                             // >=4.2.0
    $illegalFunctions[] = 'aggregate_methods_by_list';                     // >=4.2.0
    $illegalFunctions[] = 'aggregate_methods_by_regexp';                   // >=4.2.0
    $illegalFunctions[] = 'aggregate_properties';                          // >=4.2.0
    $illegalFunctions[] = 'aggregate_properties_by_list';                  // >=4.2.0
    $illegalFunctions[] = 'aggregate_properties_by_regexp';                // >=4.2.0
    $illegalFunctions[] = 'aggregation_info';                              // >=4.2.0
    $illegalFunctions[] = 'apache_getenv';                                 // >=4.3.0
    $illegalFunctions[] = 'apache_get_modules';                            // >=4.3.2
    $illegalFunctions[] = 'apache_get_version';                            // >=4.3.2
    $illegalFunctions[] = 'apache_request_headers';                        // >=4.3.0
    $illegalFunctions[] = 'apache_response_headers';                       // >=4.3.0
    $illegalFunctions[] = 'apache_setenv';                                 // >=4.2.0
    $illegalFunctions[] = 'array_change_key_case';                         // >=4.2.0
    $illegalFunctions[] = 'array_chunk';                                   // >=4.2.0
    $illegalFunctions[] = 'array_diff_assoc';                              // >=4.3.0
    $illegalFunctions[] = 'array_fill';                                    // >=4.2.0
    $illegalFunctions[] = 'array_intersect_assoc';                         // >=4.3.0
    $illegalFunctions[] = 'bind_textdomain_codeset';                       // >=4.2.0
    $illegalFunctions[] = 'birdstep_autocommit';                           // >=4.2.0
    $illegalFunctions[] = 'birdstep_close';                                // >=4.2.0
    $illegalFunctions[] = 'birdstep_commit';                               // >=4.2.0
    $illegalFunctions[] = 'birdstep_connect';                              // >=4.2.0
    $illegalFunctions[] = 'birdstep_exec';                                 // >=4.2.0
    $illegalFunctions[] = 'birdstep_fetch';                                // >=4.2.0
    $illegalFunctions[] = 'birdstep_fieldname';                            // >=4.2.0
    $illegalFunctions[] = 'birdstep_fieldnum';                             // >=4.2.0
    $illegalFunctions[] = 'birdstep_freeresult';                           // >=4.2.0
    $illegalFunctions[] = 'birdstep_off_autocommit';                       // >=4.2.0
    $illegalFunctions[] = 'birdstep_result';                               // >=4.2.0
    $illegalFunctions[] = 'birdstep_rollback';                             // >=4.2.0
    $illegalFunctions[] = 'com_event_sink';                                // >=4.2.3
    $illegalFunctions[] = 'com_invoke_ex';                                 // >=4.3.0
    $illegalFunctions[] = 'com_message_pump';                              // >=4.2.3
    $illegalFunctions[] = 'com_print_typeinfo';                            // >=4.2.3
    $illegalFunctions[] = 'dba_handlers';                                  // >=4.3.0
    $illegalFunctions[] = 'dba_list';                                      // >=4.3.0
    $illegalFunctions[] = 'dbx_escape_string';                             // >=4.3.0
    $illegalFunctions[] = 'db_id_list';                                    // >=4.3.0
    $illegalFunctions[] = 'dcngettext';                                    // >=4.2.0
    $illegalFunctions[] = 'deaggregate';                                   // >=4.2.0
    $illegalFunctions[] = 'debug_backtrace';                               // >=4.3.0
    $illegalFunctions[] = 'debug_zval_dump';                               // >=4.2.0
    $illegalFunctions[] = 'dio_close';                                     // >=4.2.0
    $illegalFunctions[] = 'dio_fcntl';                                     // >=4.2.0
    $illegalFunctions[] = 'dio_open';                                      // >=4.2.0
    $illegalFunctions[] = 'dio_read';                                      // >=4.2.0
    $illegalFunctions[] = 'dio_seek';                                      // >=4.2.0
    $illegalFunctions[] = 'dio_stat';                                      // >=4.2.0
    $illegalFunctions[] = 'dio_tcsetattr';                                 // >=4.3.0
    $illegalFunctions[] = 'dio_truncate';                                  // >=4.2.0
    $illegalFunctions[] = 'dio_write';                                     // >=4.2.0
    $illegalFunctions[] = 'dngettext';                                     // >=4.2.0
    $illegalFunctions[] = 'domxml_doc_add_root';                           // >=4.3.0
    $illegalFunctions[] = 'domxml_doc_document_element';                   // >=4.3.0
    $illegalFunctions[] = 'domxml_doc_get_elements_by_tagname';            // >=4.2.1
    $illegalFunctions[] = 'domxml_doc_get_element_by_id';                  // >=4.2.1
    $illegalFunctions[] = 'domxml_doc_get_root';                           // >=4.3.0
    $illegalFunctions[] = 'domxml_doc_set_root';                           // >=4.3.0
    $illegalFunctions[] = 'domxml_doc_validate';                           // >=4.3.0
    $illegalFunctions[] = 'domxml_doc_xinclude';                           // >=4.3.0
    $illegalFunctions[] = 'domxml_dump_mem';                               // >=4.2.0
    $illegalFunctions[] = 'domxml_dump_mem_file';                          // >=4.2.0
    $illegalFunctions[] = 'domxml_dump_node';                              // >=4.2.0
    $illegalFunctions[] = 'domxml_html_dump_mem';                          // >=4.2.0
    $illegalFunctions[] = 'domxml_new_doc';                                // >=4.2.1
    $illegalFunctions[] = 'domxml_node_add_namespace';                     // >=4.3.0
    $illegalFunctions[] = 'domxml_node_get_content';                       // >=4.2.0
    $illegalFunctions[] = 'domxml_node_has_attributes';                    // >=4.2.0
    $illegalFunctions[] = 'domxml_node_set_namespace';                     // >=4.3.0
    $illegalFunctions[] = 'domxml_open_file';                              // >=4.2.1
    $illegalFunctions[] = 'domxml_open_mem';                               // >=4.2.1
    $illegalFunctions[] = 'domxml_parser';                                 // >=4.2.1
    $illegalFunctions[] = 'domxml_parser_add_chunk';                       // >=4.2.1
    $illegalFunctions[] = 'domxml_parser_cdata_section';                   // >=4.3.0
    $illegalFunctions[] = 'domxml_parser_characters';                      // >=4.3.0
    $illegalFunctions[] = 'domxml_parser_comment';                         // >=4.3.0
    $illegalFunctions[] = 'domxml_parser_end';                             // >=4.2.1
    $illegalFunctions[] = 'domxml_parser_end_document';                    // >=4.3.0
    $illegalFunctions[] = 'domxml_parser_end_element';                     // >=4.3.0
    $illegalFunctions[] = 'domxml_parser_entity_reference';                // >=4.3.0
    $illegalFunctions[] = 'domxml_parser_get_document';                    // >=4.3.0
    $illegalFunctions[] = 'domxml_parser_namespace_decl';                  // >=4.3.0
    $illegalFunctions[] = 'domxml_parser_processing_instruction';          // >=4.3.0
    $illegalFunctions[] = 'domxml_parser_start_document';                  // >=4.3.0
    $illegalFunctions[] = 'domxml_parser_start_element';                   // >=4.3.0
    $illegalFunctions[] = 'domxml_substitute_entities_default';            // >=4.2.0
    $illegalFunctions[] = 'domxml_xmltree';                                // >=4.2.1
    $illegalFunctions[] = 'domxml_xslt_process';                           // >=4.2.0
    $illegalFunctions[] = 'domxml_xslt_result_dump_file';                  // >=4.3.0
    $illegalFunctions[] = 'domxml_xslt_result_dump_mem';                   // >=4.3.0
    $illegalFunctions[] = 'domxml_xslt_stylesheet';                        // >=4.2.0
    $illegalFunctions[] = 'domxml_xslt_stylesheet_doc';                    // >=4.2.0
    $illegalFunctions[] = 'domxml_xslt_stylesheet_file';                   // >=4.2.0
    $illegalFunctions[] = 'domxml_xslt_version';                           // >=4.2.0
    $illegalFunctions[] = 'exif_imagetype';                                // >=4.3.0
    $illegalFunctions[] = 'exif_read_data';                                // >=4.2.0
    $illegalFunctions[] = 'exif_tagname';                                  // >=4.2.0
    $illegalFunctions[] = 'exif_thumbnail';                                // >=4.2.0
    $illegalFunctions[] = 'fbsql_blob_size';                               // >=4.2.0
    $illegalFunctions[] = 'fbsql_clob_size';                               // >=4.2.0
    $illegalFunctions[] = 'fbsql_create_blob';                             // >=4.2.0
    $illegalFunctions[] = 'fbsql_create_clob';                             // >=4.2.0
    $illegalFunctions[] = 'fbsql_read_blob';                               // >=4.2.0
    $illegalFunctions[] = 'fbsql_read_clob';                               // >=4.2.0
    $illegalFunctions[] = 'fbsql_set_lob_mode';                            // >=4.2.0
    $illegalFunctions[] = 'fbsql_set_transaction';                         // >=4.2.0
    $illegalFunctions[] = 'fbsql_tablename';                               // >=4.2.0
    $illegalFunctions[] = 'fbsql_table_name';                              // >=4.2.0
    $illegalFunctions[] = 'fdf_add_doc_javascript';                        // >=4.3.0
    $illegalFunctions[] = 'fdf_enum_values';                               // >=4.3.0
    $illegalFunctions[] = 'fdf_errno';                                     // >=4.3.0
    $illegalFunctions[] = 'fdf_error';                                     // >=4.3.0
    $illegalFunctions[] = 'fdf_get_ap';                                    // >=4.3.0
    $illegalFunctions[] = 'fdf_get_attachment';                            // >=4.3.0
    $illegalFunctions[] = 'fdf_get_encoding';                              // >=4.3.0
    $illegalFunctions[] = 'fdf_get_flags';                                 // >=4.3.0
    $illegalFunctions[] = 'fdf_get_opt';                                   // >=4.3.0
    $illegalFunctions[] = 'fdf_get_version';                               // >=4.3.0
    $illegalFunctions[] = 'fdf_header';                                    // >=4.3.0
    $illegalFunctions[] = 'fdf_open_string';                               // >=4.3.0
    $illegalFunctions[] = 'fdf_remove_item';                               // >=4.3.0
    $illegalFunctions[] = 'fdf_save_string';                               // >=4.3.0
    $illegalFunctions[] = 'fdf_set_on_import_javascript';                  // >=4.3.0
    $illegalFunctions[] = 'fdf_set_target_frame';                          // >=4.3.0
    $illegalFunctions[] = 'fdf_set_version';                               // >=4.3.0
    $illegalFunctions[] = 'file_get_contents';                             // >=4.3.0
    $illegalFunctions[] = 'floatval';                                      // >=4.2.0
    $illegalFunctions[] = 'fmod';                                          // >=4.2.0
    $illegalFunctions[] = 'fnmatch';                                       // >=4.3.0
    $illegalFunctions[] = 'fribidi_charset_info';                          // >=4.3.0
    $illegalFunctions[] = 'fribidi_get_charsets';                          // >=4.3.0
    $illegalFunctions[] = 'ftok';                                          // >=4.2.0
    $illegalFunctions[] = 'ftp_close';                                     // >=4.2.0
    $illegalFunctions[] = 'ftp_get_option';                                // >=4.2.0
    $illegalFunctions[] = 'ftp_nb_continue';                               // >=4.3.0
    $illegalFunctions[] = 'ftp_nb_fget';                                   // >=4.3.0
    $illegalFunctions[] = 'ftp_nb_fput';                                   // >=4.3.0
    $illegalFunctions[] = 'ftp_nb_get';                                    // >=4.3.0
    $illegalFunctions[] = 'ftp_nb_put';                                    // >=4.3.0
    $illegalFunctions[] = 'ftp_set_option';                                // >=4.2.0
    $illegalFunctions[] = 'ftp_ssl_connect';                               // >=4.3.0
    $illegalFunctions[] = 'gd_info';                                       // >=4.3.0
    $illegalFunctions[] = 'getopt';                                        // >=4.3.0
    $illegalFunctions[] = 'get_include_path';                              // >=4.3.0
    $illegalFunctions[] = 'glob';                                          // >=4.3.0
    $illegalFunctions[] = 'html_doc';                                      // >=4.2.0
    $illegalFunctions[] = 'html_doc_file';                                 // >=4.2.0
    $illegalFunctions[] = 'html_entity_decode';                            // >=4.3.0
    $illegalFunctions[] = 'ibase_add_user';                                // >=4.2.0
    $illegalFunctions[] = 'ibase_delete_user';                             // >=4.2.0
    $illegalFunctions[] = 'ibase_fetch_assoc';                             // >=4.3.0
    $illegalFunctions[] = 'ibase_modify_user';                             // >=4.2.0
    $illegalFunctions[] = 'imageantialias';                                // >=4.3.2
    $illegalFunctions[] = 'imagecolorallocatealpha';                       // >=4.3.2
    $illegalFunctions[] = 'imagecolormatch';                               // >=4.3.0
    $illegalFunctions[] = 'imageistruecolor';                              // >=4.3.2
    $illegalFunctions[] = 'imagelayereffect';                              // >=4.3.0
    $illegalFunctions[] = 'imagerotate';                                   // >=4.3.0
    $illegalFunctions[] = 'imagesavealpha';                                // >=4.3.2
    $illegalFunctions[] = 'image_type_to_mime_type';                       // >=4.3.0
    $illegalFunctions[] = 'imap_get_quotaroot';                            // >=4.3.0
    $illegalFunctions[] = 'imap_timeout';                                  // >=4.3.3
    $illegalFunctions[] = 'ini_get_all';                                   // >=4.2.0
    $illegalFunctions[] = 'ircg_eval_ecmascript_params';                   // >=4.3.0
    $illegalFunctions[] = 'ircg_invite';                                   // >=4.3.3
    $illegalFunctions[] = 'ircg_list';                                     // >=4.3.3
    $illegalFunctions[] = 'ircg_lusers';                                   // >=4.3.3
    $illegalFunctions[] = 'ircg_names';                                    // >=4.3.3
    $illegalFunctions[] = 'ircg_oper';                                     // >=4.3.3
    $illegalFunctions[] = 'ircg_set_file';                                 // >=4.2.0
    $illegalFunctions[] = 'ircg_set_on_die';                               // >=4.2.0
    $illegalFunctions[] = 'ircg_who';                                      // >=4.3.3
    $illegalFunctions[] = 'is_a';                                          // >=4.2.0
    $illegalFunctions[] = 'is_finite';                                     // >=4.2.0
    $illegalFunctions[] = 'is_infinite';                                   // >=4.2.0
    $illegalFunctions[] = 'is_nan';                                        // >=4.2.0
    $illegalFunctions[] = 'ldap_set_rebind_proc';                          // >=4.2.0
    $illegalFunctions[] = 'ldap_sort';                                     // >=4.2.0
    $illegalFunctions[] = 'ldap_start_tls';                                // >=4.2.0
    $illegalFunctions[] = 'mbereg';                                        // >=4.2.0
    $illegalFunctions[] = 'mberegi';                                       // >=4.2.0
    $illegalFunctions[] = 'mberegi_replace';                               // >=4.2.0
    $illegalFunctions[] = 'mbereg_match';                                  // >=4.2.0
    $illegalFunctions[] = 'mbereg_replace';                                // >=4.2.0
    $illegalFunctions[] = 'mbereg_search';                                 // >=4.2.0
    $illegalFunctions[] = 'mbereg_search_getpos';                          // >=4.2.0
    $illegalFunctions[] = 'mbereg_search_getregs';                         // >=4.2.0
    $illegalFunctions[] = 'mbereg_search_init';                            // >=4.2.0
    $illegalFunctions[] = 'mbereg_search_pos';                             // >=4.2.0
    $illegalFunctions[] = 'mbereg_search_regs';                            // >=4.2.0
    $illegalFunctions[] = 'mbereg_search_setpos';                          // >=4.2.0
    $illegalFunctions[] = 'mbregex_encoding';                              // >=4.2.0
    $illegalFunctions[] = 'mbsplit';                                       // >=4.2.0
    $illegalFunctions[] = 'mb_convert_case';                               // >=4.3.0
    $illegalFunctions[] = 'mb_ereg';                                       // >=4.2.0
    $illegalFunctions[] = 'mb_eregi';                                      // >=4.2.0
    $illegalFunctions[] = 'mb_eregi_replace';                              // >=4.2.0
    $illegalFunctions[] = 'mb_ereg_match';                                 // >=4.2.0
    $illegalFunctions[] = 'mb_ereg_replace';                               // >=4.2.0
    $illegalFunctions[] = 'mb_ereg_search';                                // >=4.2.0
    $illegalFunctions[] = 'mb_ereg_search_getpos';                         // >=4.2.0
    $illegalFunctions[] = 'mb_ereg_search_getregs';                        // >=4.2.0
    $illegalFunctions[] = 'mb_ereg_search_init';                           // >=4.2.0
    $illegalFunctions[] = 'mb_ereg_search_pos';                            // >=4.2.0
    $illegalFunctions[] = 'mb_ereg_search_regs';                           // >=4.2.0
    $illegalFunctions[] = 'mb_ereg_search_setpos';                         // >=4.2.0
    $illegalFunctions[] = 'mb_get_info';                                   // >=4.2.0
    $illegalFunctions[] = 'mb_regex_encoding';                             // >=4.2.0
    $illegalFunctions[] = 'mb_regex_set_options';                          // >=4.3.0
    $illegalFunctions[] = 'mb_split';                                      // >=4.2.0
    $illegalFunctions[] = 'mb_strtolower';                                 // >=4.3.0
    $illegalFunctions[] = 'mb_strtoupper';                                 // >=4.3.0
    $illegalFunctions[] = 'mb_substr_count';                               // >=4.3.0
    $illegalFunctions[] = 'mcrypt_generic_deinit';                         // >=4.1.1
    $illegalFunctions[] = 'mcve_adduser';                                  // >=4.2.0
    $illegalFunctions[] = 'mcve_adduserarg';                               // >=4.2.0
    $illegalFunctions[] = 'mcve_bt';                                       // >=4.2.0
    $illegalFunctions[] = 'mcve_checkstatus';                              // >=4.2.0
    $illegalFunctions[] = 'mcve_chkpwd';                                   // >=4.2.0
    $illegalFunctions[] = 'mcve_chngpwd';                                  // >=4.2.0
    $illegalFunctions[] = 'mcve_completeauthorizations';                   // >=4.2.0
    $illegalFunctions[] = 'mcve_connect';                                  // >=4.2.0
    $illegalFunctions[] = 'mcve_connectionerror';                          // >=4.3.0
    $illegalFunctions[] = 'mcve_deleteresponse';                           // >=4.2.0
    $illegalFunctions[] = 'mcve_deletetrans';                              // >=4.3.0
    $illegalFunctions[] = 'mcve_deleteusersetup';                          // >=4.2.0
    $illegalFunctions[] = 'mcve_deluser';                                  // >=4.2.0
    $illegalFunctions[] = 'mcve_destroyconn';                              // >=4.2.0
    $illegalFunctions[] = 'mcve_destroyengine';                            // >=4.2.0
    $illegalFunctions[] = 'mcve_disableuser';                              // >=4.2.0
    $illegalFunctions[] = 'mcve_edituser';                                 // >=4.2.0
    $illegalFunctions[] = 'mcve_enableuser';                               // >=4.2.0
    $illegalFunctions[] = 'mcve_force';                                    // >=4.2.0
    $illegalFunctions[] = 'mcve_getcell';                                  // >=4.2.0
    $illegalFunctions[] = 'mcve_getcellbynum';                             // >=4.2.0
    $illegalFunctions[] = 'mcve_getcommadelimited';                        // >=4.2.0
    $illegalFunctions[] = 'mcve_getheader';                                // >=4.2.0
    $illegalFunctions[] = 'mcve_getuserarg';                               // >=4.2.0
    $illegalFunctions[] = 'mcve_getuserparam';                             // >=4.3.0
    $illegalFunctions[] = 'mcve_gft';                                      // >=4.2.0
    $illegalFunctions[] = 'mcve_gl';                                       // >=4.2.0
    $illegalFunctions[] = 'mcve_gut';                                      // >=4.2.0
    $illegalFunctions[] = 'mcve_initconn';                                 // >=4.2.0
    $illegalFunctions[] = 'mcve_initengine';                               // >=4.2.0
    $illegalFunctions[] = 'mcve_initusersetup';                            // >=4.2.0
    $illegalFunctions[] = 'mcve_iscommadelimited';                         // >=4.2.0
    $illegalFunctions[] = 'mcve_liststats';                                // >=4.2.0
    $illegalFunctions[] = 'mcve_listusers';                                // >=4.2.0
    $illegalFunctions[] = 'mcve_maxconntimeout';                           // >=4.3.0
    $illegalFunctions[] = 'mcve_monitor';                                  // >=4.2.0
    $illegalFunctions[] = 'mcve_numcolumns';                               // >=4.2.0
    $illegalFunctions[] = 'mcve_numrows';                                  // >=4.2.0
    $illegalFunctions[] = 'mcve_override';                                 // >=4.2.0
    $illegalFunctions[] = 'mcve_parsecommadelimited';                      // >=4.2.0
    $illegalFunctions[] = 'mcve_ping';                                     // >=4.3.0
    $illegalFunctions[] = 'mcve_preauth';                                  // >=4.2.0
    $illegalFunctions[] = 'mcve_preauthcompletion';                        // >=4.2.0
    $illegalFunctions[] = 'mcve_qc';                                       // >=4.2.0
    $illegalFunctions[] = 'mcve_responseparam';                            // >=4.3.0
    $illegalFunctions[] = 'mcve_return';                                   // >=4.2.0
    $illegalFunctions[] = 'mcve_returncode';                               // >=4.2.0
    $illegalFunctions[] = 'mcve_returnstatus';                             // >=4.2.0
    $illegalFunctions[] = 'mcve_sale';                                     // >=4.2.0
    $illegalFunctions[] = 'mcve_setblocking';                              // >=4.3.0
    $illegalFunctions[] = 'mcve_setdropfile';                              // >=4.2.0
    $illegalFunctions[] = 'mcve_setip';                                    // >=4.2.0
    $illegalFunctions[] = 'mcve_setssl';                                   // >=4.2.0
    $illegalFunctions[] = 'mcve_setssl_files';                             // >=4.3.3
    $illegalFunctions[] = 'mcve_settimeout';                               // >=4.2.0
    $illegalFunctions[] = 'mcve_settle';                                   // >=4.2.0
    $illegalFunctions[] = 'mcve_text_avs';                                 // >=4.3.0
    $illegalFunctions[] = 'mcve_text_code';                                // >=4.3.0
    $illegalFunctions[] = 'mcve_text_cv';                                  // >=4.3.0
    $illegalFunctions[] = 'mcve_transactionauth';                          // >=4.2.0
    $illegalFunctions[] = 'mcve_transactionavs';                           // >=4.2.0
    $illegalFunctions[] = 'mcve_transactionbatch';                         // >=4.2.0
    $illegalFunctions[] = 'mcve_transactioncv';                            // >=4.2.0
    $illegalFunctions[] = 'mcve_transactionid';                            // >=4.2.0
    $illegalFunctions[] = 'mcve_transactionitem';                          // >=4.2.0
    $illegalFunctions[] = 'mcve_transactionssent';                         // >=4.2.0
    $illegalFunctions[] = 'mcve_transactiontext';                          // >=4.2.0
    $illegalFunctions[] = 'mcve_transinqueue';                             // >=4.2.0
    $illegalFunctions[] = 'mcve_transnew';                                 // >=4.3.0
    $illegalFunctions[] = 'mcve_transparam';                               // >=4.3.0
    $illegalFunctions[] = 'mcve_transsend';                                // >=4.3.0
    $illegalFunctions[] = 'mcve_ub';                                       // >=4.2.0
    $illegalFunctions[] = 'mcve_uwait';                                    // >=4.3.0
    $illegalFunctions[] = 'mcve_verifyconnection';                         // >=4.3.0
    $illegalFunctions[] = 'mcve_verifysslcert';                            // >=4.3.0
    $illegalFunctions[] = 'mcve_void';                                     // >=4.2.0
    $illegalFunctions[] = 'md5_file';                                      // >=4.2.0
    $illegalFunctions[] = 'memory_get_usage';                              // >=4.3.2
    $illegalFunctions[] = 'mime_content_type';                             // >=4.3.0
    $illegalFunctions[] = 'ming_useswfversion';                            // >=4.2.0
    $illegalFunctions[] = 'money_format';                                  // >=4.3.0
    $illegalFunctions[] = 'msession_call';                                 // >=4.2.0
    $illegalFunctions[] = 'msession_connect';                              // >=4.2.0
    $illegalFunctions[] = 'msession_count';                                // >=4.2.0
    $illegalFunctions[] = 'msession_create';                               // >=4.2.0
    $illegalFunctions[] = 'msession_ctl';                                  // >=4.3.0
    $illegalFunctions[] = 'msession_destroy';                              // >=4.2.0
    $illegalFunctions[] = 'msession_disconnect';                           // >=4.2.0
    $illegalFunctions[] = 'msession_find';                                 // >=4.2.0
    $illegalFunctions[] = 'msession_get';                                  // >=4.2.0
    $illegalFunctions[] = 'msession_get_array';                            // >=4.2.0
    $illegalFunctions[] = 'msession_get_data';                             // >=4.2.0
    $illegalFunctions[] = 'msession_inc';                                  // >=4.2.0
    $illegalFunctions[] = 'msession_list';                                 // >=4.2.0
    $illegalFunctions[] = 'msession_listvar';                              // >=4.2.0
    $illegalFunctions[] = 'msession_lock';                                 // >=4.2.0
    $illegalFunctions[] = 'msession_plugin';                               // >=4.2.0
    $illegalFunctions[] = 'msession_randstr';                              // >=4.2.0
    $illegalFunctions[] = 'msession_set';                                  // >=4.2.0
    $illegalFunctions[] = 'msession_set_array';                            // >=4.2.0
    $illegalFunctions[] = 'msession_set_data';                             // >=4.2.0
    $illegalFunctions[] = 'msession_timeout';                              // >=4.2.0
    $illegalFunctions[] = 'msession_uniq';                                 // >=4.2.0
    $illegalFunctions[] = 'msession_unlock';                               // >=4.2.0
    $illegalFunctions[] = 'msg_get_queue';                                 // >=4.3.0
    $illegalFunctions[] = 'msg_receive';                                   // >=4.3.0
    $illegalFunctions[] = 'msg_remove_queue';                              // >=4.3.0
    $illegalFunctions[] = 'msg_send';                                      // >=4.3.0
    $illegalFunctions[] = 'msg_set_queue';                                 // >=4.3.0
    $illegalFunctions[] = 'msg_stat_queue';                                // >=4.3.0
    $illegalFunctions[] = 'mssql_deadlock_retry_count';                    // >=4.3.0
    $illegalFunctions[] = 'mssql_fetch_assoc';                             // >=4.2.0
    $illegalFunctions[] = 'mssql_free_statement';                          // >=4.3.2
    $illegalFunctions[] = 'mssql_set_message_handler';                     // >=4.3.0
    $illegalFunctions[] = 'mssql_unbuffered_query';                        // >=4.3.0
    $illegalFunctions[] = 'mysql_client_encoding';                         // >=4.3.0
    $illegalFunctions[] = 'mysql_info';                                    // >=4.3.0
    $illegalFunctions[] = 'mysql_list_processes';                          // >=4.3.0
    $illegalFunctions[] = 'mysql_ping';                                    // >=4.3.0
    $illegalFunctions[] = 'mysql_real_escape_string';                      // >=4.3.0
    $illegalFunctions[] = 'mysql_stat';                                    // >=4.3.0
    $illegalFunctions[] = 'mysql_table_name';                              // >=4.3.0
    $illegalFunctions[] = 'mysql_thread_id';                               // >=4.3.0
    $illegalFunctions[] = 'ncurses_addchnstr';                             // >=4.2.0
    $illegalFunctions[] = 'ncurses_addchstr';                              // >=4.2.0
    $illegalFunctions[] = 'ncurses_addnstr';                               // >=4.2.0
    $illegalFunctions[] = 'ncurses_addstr';                                // >=4.2.0
    $illegalFunctions[] = 'ncurses_assume_default_colors';                 // >=4.2.0
    $illegalFunctions[] = 'ncurses_border';                                // >=4.2.0
    $illegalFunctions[] = 'ncurses_bottom_panel';                          // >=4.3.0
    $illegalFunctions[] = 'ncurses_color_content';                         // >=4.3.0
    $illegalFunctions[] = 'ncurses_define_key';                            // >=4.2.0
    $illegalFunctions[] = 'ncurses_del_panel';                             // >=4.3.0
    $illegalFunctions[] = 'ncurses_getmaxyx';                              // >=4.3.0
    $illegalFunctions[] = 'ncurses_getmouse';                              // >=4.2.0
    $illegalFunctions[] = 'ncurses_getyx';                                 // >=4.3.0
    $illegalFunctions[] = 'ncurses_hide_panel';                            // >=4.3.0
    $illegalFunctions[] = 'ncurses_hline';                                 // >=4.2.0
    $illegalFunctions[] = 'ncurses_init_color';                            // >=4.2.0
    $illegalFunctions[] = 'ncurses_insstr';                                // >=4.2.0
    $illegalFunctions[] = 'ncurses_instr';                                 // >=4.2.0
    $illegalFunctions[] = 'ncurses_keyok';                                 // >=4.2.0
    $illegalFunctions[] = 'ncurses_keypad';                                // >=4.2.0
    $illegalFunctions[] = 'ncurses_longname';                              // >=4.2.0
    $illegalFunctions[] = 'ncurses_meta';                                  // >=4.3.0
    $illegalFunctions[] = 'ncurses_mousemask';                             // >=4.2.0
    $illegalFunctions[] = 'ncurses_mouse_trafo';                           // >=4.2.0
    $illegalFunctions[] = 'ncurses_move_panel';                            // >=4.3.0
    $illegalFunctions[] = 'ncurses_mvaddch';                               // >=4.2.0
    $illegalFunctions[] = 'ncurses_mvaddchnstr';                           // >=4.2.0
    $illegalFunctions[] = 'ncurses_mvaddchstr';                            // >=4.2.0
    $illegalFunctions[] = 'ncurses_mvaddnstr';                             // >=4.2.0
    $illegalFunctions[] = 'ncurses_mvaddstr';                              // >=4.2.0
    $illegalFunctions[] = 'ncurses_mvcur';                                 // >=4.2.0
    $illegalFunctions[] = 'ncurses_mvdelch';                               // >=4.2.0
    $illegalFunctions[] = 'ncurses_mvgetch';                               // >=4.2.0
    $illegalFunctions[] = 'ncurses_mvhline';                               // >=4.2.0
    $illegalFunctions[] = 'ncurses_mvinch';                                // >=4.2.0
    $illegalFunctions[] = 'ncurses_mvwaddstr';                             // >=4.2.0
    $illegalFunctions[] = 'ncurses_newpad';                                // >=4.3.0
    $illegalFunctions[] = 'ncurses_new_panel';                             // >=4.3.0
    $illegalFunctions[] = 'ncurses_pair_content';                          // >=4.3.0
    $illegalFunctions[] = 'ncurses_panel_above';                           // >=4.3.0
    $illegalFunctions[] = 'ncurses_panel_below';                           // >=4.3.0
    $illegalFunctions[] = 'ncurses_panel_window';                          // >=4.3.0
    $illegalFunctions[] = 'ncurses_pnoutrefresh';                          // >=4.3.0
    $illegalFunctions[] = 'ncurses_prefresh';                              // >=4.3.0
    $illegalFunctions[] = 'ncurses_putp';                                  // >=4.2.0
    $illegalFunctions[] = 'ncurses_replace_panel';                         // >=4.3.0
    $illegalFunctions[] = 'ncurses_reset_prog_mode';                       // >=4.3.0
    $illegalFunctions[] = 'ncurses_reset_shell_mode';                      // >=4.3.0
    $illegalFunctions[] = 'ncurses_scr_dump';                              // >=4.2.0
    $illegalFunctions[] = 'ncurses_scr_init';                              // >=4.2.0
    $illegalFunctions[] = 'ncurses_scr_restore';                           // >=4.2.0
    $illegalFunctions[] = 'ncurses_scr_set';                               // >=4.2.0
    $illegalFunctions[] = 'ncurses_show_panel';                            // >=4.3.0
    $illegalFunctions[] = 'ncurses_slk_set';                               // >=4.2.0
    $illegalFunctions[] = 'ncurses_termname';                              // >=4.2.0
    $illegalFunctions[] = 'ncurses_top_panel';                             // >=4.3.0
    $illegalFunctions[] = 'ncurses_ungetmouse';                            // >=4.2.0
    $illegalFunctions[] = 'ncurses_update_panels';                         // >=4.3.0
    $illegalFunctions[] = 'ncurses_vline';                                 // >=4.2.0
    $illegalFunctions[] = 'ncurses_waddch';                                // >=4.3.0
    $illegalFunctions[] = 'ncurses_waddstr';                               // >=4.2.0
    $illegalFunctions[] = 'ncurses_wattroff';                              // >=4.3.0
    $illegalFunctions[] = 'ncurses_wattron';                               // >=4.3.0
    $illegalFunctions[] = 'ncurses_wattrset';                              // >=4.3.0
    $illegalFunctions[] = 'ncurses_wborder';                               // >=4.3.0
    $illegalFunctions[] = 'ncurses_wclear';                                // >=4.2.0
    $illegalFunctions[] = 'ncurses_wcolor_set';                            // >=4.2.0
    $illegalFunctions[] = 'ncurses_werase';                                // >=4.3.0
    $illegalFunctions[] = 'ncurses_wgetch';                                // >=4.2.0
    $illegalFunctions[] = 'ncurses_whline';                                // >=4.3.0
    $illegalFunctions[] = 'ncurses_wmouse_trafo';                          // >=4.2.0
    $illegalFunctions[] = 'ncurses_wmove';                                 // >=4.2.0
    $illegalFunctions[] = 'ncurses_wnoutrefresh';                          // >=4.2.0
    $illegalFunctions[] = 'ncurses_wrefresh';                              // >=4.2.0
    $illegalFunctions[] = 'ncurses_wstandend';                             // >=4.3.0
    $illegalFunctions[] = 'ncurses_wstandout';                             // >=4.3.0
    $illegalFunctions[] = 'ncurses_wvline';                                // >=4.3.0
    $illegalFunctions[] = 'ngettext';                                      // >=4.2.0
    $illegalFunctions[] = 'nsapi_request_headers';                         // >=4.3.3
    $illegalFunctions[] = 'nsapi_response_headers';                        // >=4.3.3
    $illegalFunctions[] = 'nsapi_virtual';                                 // >=4.3.3
    $illegalFunctions[] = 'ob_clean';                                      // >=4.2.0
    $illegalFunctions[] = 'ob_flush';                                      // >=4.2.0
    $illegalFunctions[] = 'ob_get_clean';                                  // >=4.3.0
    $illegalFunctions[] = 'ob_get_flush';                                  // >=4.3.0
    $illegalFunctions[] = 'ob_get_level';                                  // >=4.2.0
    $illegalFunctions[] = 'ob_get_status';                                 // >=4.2.0
    $illegalFunctions[] = 'ob_list_handlers';                              // >=4.3.0
    $illegalFunctions[] = 'ocipasswordchange';                             // >=4.3.2
    $illegalFunctions[] = 'odbc_data_source';                              // >=4.3.0
    $illegalFunctions[] = 'openssl_csr_export';                            // >=4.2.0
    $illegalFunctions[] = 'openssl_csr_export_to_file';                    // >=4.2.0
    $illegalFunctions[] = 'openssl_csr_new';                               // >=4.2.0
    $illegalFunctions[] = 'openssl_csr_sign';                              // >=4.2.0
    $illegalFunctions[] = 'openssl_pkey_export';                           // >=4.2.0
    $illegalFunctions[] = 'openssl_pkey_export_to_file';                   // >=4.2.0
    $illegalFunctions[] = 'openssl_pkey_free';                             // >=4.2.0
    $illegalFunctions[] = 'openssl_pkey_get_private';                      // >=4.2.0
    $illegalFunctions[] = 'openssl_pkey_get_public';                       // >=4.2.0
    $illegalFunctions[] = 'openssl_pkey_new';                              // >=4.2.0
    $illegalFunctions[] = 'openssl_x509_check_private_key';                // >=4.2.0
    $illegalFunctions[] = 'openssl_x509_export';                           // >=4.2.0
    $illegalFunctions[] = 'openssl_x509_export_to_file';                   // >=4.2.0
    $illegalFunctions[] = 'output_add_rewrite_var';                        // >=4.3.0
    $illegalFunctions[] = 'output_reset_rewrite_vars';                     // >=4.3.0
    $illegalFunctions[] = 'overload';                                      // >=4.2.0
    $illegalFunctions[] = 'pcntl_alarm';                                   // >=4.3.0
    $illegalFunctions[] = 'pcntl_exec';                                    // >=4.2.0
    $illegalFunctions[] = 'pdf_get_majorversion';                          // >=4.2.0
    $illegalFunctions[] = 'pdf_get_minorversion';                          // >=4.2.0
    $illegalFunctions[] = 'pg_affected_rows';                              // >=4.2.0
    $illegalFunctions[] = 'pg_cancel_query';                               // >=4.2.0
    $illegalFunctions[] = 'pg_connection_busy';                            // >=4.2.0
    $illegalFunctions[] = 'pg_connection_reset';                           // >=4.2.0
    $illegalFunctions[] = 'pg_connection_status';                          // >=4.2.0
    $illegalFunctions[] = 'pg_convert';                                    // >=4.3.0
    $illegalFunctions[] = 'pg_copy_from';                                  // >=4.2.0
    $illegalFunctions[] = 'pg_copy_to';                                    // >=4.2.0
    $illegalFunctions[] = 'pg_delete';                                     // >=4.3.0
    $illegalFunctions[] = 'pg_escape_bytea';                               // >=4.2.0
    $illegalFunctions[] = 'pg_escape_string';                              // >=4.2.0
    $illegalFunctions[] = 'pg_fetch_all';                                  // >=4.3.0
    $illegalFunctions[] = 'pg_fetch_assoc';                                // >=4.3.0
    $illegalFunctions[] = 'pg_fetch_result';                               // >=4.2.0
    $illegalFunctions[] = 'pg_field_is_null';                              // >=4.2.0
    $illegalFunctions[] = 'pg_field_name';                                 // >=4.2.0
    $illegalFunctions[] = 'pg_field_num';                                  // >=4.2.0
    $illegalFunctions[] = 'pg_field_prtlen';                               // >=4.2.0
    $illegalFunctions[] = 'pg_field_size';                                 // >=4.2.0
    $illegalFunctions[] = 'pg_field_type';                                 // >=4.2.0
    $illegalFunctions[] = 'pg_free_result';                                // >=4.2.0
    $illegalFunctions[] = 'pg_get_notify';                                 // >=4.3.0
    $illegalFunctions[] = 'pg_get_pid';                                    // >=4.3.0
    $illegalFunctions[] = 'pg_get_result';                                 // >=4.2.0
    $illegalFunctions[] = 'pg_insert';                                     // >=4.3.0
    $illegalFunctions[] = 'pg_last_error';                                 // >=4.2.0
    $illegalFunctions[] = 'pg_last_oid';                                   // >=4.2.0
    $illegalFunctions[] = 'pg_lo_close';                                   // >=4.2.0
    $illegalFunctions[] = 'pg_lo_create';                                  // >=4.2.0
    $illegalFunctions[] = 'pg_lo_export';                                  // >=4.2.0
    $illegalFunctions[] = 'pg_lo_import';                                  // >=4.2.0
    $illegalFunctions[] = 'pg_lo_open';                                    // >=4.2.0
    $illegalFunctions[] = 'pg_lo_read';                                    // >=4.2.0
    $illegalFunctions[] = 'pg_lo_read_all';                                // >=4.2.0
    $illegalFunctions[] = 'pg_lo_seek';                                    // >=4.2.0
    $illegalFunctions[] = 'pg_lo_tell';                                    // >=4.2.0
    $illegalFunctions[] = 'pg_lo_unlink';                                  // >=4.2.0
    $illegalFunctions[] = 'pg_lo_write';                                   // >=4.2.0
    $illegalFunctions[] = 'pg_meta_data';                                  // >=4.3.0
    $illegalFunctions[] = 'pg_num_fields';                                 // >=4.2.0
    $illegalFunctions[] = 'pg_num_rows';                                   // >=4.2.0
    $illegalFunctions[] = 'pg_ping';                                       // >=4.3.0
    $illegalFunctions[] = 'pg_query';                                      // >=4.2.0
    $illegalFunctions[] = 'pg_result_error';                               // >=4.2.0
    $illegalFunctions[] = 'pg_result_seek';                                // >=4.3.0
    $illegalFunctions[] = 'pg_result_status';                              // >=4.2.0
    $illegalFunctions[] = 'pg_select';                                     // >=4.3.0
    $illegalFunctions[] = 'pg_send_query';                                 // >=4.2.0
    $illegalFunctions[] = 'pg_unescape_bytea';                             // >=4.3.0
    $illegalFunctions[] = 'pg_update';                                     // >=4.3.0
    $illegalFunctions[] = 'php_ini_scanned_files';                         // >=4.3.0
    $illegalFunctions[] = 'posix_errno';                                   // >=4.2.0
    $illegalFunctions[] = 'posix_get_last_error';                          // >=4.2.0
    $illegalFunctions[] = 'posix_strerror';                                // >=4.2.0
    $illegalFunctions[] = 'proc_close';                                    // >=4.3.0
    $illegalFunctions[] = 'proc_open';                                     // >=4.3.0
    $illegalFunctions[] = 'restore_include_path';                          // >=4.3.0
    $illegalFunctions[] = 'session_cache_expire';                          // >=4.2.0
    $illegalFunctions[] = 'session_regenerate_id';                         // >=4.3.2
    $illegalFunctions[] = 'set_include_path';                              // >=4.3.0
    $illegalFunctions[] = 'sha1';                                          // >=4.3.0
    $illegalFunctions[] = 'sha1_file';                                     // >=4.3.0
    $illegalFunctions[] = 'snmp3_get';                                     // >=4.3.0
    $illegalFunctions[] = 'snmp3_real_walk';                               // >=4.3.0
    $illegalFunctions[] = 'snmp3_set';                                     // >=4.3.0
    $illegalFunctions[] = 'snmp3_walk';                                    // >=4.3.0
    $illegalFunctions[] = 'snmp_get_valueretrieval';                       // >=4.3.3
    $illegalFunctions[] = 'snmp_set_enum_print';                           // >=4.3.0
    $illegalFunctions[] = 'snmp_set_oid_numeric_print';                    // >=4.3.0
    $illegalFunctions[] = 'snmp_set_valueretrieval';                       // >=4.3.3
    $illegalFunctions[] = 'socket_clear_error';                            // >=4.2.0
    $illegalFunctions[] = 'socket_get_option';                             // >=4.3.0
    $illegalFunctions[] = 'socket_set_block';                              // >=4.2.0
    $illegalFunctions[] = 'socket_set_option';                             // >=4.3.0
    $illegalFunctions[] = 'stream_context_create';                         // >=4.3.0
    $illegalFunctions[] = 'stream_context_get_options';                    // >=4.3.0
    $illegalFunctions[] = 'stream_context_set_option';                     // >=4.3.0
    $illegalFunctions[] = 'stream_context_set_params';                     // >=4.3.0
    $illegalFunctions[] = 'stream_filter_append';                          // >=4.3.0
    $illegalFunctions[] = 'stream_filter_prepend';                         // >=4.3.0
    $illegalFunctions[] = 'stream_get_meta_data';                          // >=4.3.0
    $illegalFunctions[] = 'stream_register_wrapper';                       // >=4.3.0
    $illegalFunctions[] = 'stream_select';                                 // >=4.3.0
    $illegalFunctions[] = 'stream_set_blocking';                           // >=4.3.0
    $illegalFunctions[] = 'stream_set_timeout';                            // >=4.3.0
    $illegalFunctions[] = 'stream_set_write_buffer';                       // >=4.3.0
    $illegalFunctions[] = 'stream_wrapper_register';                       // >=4.3.2
    $illegalFunctions[] = 'str_rot13';                                     // >=4.2.0
    $illegalFunctions[] = 'str_shuffle';                                   // >=4.3.0
    $illegalFunctions[] = 'str_word_count';                                // >=4.3.0
    $illegalFunctions[] = 'sybase_deadlock_retry_count';                   // >=4.3.0
    $illegalFunctions[] = 'sybase_fetch_assoc';                            // >=4.3.0
    $illegalFunctions[] = 'sybase_set_message_handler';                    // >=4.3.0
    $illegalFunctions[] = 'sybase_unbuffered_query';                       // >=4.3.0
    $illegalFunctions[] = 'token_get_all';                                 // >=4.2.0
    $illegalFunctions[] = 'token_name';                                    // >=4.2.0
    $illegalFunctions[] = 'udm_alloc_agent_array';                         // >=4.3.3
    $illegalFunctions[] = 'udm_check_charset';                             // >=4.2.0
    $illegalFunctions[] = 'udm_check_stored';                              // >=4.2.0
    $illegalFunctions[] = 'udm_close_stored';                              // >=4.2.0
    $illegalFunctions[] = 'udm_crc32';                                     // >=4.2.0
    $illegalFunctions[] = 'udm_get_res_field_ex';                          // >=4.3.3
    $illegalFunctions[] = 'udm_hash32';                                    // >=4.3.3
    $illegalFunctions[] = 'udm_make_excerpt';                              // >=4.3.0
    $illegalFunctions[] = 'udm_open_stored';                               // >=4.2.0
    $illegalFunctions[] = 'udm_parse_query_string';                        // >=4.3.0
    $illegalFunctions[] = 'udm_set_agent_param_ex';                        // >=4.3.3
    $illegalFunctions[] = 'var_export';                                    // >=4.2.0
    $illegalFunctions[] = 'xmlrpc_is_fault';                               // >=4.3.0
    $illegalFunctions[] = 'xpath_register_ns';                             // >=4.2.0
    $illegalFunctions[] = 'xslt_backend_info';                             // >=4.3.0
    $illegalFunctions[] = 'xslt_backend_name';                             // >=4.3.0
    $illegalFunctions[] = 'xslt_backend_version';                          // >=4.3.0
    $illegalFunctions[] = 'xslt_getopt';                                   // >=4.3.0
    $illegalFunctions[] = 'xslt_setopt';                                   // >=4.3.0
    $illegalFunctions[] = 'xslt_set_object';                               // >=4.3.0
    $illegalFunctions[] = 'yaz_es_result';                                 // >=4.2.0
    $illegalFunctions[] = 'yaz_schema';                                    // >=4.2.0
    $illegalFunctions[] = 'zlib_get_coding_type';                          // >=4.3.2

    // Spit out some Perl that will generate an optimized Regexp out of our function list
    $regexpLines[] = 'use Regexp::Optimizer;';
    $regexpLines[] = 'my $o = Regexp::Optimizer->new;';
    $regexpLines[] = sprintf('my $re = $o->list2re(qw/%s/);', join(' ', $illegalFunctions));
    $regexpLines[] = 'print "\$illegalFunctionsRegexp = \"/\\\\b$re\\\\s*\\\(/\";";';
    print(join("\n", $regexpLines));
}

// Result of running Perl Regexp::Optimizer on our function list
// Generate this line by doing:
//   php Php41IllegalFunctions.inc > func.pl && perl func.pl > func.out
$illegalFunctionsRegexp = "/\b(?-xism:(?:a(?:ggregat(?:e(?:_(?:methods(?:_by_(?:list|regexp))?|properties(?:_by_(?:list|regexp))?))?|ion_info)|pache_(?:get(?:_(?:modules|version)|env)|re(?:quest|sponse)_headers|setenv)|rray_(?:ch(?:ange_key_case|unk)|(?:diff|intersect)_assoc|fill))|bi(?:rdstep_(?:c(?:o(?:mmi|nnec)t|lose)|f(?:ieldn(?:ame|um)|etch|reeresult)|r(?:esult|ollback)|(?:off_)?autocommit|exec)|nd_textdomain_codeset)|com_(?:event_sink|invoke_ex|message_pump|print_typeinfo)|d(?:b(?:a_(?:handlers|list)|x_escape_string|_id_list)|e(?:bug_(?:backtrace|zval_dump)|aggregate)|io_(?:s(?:eek|tat)|t(?:csetattr|runcate)|(?:clos|writ)e|fcntl|open|read)|omxml_(?:d(?:oc_(?:get_(?:element(?:s_by_tagname|_by_id)|root)|(?:(?:add|set)_roo|document_elemen)t|(?:validat|xinclud)e)|ump_(?:mem(?:_file)?|node))|n(?:ode_(?:(?:add|set)_namespace|get_content|has_attributes)|ew_doc)|open_(?:file|mem)|parser(?:_(?:c(?:data_section|haracters|omment)|en(?:d(?:_(?:docu|ele)ment)?|tity_reference)|start_(?:docu|ele)ment|add_chunk|get_document|namespace_decl|processing_instruction))?|x(?:slt_(?:result_dump_(?:file|mem)|stylesheet(?:_(?:doc|file))?|process|version)|mltree)|html_dump_mem|substitute_entities_default)|c?ngettext)|exif_(?:t(?:agname|humbnail)|imagetype|read_data)|f(?:bsql_(?:c(?:reate_[bc]lob|lob_size)|read_[bc]lob|set_(?:lob_mode|transaction)|table_?name|blob_size)|df_(?:e(?:rr(?:no|or)|num_values)|get_(?:a(?:p|ttachment)|encoding|flags|opt|version)|s(?:et_(?:on_import_javascript|target_frame|version)|ave_string)|add_doc_javascript|header|open_string|remove_item)|ribidi_(?:charset_info|get_charsets)|t(?:p_(?:nb_(?:f(?:ge|pu)t|continue|(?:ge|pu)t)|s(?:et_option|sl_connect)|close|get_option)|ok)|ile_get_contents|loatval|mod|nmatch)|g(?:et(?:opt|_include_path)|d_info|lob)|html_(?:doc(?:_file)?|entity_decode)|i(?:base_(?:(?:add|delete|modify)_user|fetch_assoc)|ma(?:ge(?:color(?:allocatealpha|match)|antialias|istruecolor|layereffect|(?:rotat|_type_to_mime_typ)e|savealpha)|p_(?:get_quotaroo|timeou)t)|rcg_(?:l(?:ist|users)|set_(?:fil|on_di)e|(?:eval_ecmascript_param|name)s|invite|oper|who)|s_(?:a|(?:in)?finite|nan)|ni_get_all)|ldap_s(?:et_rebind_proc|ort|tart_tls)|m(?:b(?:ereg(?:i(?:_replace)?|_(?:search(?:_(?:get(?:po|reg)s|init|(?:(?:set)?po|reg)s))?|match|replace))?|_(?:ereg(?:i(?:_replace)?|_(?:search(?:_(?:get(?:po|reg)s|init|(?:(?:set)?po|reg)s))?|match|replace))?|regex_(?:encoding|set_options)|s(?:trto(?:low|upp)er|(?:pli|ubstr_coun)t)|convert_case|get_info)|regex_encoding|split)|c(?:ve_(?:adduser(?:arg)?|c(?:h(?:eckstatus|(?:k|ng)pwd)|o(?:nnect(?:ionerror)?|mpleteauthorizations))|d(?:e(?:l(?:ete(?:response|trans|usersetup)|user)|stroy(?:conn|engine))|isableuser)|e(?:dit|nable)user|g(?:et(?:c(?:ell(?:bynum)?|ommadelimited)|user(?:arg|param)|header)|[fu]t|l)|i(?:nit(?:conn|engine|usersetup)|scommadelimited)|list(?:stat|user)s|m(?:axconntimeout|onitor)|num(?:column|row)s|p(?:reauth(?:completion)?|arsecommadelimited|ing)|re(?:turn(?:code|status)?|sponseparam)|s(?:et(?:ssl(?:_files)?|t(?:imeout|le)|blocking|dropfile|ip)|ale)|t(?:ext_(?:c(?:ode|v)|avs)|rans(?:action(?:a(?:uth|vs)|i(?:d|tem)|batch|cv|(?:ssen|tex)t)|inqueue|new|param|send))|u(?:b|wait)|v(?:erify(?:connection|sslcert)|oid)|bt|(?:forc|overrid)e|qc)|rypt_generic_deinit)|i(?:me_content_type|ng_useswfversion)|s(?:ession_(?:c(?:o(?:nnec|un)t|(?:al|t)l|reate)|d(?:estroy|isconnect)|get(?:_(?:array|data))?|l(?:ist(?:var)?|ock)|set(?:_(?:array|data))?|un(?:iq|lock)|find|inc|plugin|randstr|timeout)|g_(?:re(?:ceiv|move_queu)e|s(?:e(?:nd|t_queue)|tat_queue)|get_queue)|sql_(?:f(?:etch_assoc|ree_statement)|deadlock_retry_count|set_message_handler|unbuffered_query))|ysql_(?:t(?:able_name|hread_id)|(?:client_encod|p|real_escape_str)ing|info|list_processes|stat)|(?:d5_fil|emory_get_usag)e|oney_format)|n(?:curses_(?:a(?:dd(?:chn?str|n?str)|ssume_default_colors)|bo(?:rder|ttom_panel)|de(?:fine_key|l_panel)|get(?:m(?:axyx|ouse)|yx)|h(?:ide_panel|line)|in(?:ss?tr|it_color)|key(?:ok|pad)|m(?:o(?:use(?:mask|_trafo)|ve_panel)|v(?:add(?:ch(?:n?str)?|n?str)|(?:cu|waddst)r|(?:del|get|in)ch|hline)|eta)|new(?:pad|_panel)|p(?:a(?:nel_(?:above|(?:bel|wind)ow)|ir_content)|(?:nout)?refresh|utp)|re(?:set_(?:prog|shell)_mode|place_panel)|s(?:cr_(?:dump|(?:ini|se)t|restore)|how_panel|lk_set)|t(?:ermname|op_panel)|u(?:ngetmouse|pdate_panels)|w(?:a(?:dd(?:ch|str)|ttr(?:o(?:ff|n)|set))|c(?:lear|olor_set)|mo(?:use_trafo|ve)|stand(?:end|out)|border|(?:eras|[hv]lin)e|(?:getc|(?:nout)?refres)h)|color_content|(?:longnam|vlin)e)|sapi_(?:re(?:quest|sponse)_headers|virtual)|gettext)|o(?:b_(?:get_(?:clean|flush|level|status)|clean|flush|list_handlers)|penssl_(?:csr_(?:export(?:_to_file)?|new|sign)|pkey_(?:export(?:_to_file)?|get_p(?:rivate|ublic)|free|new)|x509_(?:export(?:_to_file)?|check_private_key))|utput_(?:add_rewrite_var|reset_rewrite_vars)|(?:cipasswordchang|dbc_data_sourc)e|verload)|p(?:cntl_(?:alarm|exec)|df_get_m(?:aj|in)orversion|g_(?:c(?:o(?:n(?:nection_(?:busy|reset|status)|vert)|py_(?:from|to))|ancel_query)|escape_(?:bytea|string)|f(?:etch_(?:a(?:ll|ssoc)|result)|ield_(?:n(?:ame|um)|is_null|prtlen|(?:siz|typ)e)|ree_result)|get_(?:notify|pid|result)|l(?:ast_(?:error|oid)|o_(?:c(?:los|reat)e|read(?:_all)?|(?:ex|im)port|open|(?:see|unlin)k|tell|write))|num_(?:field|row)s|result_(?:s(?:eek|tatus)|error)|se(?:lect|nd_query)|u(?:nescape_bytea|pdate)|affected_rows|delete|insert|meta_data|ping|query)|osix_(?:errno|(?:get_last_|str)error)|roc_(?:close|open)|hp_ini_scanned_files)|s(?:e(?:ssion_(?:cache_expire|regenerate_id)|t_include_path)|ha1(?:_file)?|nmp(?:3_(?:[gs]et|(?:real_)?walk)|_(?:set_(?:(?:enum|oid_numeric)_print|valueretrieval)|get_valueretrieval))|ocket_(?:set_(?:block|option)|clear_error|get_option)|tr(?:eam_(?:context_(?:set_(?:option|params)|create|get_options)|filter_(?:ap|pre)pend|se(?:t_(?:blocking|timeout|write_buffer)|lect)|get_meta_data|(?:register_wrapp|wrapper_regist)er)|_(?:rot13|shuffle|word_count))|ybase_(?:deadlock_retry_count|fetch_assoc|set_message_handler|unbuffered_query))|token_(?:get_all|name)|udm_(?:c(?:heck_(?:charset|stored)|lose_stored|rc32)|alloc_agent_array|(?:get_res_field|set_agent_param)_ex|hash32|make_excerpt|open_stored|parse_query_string)|x(?:slt_(?:backend_(?:info|name|version)|set(?:op|_objec)t|getopt)|mlrpc_is_fault|path_register_ns)|yaz_(?:es_result|schema)|restore_include_path|var_export|zlib_get_coding_type))\s*\(/";
?>